/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileFilter;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanelConstants;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.FastScatterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.ChartPropertyEditPanel;
import org.jfree.ui.ExtensionFileFilter;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.Log;
import org.jfree.util.LogContext;

public class ChartPanel
extends JPanel
implements ChartPanelConstants,
ChartChangeListener,
ChartProgressListener,
ActionListener,
MouseListener,
MouseMotionListener,
Printable,
Serializable {
    private JFreeChart chart;
    private List chartMouseListeners;
    private boolean useBuffer;
    private boolean refreshBuffer;
    private Image chartBuffer;
    private int chartBufferHeight;
    private int chartBufferWidth;
    private int minimumDrawWidth;
    private int minimumDrawHeight;
    private int maximumDrawWidth;
    private int maximumDrawHeight;
    private JPopupMenu popup;
    private ChartRenderingInfo info;
    private Point2D anchor;
    private double scaleX;
    private double scaleY;
    private transient Rectangle2D zoomRectangle = null;
    private Point2D zoomPoint = null;
    private boolean fillZoomRectangle = false;
    private boolean horizontalZoom = false;
    private boolean verticalZoom = false;
    private int zoomTriggerDistance;
    private boolean horizontalAxisTrace = false;
    private boolean verticalAxisTrace = false;
    private JMenuItem zoomInBothMenuItem;
    private JMenuItem zoomInHorizontalMenuItem;
    private JMenuItem zoomInVerticalMenuItem;
    private JMenuItem zoomOutBothMenuItem;
    private JMenuItem zoomOutHorizontalMenuItem;
    private JMenuItem zoomOutVerticalMenuItem;
    private JMenuItem autoRangeBothMenuItem;
    private JMenuItem autoRangeHorizontalMenuItem;
    private JMenuItem autoRangeVerticalMenuItem;
    private transient Line2D verticalTraceLine;
    private transient Line2D horizontalTraceLine;
    private boolean enforceFileExtensions;
    private boolean ownToolTipDelaysActive;
    private int originalToolTipInitialDelay;
    private int originalToolTipReshowDelay;
    private int originalToolTipDismissDelay;
    private int ownToolTipInitialDelay;
    private int ownToolTipReshowDelay;
    private int ownToolTipDismissDelay;
    private double zoomInFactor = 0.5;
    private double zoomOutFactor = 2.0;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.LocalizationBundle");
    private static final LogContext LOGGER = Log.createContext((Class)(class$org$jfree$chart$ChartPanel == null ? (class$org$jfree$chart$ChartPanel = ChartPanel.class$("org.jfree.chart.ChartPanel")) : class$org$jfree$chart$ChartPanel));
    private transient Rectangle2D available = new Rectangle2D.Double();
    private transient Rectangle2D chartArea = new Rectangle2D.Double();
    static /* synthetic */ Class class$org$jfree$chart$ChartPanel;

    public ChartPanel(JFreeChart chart) {
        this(chart, 680, 420, 300, 200, 800, 600, false, true, true, true, true, true);
    }

    public ChartPanel(JFreeChart chart, boolean useBuffer) {
        this(chart, 680, 420, 300, 200, 800, 600, useBuffer, true, true, true, true, true);
    }

    public ChartPanel(JFreeChart chart, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        this(chart, 680, 420, 300, 200, 800, 600, false, properties, save, print, zoom, tooltips);
    }

    public ChartPanel(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        this.chart = chart;
        this.chartMouseListeners = new ArrayList();
        if (chart != null) {
            chart.addChangeListener(this);
        }
        this.info = new ChartRenderingInfo();
        this.setPreferredSize(new Dimension(width, height));
        this.useBuffer = useBuffer;
        this.refreshBuffer = false;
        this.minimumDrawWidth = minimumDrawWidth;
        this.minimumDrawHeight = minimumDrawHeight;
        this.maximumDrawWidth = maximumDrawWidth;
        this.maximumDrawHeight = maximumDrawHeight;
        this.zoomTriggerDistance = 10;
        this.popup = null;
        if (properties || save || print || zoom) {
            this.popup = this.createPopupMenu(properties, save, print, zoom);
        }
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.setDisplayToolTips(tooltips);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.enforceFileExtensions = true;
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        this.ownToolTipInitialDelay = ttm.getInitialDelay();
        this.ownToolTipDismissDelay = ttm.getDismissDelay();
        this.ownToolTipReshowDelay = ttm.getReshowDelay();
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart chart) {
        if (this.chart != null) {
            this.chart.removeChangeListener(this);
            this.chart.removeProgressListener(this);
        }
        this.chart = chart;
        if (chart != null) {
            this.chart.addChangeListener(this);
            this.chart.addProgressListener(this);
            Plot plot = chart.getPlot();
            ValueAxis horizontalAxis = this.getHorizontalValueAxis(plot);
            this.horizontalZoom = this.horizontalZoom && horizontalAxis != null;
            ValueAxis verticalAxis = this.getVerticalValueAxis(plot);
            this.verticalZoom = this.verticalZoom && verticalAxis != null;
        } else {
            this.horizontalZoom = false;
            this.verticalZoom = false;
        }
        if (this.useBuffer) {
            this.refreshBuffer = true;
        }
        this.repaint();
    }

    public int getMinimumDrawWidth() {
        return this.minimumDrawWidth;
    }

    public void setMinimumDrawWidth(int width) {
        this.minimumDrawWidth = width;
    }

    public int getMaximumDrawWidth() {
        return this.maximumDrawWidth;
    }

    public void setMaximumDrawWidth(int width) {
        this.maximumDrawWidth = width;
    }

    public void setMinimumDrawHeight(int height) {
        this.minimumDrawHeight = height;
    }

    public int getMinimumDrawHeight() {
        return this.minimumDrawHeight;
    }

    public int getMaximumDrawHeight() {
        return this.maximumDrawHeight;
    }

    public void setMaximumDrawHeight(int height) {
        this.maximumDrawHeight = height;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    public void setPopupMenu(JPopupMenu popup) {
        this.popup = popup;
    }

    public ChartRenderingInfo getChartRenderingInfo() {
        return this.info;
    }

    public void setMouseZoomable(boolean flag) {
        this.setMouseZoomable(flag, true);
    }

    public void setMouseZoomable(boolean flag, boolean fillRectangle) {
        this.setHorizontalZoom(flag);
        this.setVerticalZoom(flag);
        this.setFillZoomRectangle(fillRectangle);
    }

    public void setHorizontalZoom(boolean flag) {
        Plot plot = this.chart.getPlot();
        ValueAxis axis = this.getHorizontalValueAxis(plot);
        this.horizontalZoom = flag && axis != null;
    }

    public void setFillZoomRectangle(boolean flag) {
        this.fillZoomRectangle = flag;
    }

    public void setVerticalZoom(boolean flag) {
        Plot plot = this.chart.getPlot();
        ValueAxis axis = this.getVerticalValueAxis(plot);
        this.verticalZoom = flag && axis != null;
    }

    public int getZoomTriggerDistance() {
        return this.zoomTriggerDistance;
    }

    public void setZoomTriggerDistance(int distance) {
        this.zoomTriggerDistance = distance;
    }

    public void setHorizontalAxisTrace(boolean flag) {
        this.horizontalAxisTrace = flag;
    }

    public void setVerticalAxisTrace(boolean flag) {
        this.verticalAxisTrace = flag;
    }

    public boolean isEnforceFileExtensions() {
        return this.enforceFileExtensions;
    }

    public void setEnforceFileExtensions(boolean enforce) {
        this.enforceFileExtensions = enforce;
    }

    public void setDisplayToolTips(boolean flag) {
        if (flag) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    public String getToolTipText(MouseEvent e) {
        EntityCollection entities;
        String result = null;
        if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
            Insets insets = this.getInsets();
            ChartEntity entity = entities.getEntity((int)((double)(e.getX() - insets.left) / this.scaleX), (int)((double)(e.getY() - insets.top) / this.scaleY));
            if (entity != null) {
                result = entity.getToolTipText();
            }
        }
        return result;
    }

    public Point translateJava2DToScreen(Point2D java2DPoint) {
        Insets insets = this.getInsets();
        int x = (int)(java2DPoint.getX() * this.scaleX + (double)insets.left);
        int y = (int)(java2DPoint.getY() * this.scaleY + (double)insets.top);
        return new Point(x, y);
    }

    public Point2D translateScreenToJava2D(Point screenPoint) {
        Insets insets = this.getInsets();
        double x = (screenPoint.getX() - (double)insets.left) / this.scaleX;
        double y = (screenPoint.getY() - (double)insets.top) / this.scaleY;
        return new Point2D.Double(x, y);
    }

    public ChartEntity getEntityForPoint(int viewX, int viewY) {
        ChartEntity result = null;
        if (this.info != null) {
            Insets insets = this.getInsets();
            double x = (double)(viewX - insets.left) / this.scaleX;
            double y = (double)(viewY - insets.top) / this.scaleY;
            EntityCollection entities = this.info.getEntityCollection();
            result = entities != null ? entities.getEntity(x, y) : null;
        }
        return result;
    }

    public void setRefreshBuffer(boolean flag) {
        this.refreshBuffer = flag;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.chart == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        this.available.setRect(insets.left, insets.top, size.getWidth() - (double)insets.left - (double)insets.right, size.getHeight() - (double)insets.top - (double)insets.bottom);
        boolean scale = false;
        double drawWidth = this.available.getWidth();
        double drawHeight = this.available.getHeight();
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        if (drawWidth < (double)this.minimumDrawWidth) {
            this.scaleX = drawWidth / (double)this.minimumDrawWidth;
            drawWidth = this.minimumDrawWidth;
            scale = true;
        } else if (drawWidth > (double)this.maximumDrawWidth) {
            this.scaleX = drawWidth / (double)this.maximumDrawWidth;
            drawWidth = this.maximumDrawWidth;
            scale = true;
        }
        if (drawHeight < (double)this.minimumDrawHeight) {
            this.scaleY = drawHeight / (double)this.minimumDrawHeight;
            drawHeight = this.minimumDrawHeight;
            scale = true;
        } else if (drawHeight > (double)this.maximumDrawHeight) {
            this.scaleY = drawHeight / (double)this.maximumDrawHeight;
            drawHeight = this.maximumDrawHeight;
            scale = true;
        }
        this.chartArea.setRect(0.0, 0.0, drawWidth, drawHeight);
        if (this.useBuffer) {
            if (this.chartBuffer == null || (double)this.chartBufferWidth != this.available.getWidth() || (double)this.chartBufferHeight != this.available.getHeight()) {
                this.chartBufferWidth = (int)this.available.getWidth();
                this.chartBufferHeight = (int)this.available.getHeight();
                this.chartBuffer = this.createImage(this.chartBufferWidth, this.chartBufferHeight);
                this.refreshBuffer = true;
            }
            if (this.refreshBuffer) {
                Rectangle2D.Double bufferArea = new Rectangle2D.Double(0.0, 0.0, this.chartBufferWidth, this.chartBufferHeight);
                Graphics2D bufferG2 = (Graphics2D)this.chartBuffer.getGraphics();
                if (scale) {
                    AffineTransform saved = bufferG2.getTransform();
                    AffineTransform st = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
                    bufferG2.transform(st);
                    this.chart.draw(bufferG2, this.chartArea, this.anchor, this.info);
                    bufferG2.setTransform(saved);
                } else {
                    this.chart.draw(bufferG2, bufferArea, this.anchor, this.info);
                }
                this.refreshBuffer = false;
            }
            g2.drawImage(this.chartBuffer, insets.left, insets.right, this);
        } else {
            AffineTransform saved = g2.getTransform();
            g2.translate(insets.left, insets.top);
            if (scale) {
                AffineTransform st = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
                g2.transform(st);
            }
            this.chart.draw(g2, this.chartArea, this.anchor, this.info);
            g2.setTransform(saved);
        }
        this.anchor = null;
        this.verticalTraceLine = null;
        this.horizontalTraceLine = null;
    }

    public void chartChanged(ChartChangeEvent event) {
        this.refreshBuffer = true;
        this.repaint();
    }

    public void chartProgress(ChartProgressEvent event) {
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("PROPERTIES")) {
            this.attemptEditChartProperties();
        } else if (command.equals("SAVE")) {
            try {
                this.doSaveAs();
            }
            catch (IOException e) {
                System.err.println("ChartPanel.doSaveAs: i/o exception = " + e.getMessage());
            }
        } else if (command.equals("PRINT")) {
            this.createChartPrintJob();
        } else if (command.equals("ZOOM_IN_BOTH")) {
            this.zoomInBoth(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (command.equals("ZOOM_IN_HORIZONTAL")) {
            this.zoomInHorizontal(this.zoomPoint.getX());
        } else if (command.equals("ZOOM_IN_VERTICAL")) {
            this.zoomInVertical(this.zoomPoint.getY());
        } else if (command.equals("ZOOM_OUT_BOTH")) {
            this.zoomOutBoth(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (command.equals("ZOOM_HORIZONTAL_BOTH")) {
            this.zoomOutHorizontal(this.zoomPoint.getX());
        } else if (command.equals("ZOOM_VERTICAL_BOTH")) {
            this.zoomOutVertical(this.zoomPoint.getY());
        } else if (command.equals("AUTO_RANGE_BOTH")) {
            this.autoRangeBoth();
        } else if (command.equals("AUTO_RANGE_HORIZONTAL")) {
            this.autoRangeHorizontal();
        } else if (command.equals("AUTO_RANGE_VERTICAL")) {
            this.autoRangeVertical();
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.ownToolTipDelaysActive) {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            this.originalToolTipInitialDelay = ttm.getInitialDelay();
            ttm.setInitialDelay(this.ownToolTipInitialDelay);
            this.originalToolTipReshowDelay = ttm.getReshowDelay();
            ttm.setReshowDelay(this.ownToolTipReshowDelay);
            this.originalToolTipDismissDelay = ttm.getDismissDelay();
            ttm.setDismissDelay(this.ownToolTipDismissDelay);
            this.ownToolTipDelaysActive = true;
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.ownToolTipDelaysActive) {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            ttm.setInitialDelay(this.originalToolTipInitialDelay);
            ttm.setReshowDelay(this.originalToolTipReshowDelay);
            ttm.setDismissDelay(this.originalToolTipDismissDelay);
            this.ownToolTipDelaysActive = false;
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.zoomRectangle == null) {
            this.zoomPoint = RefineryUtilities.getPointInRectangle((double)e.getX(), (double)e.getY(), (Rectangle2D)this.getScaledDataArea());
            LOGGER.debug((Object)"In mousePressed()");
            LOGGER.debug((Object)("getScaledDataArea() = " + this.getScaledDataArea()));
            LOGGER.debug((Object)("this.zoomPoint = " + this.zoomPoint));
            if (e.isPopupTrigger() && this.popup != null) {
                this.displayPopupMenu(e.getX(), e.getY());
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        LOGGER.debug((Object)"In mouseReleased()");
        LOGGER.debug((Object)("this.zoomRectangle = " + this.zoomRectangle));
        if (this.zoomRectangle != null) {
            boolean zoomTrigger2;
            boolean zoomTrigger1 = this.horizontalZoom && Math.abs((double)e.getX() - this.zoomPoint.getX()) >= (double)this.zoomTriggerDistance;
            boolean bl = zoomTrigger2 = this.verticalZoom && Math.abs((double)e.getY() - this.zoomPoint.getY()) >= (double)this.zoomTriggerDistance;
            if (zoomTrigger1 || zoomTrigger2) {
                if (this.horizontalZoom && (double)e.getX() < this.zoomPoint.getX() || this.verticalZoom && (double)e.getY() < this.zoomPoint.getY()) {
                    this.autoRangeBoth();
                } else {
                    double h;
                    double w;
                    double y;
                    double x;
                    Rectangle2D scaledDataArea = this.getScaledDataArea();
                    if (!this.verticalZoom) {
                        x = this.zoomPoint.getX();
                        y = scaledDataArea.getMinY();
                        w = Math.min(this.zoomRectangle.getWidth(), scaledDataArea.getMaxX() - this.zoomPoint.getX());
                        h = scaledDataArea.getHeight();
                    } else if (!this.horizontalZoom) {
                        x = scaledDataArea.getMinX();
                        y = this.zoomPoint.getY();
                        w = scaledDataArea.getWidth();
                        h = Math.min(this.zoomRectangle.getHeight(), scaledDataArea.getMaxY() - this.zoomPoint.getY());
                    } else {
                        x = this.zoomPoint.getX();
                        y = this.zoomPoint.getY();
                        w = Math.min(this.zoomRectangle.getWidth(), scaledDataArea.getMaxX() - this.zoomPoint.getX());
                        h = Math.min(this.zoomRectangle.getHeight(), scaledDataArea.getMaxY() - this.zoomPoint.getY());
                    }
                    Rectangle2D.Double zoomArea = new Rectangle2D.Double(x, y, w, h);
                    Log.debug((Object)("zoomArea = " + zoomArea));
                    this.zoom(zoomArea);
                }
                this.zoomPoint = null;
                this.zoomRectangle = null;
            } else {
                Graphics2D g2 = (Graphics2D)this.getGraphics();
                g2.setXORMode(Color.gray);
                if (this.fillZoomRectangle) {
                    g2.fill(this.zoomRectangle);
                } else {
                    g2.draw(this.zoomRectangle);
                }
                g2.dispose();
                this.zoomRectangle = null;
            }
        } else if (e.isPopupTrigger() && this.popup != null) {
            this.displayPopupMenu(e.getX(), e.getY());
        }
    }

    public void mouseClicked(MouseEvent event) {
        EntityCollection entities;
        Insets insets = this.getInsets();
        int x = (int)((double)(event.getX() - insets.left) / this.scaleX);
        int y = (int)((double)(event.getY() - insets.top) / this.scaleY);
        this.anchor = new Point2D.Double(x, y);
        this.chart.setTitle(this.chart.getTitle());
        if (this.chartMouseListeners.isEmpty()) {
            return;
        }
        ChartEntity entity = null;
        if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
            entity = entities.getEntity(x, y);
        }
        ChartMouseEvent chartEvent = new ChartMouseEvent(this.getChart(), event, entity);
        Iterator iterator = this.chartMouseListeners.iterator();
        while (iterator.hasNext()) {
            ChartMouseListener listener = (ChartMouseListener)iterator.next();
            listener.chartMouseClicked(chartEvent);
        }
    }

    public void mouseMoved(MouseEvent e) {
        EntityCollection entities;
        if (this.horizontalAxisTrace) {
            this.drawHorizontalAxisTrace(e.getX());
        }
        if (this.verticalAxisTrace) {
            this.drawVerticalAxisTrace(e.getY());
        }
        if (this.chartMouseListeners.isEmpty()) {
            return;
        }
        Insets insets = this.getInsets();
        int x = (int)((double)(e.getX() - insets.left) / this.scaleX);
        int y = (int)((double)(e.getY() - insets.top) / this.scaleY);
        ChartEntity entity = null;
        if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
            entity = entities.getEntity(x, y);
        }
        ChartMouseEvent event = new ChartMouseEvent(this.getChart(), e, entity);
        Iterator iterator = this.chartMouseListeners.iterator();
        while (iterator.hasNext()) {
            ChartMouseListener listener = (ChartMouseListener)iterator.next();
            listener.chartMouseMoved(event);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.popup != null && this.popup.isShowing()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        g2.setXORMode(Color.gray);
        if (this.zoomRectangle != null) {
            if (this.fillZoomRectangle) {
                g2.fill(this.zoomRectangle);
            } else {
                g2.draw(this.zoomRectangle);
            }
        }
        Rectangle2D scaledDataArea = this.getScaledDataArea();
        if (this.horizontalZoom && this.verticalZoom) {
            double xmax = Math.min((double)e.getX(), scaledDataArea.getMaxX());
            double ymax = Math.min((double)e.getY(), scaledDataArea.getMaxY());
            this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), this.zoomPoint.getY(), xmax - this.zoomPoint.getX(), ymax - this.zoomPoint.getY());
        } else if (this.horizontalZoom) {
            double xmax = Math.min((double)e.getX(), scaledDataArea.getMaxX());
            this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), scaledDataArea.getMinY(), xmax - this.zoomPoint.getX(), scaledDataArea.getHeight());
        } else if (this.verticalZoom) {
            double ymax = Math.min((double)e.getY(), scaledDataArea.getMaxY());
            this.zoomRectangle = new Rectangle2D.Double(scaledDataArea.getMinX(), this.zoomPoint.getY(), scaledDataArea.getWidth(), ymax - this.zoomPoint.getY());
        }
        if (this.zoomRectangle != null) {
            if (this.fillZoomRectangle) {
                g2.fill(this.zoomRectangle);
            } else {
                g2.draw(this.zoomRectangle);
            }
        }
        g2.dispose();
    }

    public void zoomInBoth(double x, double y) {
        this.zoomInHorizontal(x);
        this.zoomInVertical(y);
    }

    private ValueAxis getHorizontalValueAxis(Plot plot) {
        CategoryPlot cp;
        if (plot == null) {
            return null;
        }
        ValueAxis axis = null;
        if (plot instanceof CategoryPlot && (cp = (CategoryPlot)plot).getOrientation() == PlotOrientation.HORIZONTAL) {
            axis = cp.getRangeAxis();
        }
        if (plot instanceof XYPlot) {
            XYPlot xyp = (XYPlot)plot;
            if (xyp.getOrientation() == PlotOrientation.HORIZONTAL) {
                axis = xyp.getRangeAxis();
            } else if (xyp.getOrientation() == PlotOrientation.VERTICAL) {
                axis = xyp.getDomainAxis();
            }
        }
        if (plot instanceof FastScatterPlot) {
            FastScatterPlot fsp = (FastScatterPlot)plot;
            axis = fsp.getDomainAxis();
        }
        return axis;
    }

    private ValueAxis getVerticalValueAxis(Plot plot) {
        CategoryPlot cp;
        if (plot == null) {
            return null;
        }
        ValueAxis axis = null;
        if (plot instanceof CategoryPlot && (cp = (CategoryPlot)plot).getOrientation() == PlotOrientation.VERTICAL) {
            axis = cp.getRangeAxis();
        }
        if (plot instanceof XYPlot) {
            XYPlot xyp = (XYPlot)plot;
            if (xyp.getOrientation() == PlotOrientation.HORIZONTAL) {
                axis = xyp.getDomainAxis();
            } else if (xyp.getOrientation() == PlotOrientation.VERTICAL) {
                axis = xyp.getRangeAxis();
            }
        }
        if (plot instanceof FastScatterPlot) {
            FastScatterPlot fsp = (FastScatterPlot)plot;
            axis = fsp.getRangeAxis();
        }
        return axis;
    }

    public void zoomInHorizontal(double x) {
        Plot p = this.chart.getPlot();
        if (p instanceof ValueAxisPlot) {
            ValueAxisPlot plot = (ValueAxisPlot)((Object)p);
            plot.zoomHorizontalAxes(this.zoomInFactor);
        }
    }

    public void zoomInVertical(double y) {
        Plot p = this.chart.getPlot();
        if (p instanceof ValueAxisPlot) {
            ValueAxisPlot plot = (ValueAxisPlot)((Object)p);
            plot.zoomVerticalAxes(this.zoomInFactor);
        }
    }

    public void zoomOutBoth(double x, double y) {
        this.zoomOutHorizontal(x);
        this.zoomOutVertical(y);
    }

    public void zoomOutHorizontal(double x) {
        Plot p = this.chart.getPlot();
        if (p instanceof ValueAxisPlot) {
            ValueAxisPlot plot = (ValueAxisPlot)((Object)p);
            plot.zoomHorizontalAxes(this.zoomOutFactor);
        }
    }

    public void zoomOutVertical(double y) {
        Plot p = this.chart.getPlot();
        if (p instanceof ValueAxisPlot) {
            ValueAxisPlot plot = (ValueAxisPlot)((Object)p);
            plot.zoomVerticalAxes(this.zoomOutFactor);
        }
    }

    public void zoom(Rectangle2D selection) {
        double hLower = 0.0;
        double hUpper = 0.0;
        double vLower = 0.0;
        double vUpper = 0.0;
        if (selection.getHeight() > 0.0 && selection.getWidth() > 0.0) {
            Rectangle2D scaledDataArea = this.getScaledDataArea();
            hLower = (selection.getMinX() - scaledDataArea.getMinX()) / scaledDataArea.getWidth();
            hUpper = (selection.getMaxX() - scaledDataArea.getMinX()) / scaledDataArea.getWidth();
            vLower = (scaledDataArea.getMaxY() - selection.getMaxY()) / scaledDataArea.getHeight();
            vUpper = (scaledDataArea.getMaxY() - selection.getMinY()) / scaledDataArea.getHeight();
            LOGGER.debug((Object)("hLower = " + hLower));
            LOGGER.debug((Object)("hUpper = " + hUpper));
            LOGGER.debug((Object)("vLower = " + vLower));
            LOGGER.debug((Object)("vUpper = " + vUpper));
            Plot p = this.chart.getPlot();
            if (p instanceof ValueAxisPlot) {
                ValueAxisPlot plot = (ValueAxisPlot)((Object)p);
                plot.zoomHorizontalAxes(hLower, hUpper);
                plot.zoomVerticalAxes(vLower, vUpper);
            }
        }
    }

    public void autoRangeBoth() {
        this.autoRangeHorizontal();
        this.autoRangeVertical();
    }

    public void autoRangeHorizontal() {
        Plot p = this.chart.getPlot();
        if (p instanceof ValueAxisPlot) {
            ValueAxisPlot plot = (ValueAxisPlot)((Object)p);
            plot.zoomHorizontalAxes(0.0);
        }
    }

    public void autoRangeVertical() {
        Plot p = this.chart.getPlot();
        if (p instanceof ValueAxisPlot) {
            ValueAxisPlot plot = (ValueAxisPlot)((Object)p);
            plot.zoomVerticalAxes(0.0);
        }
    }

    public Rectangle2D getScaledDataArea() {
        Rectangle2D dataArea = this.info.getPlotInfo().getDataArea();
        Insets insets = this.getInsets();
        double x = dataArea.getX() * this.scaleX + (double)insets.left;
        double y = dataArea.getY() * this.scaleY + (double)insets.top;
        double w = dataArea.getWidth() * this.scaleX;
        double h = dataArea.getHeight() * this.scaleY;
        return new Rectangle2D.Double(x, y, w, h);
    }

    public int getInitialDelay() {
        return this.ownToolTipInitialDelay;
    }

    public int getReshowDelay() {
        return this.ownToolTipReshowDelay;
    }

    public int getDismissDelay() {
        return this.ownToolTipDismissDelay;
    }

    public void setInitialDelay(int delay) {
        this.ownToolTipInitialDelay = delay;
    }

    public void setReshowDelay(int delay) {
        this.ownToolTipReshowDelay = delay;
    }

    public void setDismissDelay(int delay) {
        this.ownToolTipDismissDelay = delay;
    }

    public double getZoomInFactor() {
        return this.zoomInFactor;
    }

    public void setZoomInFactor(double factor) {
        this.zoomInFactor = factor;
    }

    public double getZoomOutFactor() {
        return this.zoomOutFactor;
    }

    public void setZoomOutFactor(double factor) {
        this.zoomOutFactor = factor;
    }

    private void drawHorizontalAxisTrace(int x) {
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        Rectangle2D dataArea = this.getScaledDataArea();
        g2.setXORMode(Color.orange);
        if ((int)dataArea.getMinX() < x && x < (int)dataArea.getMaxX()) {
            if (this.verticalTraceLine != null) {
                g2.draw(this.verticalTraceLine);
                this.verticalTraceLine.setLine(x, (int)dataArea.getMinY(), x, (int)dataArea.getMaxY());
            } else {
                this.verticalTraceLine = new Line2D.Float(x, (int)dataArea.getMinY(), x, (int)dataArea.getMaxY());
            }
            g2.draw(this.verticalTraceLine);
        }
    }

    private void drawVerticalAxisTrace(int y) {
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        Rectangle2D dataArea = this.getScaledDataArea();
        g2.setXORMode(Color.orange);
        if ((int)dataArea.getMinY() < y && y < (int)dataArea.getMaxY()) {
            if (this.horizontalTraceLine != null) {
                g2.draw(this.horizontalTraceLine);
                this.horizontalTraceLine.setLine((int)dataArea.getMinX(), y, (int)dataArea.getMaxX(), y);
            } else {
                this.horizontalTraceLine = new Line2D.Float((int)dataArea.getMinX(), y, (int)dataArea.getMaxX(), y);
            }
            g2.draw(this.horizontalTraceLine);
        }
    }

    private void attemptEditChartProperties() {
        ChartPropertyEditPanel panel = new ChartPropertyEditPanel(this.chart);
        int result = JOptionPane.showConfirmDialog(this, panel, localizationResources.getString("Chart_Properties"), 2, -1);
        if (result == 0) {
            panel.updateChartProperties(this.chart);
        }
    }

    public void doSaveAs() throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        ExtensionFileFilter filter = new ExtensionFileFilter(localizationResources.getString("PNG_Image_Files"), ".png");
        fileChooser.addChoosableFileFilter((FileFilter)filter);
        fileChooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter("All files", ""));
        int option = fileChooser.showSaveDialog(this);
        if (option == 0) {
            String filename = fileChooser.getSelectedFile().getPath();
            if (this.isEnforceFileExtensions() && !filename.endsWith(".png")) {
                filename = filename + ".png";
            }
            ChartUtilities.saveChartAsPNG(new File(filename), this.chart, this.getWidth(), this.getHeight());
        }
    }

    public void createChartPrintJob() {
        PageFormat pf;
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pf2 = job.pageDialog(pf = job.defaultPage());
        if (pf2 != pf) {
            job.setPrintable(this, pf2);
            if (job.printDialog()) {
                try {
                    job.print();
                }
                catch (PrinterException e) {
                    JOptionPane.showMessageDialog(this, e);
                }
            }
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        double x = pf.getImageableX();
        double y = pf.getImageableY();
        double w = pf.getImageableWidth();
        double h = pf.getImageableHeight();
        this.chart.draw(g2, new Rectangle2D.Double(x, y, w, h), this.anchor, null);
        return 0;
    }

    public void addChartMouseListener(ChartMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.chartMouseListeners.add(listener);
    }

    public void removeChartMouseListener(ChartMouseListener listener) {
        this.chartMouseListeners.remove(listener);
    }

    protected JPopupMenu createPopupMenu(boolean properties, boolean save, boolean print, boolean zoom) {
        JPopupMenu result = new JPopupMenu("Chart:");
        boolean separator = false;
        if (properties) {
            JMenuItem propertiesItem = new JMenuItem(localizationResources.getString("Properties..."));
            propertiesItem.setActionCommand("PROPERTIES");
            propertiesItem.addActionListener(this);
            result.add(propertiesItem);
            separator = true;
        }
        if (save) {
            if (separator) {
                result.addSeparator();
                separator = false;
            }
            JMenuItem saveItem = new JMenuItem(localizationResources.getString("Save_as..."));
            saveItem.setActionCommand("SAVE");
            saveItem.addActionListener(this);
            result.add(saveItem);
            separator = true;
        }
        if (print) {
            if (separator) {
                result.addSeparator();
                separator = false;
            }
            JMenuItem printItem = new JMenuItem(localizationResources.getString("Print..."));
            printItem.setActionCommand("PRINT");
            printItem.addActionListener(this);
            result.add(printItem);
            separator = true;
        }
        if (zoom) {
            if (separator) {
                result.addSeparator();
                separator = false;
            }
            JMenu zoomInMenu = new JMenu(localizationResources.getString("Zoom_In"));
            this.zoomInBothMenuItem = new JMenuItem(localizationResources.getString("All_Axes"));
            this.zoomInBothMenuItem.setActionCommand("ZOOM_IN_BOTH");
            this.zoomInBothMenuItem.addActionListener(this);
            zoomInMenu.add(this.zoomInBothMenuItem);
            zoomInMenu.addSeparator();
            this.zoomInHorizontalMenuItem = new JMenuItem(localizationResources.getString("Horizontal_Axis"));
            this.zoomInHorizontalMenuItem.setActionCommand("ZOOM_IN_HORIZONTAL");
            this.zoomInHorizontalMenuItem.addActionListener(this);
            zoomInMenu.add(this.zoomInHorizontalMenuItem);
            this.zoomInVerticalMenuItem = new JMenuItem(localizationResources.getString("Vertical_Axis"));
            this.zoomInVerticalMenuItem.setActionCommand("ZOOM_IN_VERTICAL");
            this.zoomInVerticalMenuItem.addActionListener(this);
            zoomInMenu.add(this.zoomInVerticalMenuItem);
            result.add(zoomInMenu);
            JMenu zoomOutMenu = new JMenu(localizationResources.getString("Zoom_Out"));
            this.zoomOutBothMenuItem = new JMenuItem(localizationResources.getString("All_Axes"));
            this.zoomOutBothMenuItem.setActionCommand("ZOOM_OUT_BOTH");
            this.zoomOutBothMenuItem.addActionListener(this);
            zoomOutMenu.add(this.zoomOutBothMenuItem);
            zoomOutMenu.addSeparator();
            this.zoomOutHorizontalMenuItem = new JMenuItem(localizationResources.getString("Horizontal_Axis"));
            this.zoomOutHorizontalMenuItem.setActionCommand("ZOOM_HORIZONTAL_BOTH");
            this.zoomOutHorizontalMenuItem.addActionListener(this);
            zoomOutMenu.add(this.zoomOutHorizontalMenuItem);
            this.zoomOutVerticalMenuItem = new JMenuItem(localizationResources.getString("Vertical_Axis"));
            this.zoomOutVerticalMenuItem.setActionCommand("ZOOM_VERTICAL_BOTH");
            this.zoomOutVerticalMenuItem.addActionListener(this);
            zoomOutMenu.add(this.zoomOutVerticalMenuItem);
            result.add(zoomOutMenu);
            JMenu autoRangeMenu = new JMenu(localizationResources.getString("Auto_Range"));
            this.autoRangeBothMenuItem = new JMenuItem(localizationResources.getString("All_Axes"));
            this.autoRangeBothMenuItem.setActionCommand("AUTO_RANGE_BOTH");
            this.autoRangeBothMenuItem.addActionListener(this);
            autoRangeMenu.add(this.autoRangeBothMenuItem);
            autoRangeMenu.addSeparator();
            this.autoRangeHorizontalMenuItem = new JMenuItem(localizationResources.getString("Horizontal_Axis"));
            this.autoRangeHorizontalMenuItem.setActionCommand("AUTO_RANGE_HORIZONTAL");
            this.autoRangeHorizontalMenuItem.addActionListener(this);
            autoRangeMenu.add(this.autoRangeHorizontalMenuItem);
            this.autoRangeVerticalMenuItem = new JMenuItem(localizationResources.getString("Vertical_Axis"));
            this.autoRangeVerticalMenuItem.setActionCommand("AUTO_RANGE_VERTICAL");
            this.autoRangeVerticalMenuItem.addActionListener(this);
            autoRangeMenu.add(this.autoRangeVerticalMenuItem);
            result.addSeparator();
            result.add(autoRangeMenu);
        }
        return result;
    }

    protected void displayPopupMenu(int x, int y) {
        if (this.popup != null) {
            boolean isVertical;
            Plot plot = this.chart.getPlot();
            ValueAxis horizontalAxis = this.getHorizontalValueAxis(plot);
            boolean isHorizontal = horizontalAxis != null;
            ValueAxis verticalAxis = this.getVerticalValueAxis(plot);
            boolean bl = isVertical = verticalAxis != null;
            if (this.zoomInHorizontalMenuItem != null) {
                this.zoomInHorizontalMenuItem.setEnabled(isHorizontal);
            }
            if (this.zoomOutHorizontalMenuItem != null) {
                this.zoomOutHorizontalMenuItem.setEnabled(isHorizontal);
            }
            if (this.autoRangeHorizontalMenuItem != null) {
                this.autoRangeHorizontalMenuItem.setEnabled(isHorizontal);
            }
            if (this.zoomInVerticalMenuItem != null) {
                this.zoomInVerticalMenuItem.setEnabled(isVertical);
            }
            if (this.zoomOutVerticalMenuItem != null) {
                this.zoomOutVerticalMenuItem.setEnabled(isVertical);
            }
            if (this.autoRangeVerticalMenuItem != null) {
                this.autoRangeVerticalMenuItem.setEnabled(isVertical);
            }
            if (this.zoomInBothMenuItem != null) {
                this.zoomInBothMenuItem.setEnabled(isHorizontal & isVertical);
            }
            if (this.zoomOutBothMenuItem != null) {
                this.zoomOutBothMenuItem.setEnabled(isHorizontal & isVertical);
            }
            if (this.autoRangeBothMenuItem != null) {
                this.autoRangeBothMenuItem.setEnabled(isHorizontal & isVertical);
            }
            this.popup.show(this, x, y);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.available = new Rectangle2D.Double();
        this.chartArea = new Rectangle2D.Double();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

