/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.DrawableLegendItem;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Legend;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendRenderingOrder;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.event.LegendChangeEvent;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.Spacer;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Log;
import org.jfree.util.LogContext;
import org.jfree.util.ObjectUtils;

public class StandardLegend
extends Legend
implements Serializable {
    public static final Spacer DEFAULT_OUTER_GAP = new Spacer(1, 3.0, 3.0, 3.0, 3.0);
    public static final Spacer DEFAULT_INNER_GAP = new Spacer(1, 2.0, 2.0, 2.0, 2.0);
    public static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke();
    public static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    public static final Paint DEFAULT_BACKGROUND_PAINT = Color.white;
    public static final Font DEFAULT_TITLE_FONT = new Font("SansSerif", 1, 11);
    public static final Font DEFAULT_ITEM_FONT = new Font("SansSerif", 0, 10);
    public static final double NO_PREFERRED_WIDTH = Double.MAX_VALUE;
    private static final String UNEXPECTED_LEGEND_ANCHOR = "Unexpected legend anchor";
    private Spacer outerGap;
    private transient Stroke outlineStroke;
    private transient Paint outlinePaint;
    private transient Paint backgroundPaint;
    private Spacer innerGap;
    private String title = null;
    private Font titleFont;
    private Font itemFont;
    private transient Paint itemPaint;
    private boolean outlineShapes;
    private transient Stroke shapeOutlineStroke = new BasicStroke(0.5f);
    private transient Paint shapeOutlinePaint = Color.lightGray;
    private boolean displaySeriesShapes = false;
    private double shapeScaleX = 1.0;
    private double shapeScaleY = 1.0;
    private boolean displaySeriesLines = false;
    private LegendRenderingOrder renderingOrder = LegendRenderingOrder.STANDARD;
    private int boundingBoxArcWidth = 0;
    private int boundingBoxArcHeight = 0;
    private double preferredWidth = Double.MAX_VALUE;
    private static final LogContext LOGGER = Log.createContext((Class)(class$org$jfree$chart$StandardLegend == null ? (class$org$jfree$chart$StandardLegend = StandardLegend.class$("org.jfree.chart.StandardLegend")) : class$org$jfree$chart$StandardLegend));
    static /* synthetic */ Class class$org$jfree$chart$StandardLegend;

    public StandardLegend() {
        this.outerGap = DEFAULT_OUTER_GAP;
        this.innerGap = DEFAULT_INNER_GAP;
        this.backgroundPaint = DEFAULT_BACKGROUND_PAINT;
        this.outlineStroke = DEFAULT_OUTLINE_STROKE;
        this.outlinePaint = DEFAULT_OUTLINE_PAINT;
        this.titleFont = DEFAULT_TITLE_FONT;
        this.itemFont = DEFAULT_ITEM_FONT;
        this.itemPaint = Color.black;
    }

    public StandardLegend(JFreeChart chart) {
        this();
    }

    public Spacer getOuterGap() {
        return this.outerGap;
    }

    public void setOuterGap(Spacer outerGap) {
        if (outerGap == null) {
            throw new NullPointerException("Null 'outerGap' argument.");
        }
        this.outerGap = outerGap;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Spacer getInnerGap() {
        return this.innerGap;
    }

    public void setInnerGap(Spacer innerGap) {
        if (innerGap == null) {
            throw new NullPointerException("Null 'innerGap' argument.");
        }
        this.innerGap = innerGap;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.backgroundPaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new NullPointerException("Null 'stroke' argument.");
        }
        this.outlineStroke = stroke;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.outlinePaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.titleFont = font;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Font getItemFont() {
        return this.itemFont;
    }

    public void setItemFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.itemFont = font;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getItemPaint() {
        return this.itemPaint;
    }

    public void setItemPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.itemPaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public boolean getOutlineShapes() {
        return this.outlineShapes;
    }

    public void setOutlineShapes(boolean flag) {
        this.outlineShapes = flag;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Stroke getShapeOutlineStroke() {
        return this.shapeOutlineStroke;
    }

    public void setShapeOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new NullPointerException("Null 'stroke' argument");
        }
        this.shapeOutlineStroke = stroke;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getShapeOutlinePaint() {
        return this.shapeOutlinePaint;
    }

    public void setShapeOutlinePaint(Paint paint) {
        this.shapeOutlinePaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public void setDisplaySeriesShapes(boolean flag) {
        this.displaySeriesShapes = flag;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public boolean getDisplaySeriesShapes() {
        return this.displaySeriesShapes;
    }

    public double getShapeScaleX() {
        return this.shapeScaleX;
    }

    public void setShapeScaleX(double factor) {
        this.shapeScaleX = factor;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public double getShapeScaleY() {
        return this.shapeScaleY;
    }

    public void setShapeScaleY(double factor) {
        this.shapeScaleY = factor;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public void setDisplaySeriesLines(boolean flag) {
        this.displaySeriesLines = flag;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public boolean getDisplaySeriesLines() {
        return this.displaySeriesLines;
    }

    public LegendRenderingOrder getRenderingOrder() {
        return this.renderingOrder;
    }

    public void setRenderingOrder(LegendRenderingOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.renderingOrder = order;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public int getBoundingBoxArcWidth() {
        return this.boundingBoxArcWidth;
    }

    public void setBoundingBoxArcWidth(int arcWidth) {
        this.boundingBoxArcWidth = arcWidth;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public int getBoundingBoxArcHeight() {
        return this.boundingBoxArcHeight;
    }

    public void setBoundingBoxArcHeight(int arcHeight) {
        this.boundingBoxArcHeight = arcHeight;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public double getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(double width) {
        this.preferredWidth = width;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Rectangle2D draw(Graphics2D g2, Rectangle2D available, ChartRenderingInfo info) {
        return this.draw(g2, available, (this.getAnchor() & 1) != 0, (this.getAnchor() & 2) != 0, info);
    }

    protected Rectangle2D draw(Graphics2D g2, Rectangle2D available, boolean horizontal, boolean inverted, ChartRenderingInfo info) {
        Point2D translation;
        RoundRectangle2D legendArea;
        LegendItemCollection legendItems = this.getChart().getPlot().getLegendItems();
        if (legendItems == null || legendItems.getItemCount() == 0) {
            return available;
        }
        DrawableLegendItem legendTitle = null;
        LegendItem titleItem = null;
        if (this.title != null && !this.title.equals("")) {
            titleItem = new LegendItem(this.title, this.title, null, true, Color.black, new BasicStroke(1.0f), Color.black, new BasicStroke(1.0f));
        }
        double availableWidth = available.getWidth();
        ArrayList<DrawableLegendItem> items = new ArrayList<DrawableLegendItem>();
        if (horizontal) {
            double xstart = available.getX() + this.getOuterGap().getLeftSpace(availableWidth);
            double xlimit = available.getMaxX() - this.getOuterGap().getRightSpace(availableWidth);
            double maxRowWidth = 0.0;
            double xoffset = 0.0;
            double rowHeight = 0.0;
            double totalHeight = 0.0;
            boolean wrappingAllowed = true;
            if (titleItem != null) {
                g2.setFont(this.getTitleFont());
                legendTitle = this.createDrawableLegendItem(g2, titleItem, xoffset, totalHeight);
                rowHeight = Math.max(0.0, legendTitle.getHeight());
                xoffset += legendTitle.getWidth();
            }
            g2.setFont(this.itemFont);
            for (int i = 0; i < legendItems.getItemCount(); ++i) {
                DrawableLegendItem item = this.renderingOrder == LegendRenderingOrder.STANDARD ? this.createDrawableLegendItem(g2, legendItems.get(i), xoffset, totalHeight) : (this.renderingOrder == LegendRenderingOrder.REVERSE ? this.createDrawableLegendItem(g2, legendItems.get(legendItems.getItemCount() - i - 1), xoffset, totalHeight) : null);
                if (item.getMaxX() + xstart > xlimit && wrappingAllowed) {
                    maxRowWidth = Math.max(maxRowWidth, xoffset);
                    xoffset = 0.0;
                    totalHeight += rowHeight;
                    --i;
                    wrappingAllowed = false;
                    continue;
                }
                rowHeight = Math.max(rowHeight, item.getHeight());
                xoffset += item.getWidth();
                wrappingAllowed = true;
                items.add(item);
            }
            maxRowWidth = Math.max(maxRowWidth, xoffset);
            legendArea = new RoundRectangle2D.Double(0.0, 0.0, maxRowWidth, totalHeight += rowHeight, this.boundingBoxArcWidth, this.boundingBoxArcHeight);
            translation = this.createTranslationPointForHorizontalDraw(available, inverted, maxRowWidth, totalHeight);
        } else {
            double maxWidth;
            double totalHeight = 0.0;
            double d = maxWidth = this.preferredWidth == Double.MAX_VALUE ? 0.0 : this.preferredWidth;
            if (titleItem != null) {
                g2.setFont(this.getTitleFont());
                legendTitle = this.createDrawableLegendItem(g2, titleItem, 0.0, totalHeight);
                totalHeight += legendTitle.getHeight();
                maxWidth = Math.max(maxWidth, legendTitle.getWidth());
            }
            g2.setFont(this.itemFont);
            int legendItemsLength = legendItems.getItemCount();
            for (int i = 0; i < legendItemsLength; ++i) {
                List drawableParts = this.renderingOrder == LegendRenderingOrder.STANDARD ? this.createAllDrawableLinesForItem(g2, legendItems.get(i), 0.0, totalHeight, maxWidth) : (this.renderingOrder == LegendRenderingOrder.REVERSE ? this.createAllDrawableLinesForItem(g2, legendItems.get(legendItemsLength - i - 1), 0.0, totalHeight, maxWidth) : null);
                Iterator j = drawableParts.iterator();
                while (j.hasNext()) {
                    DrawableLegendItem item = (DrawableLegendItem)j.next();
                    totalHeight += item.getHeight();
                    maxWidth = Math.max(maxWidth, item.getWidth());
                    items.add(item);
                }
            }
            legendArea = new RoundRectangle2D.Float(0.0f, 0.0f, (float)maxWidth, (float)totalHeight, this.boundingBoxArcWidth, this.boundingBoxArcHeight);
            translation = this.createTranslationPointForVerticalDraw(available, inverted, totalHeight, maxWidth);
        }
        g2.translate(translation.getX(), translation.getY());
        LOGGER.debug((Object)("legendArea = " + legendArea.getWidth() + ", " + legendArea.getHeight()));
        this.drawLegendBox(g2, legendArea);
        this.drawLegendTitle(g2, legendTitle);
        this.drawSeriesElements(g2, items, translation, info);
        g2.translate(-translation.getX(), -translation.getY());
        return this.calcRemainingDrawingArea(available, horizontal, inverted, legendArea);
    }

    /*
     * WARNING - void declaration
     */
    private Point2D createTranslationPointForHorizontalDraw(Rectangle2D available, boolean inverted, double maxRowWidth, double totalHeight) {
        void var9_6;
        double xloc;
        double yloc;
        double d = yloc = inverted ? available.getMaxY() - totalHeight - this.getOuterGap().getBottomSpace(available.getHeight()) : available.getY() + this.getOuterGap().getTopSpace(available.getHeight());
        if (this.isAnchoredToLeft()) {
            xloc = available.getX() + (double)this.getChart().getPlot().getInsets().left;
        } else if (this.isAnchoredToCenter()) {
            xloc = available.getX() + available.getWidth() / 2.0 - maxRowWidth / 2.0;
        } else if (this.isAnchoredToRight()) {
            xloc = available.getX() + available.getWidth() - maxRowWidth - (double)this.getChart().getPlot().getInsets().left;
        } else {
            throw new IllegalStateException(UNEXPECTED_LEGEND_ANCHOR);
        }
        return new Point2D.Double((double)var9_6, yloc);
    }

    /*
     * WARNING - void declaration
     */
    private Point2D createTranslationPointForVerticalDraw(Rectangle2D available, boolean inverted, double totalHeight, double maxWidth) {
        void var9_6;
        double yloc;
        double xloc;
        double d = xloc = inverted ? available.getMaxX() - maxWidth - this.getOuterGap().getRightSpace(available.getWidth()) : available.getX() + this.getOuterGap().getLeftSpace(available.getWidth());
        if (this.isAnchoredToTop()) {
            yloc = available.getY() + (double)this.getChart().getPlot().getInsets().top;
        } else if (this.isAnchoredToMiddle()) {
            yloc = available.getY() + available.getHeight() / 2.0 - totalHeight / 2.0;
        } else if (this.isAnchoredToBottom()) {
            yloc = available.getY() + available.getHeight() - (double)this.getChart().getPlot().getInsets().bottom - totalHeight;
        } else {
            throw new IllegalStateException(UNEXPECTED_LEGEND_ANCHOR);
        }
        return new Point2D.Double(xloc, (double)var9_6);
    }

    private void drawLegendTitle(Graphics2D g2, DrawableLegendItem legendTitle) {
        if (legendTitle != null) {
            g2.setPaint(legendTitle.getItem().getPaint());
            g2.setPaint(this.itemPaint);
            g2.setFont(this.getTitleFont());
            TextUtilities.drawAlignedString((String)legendTitle.getItem().getLabel(), (Graphics2D)g2, (float)((float)legendTitle.getLabelPosition().getX()), (float)((float)legendTitle.getLabelPosition().getY()), (TextAnchor)TextAnchor.CENTER_LEFT);
            LOGGER.debug((Object)("Title x = " + legendTitle.getLabelPosition().getX()));
            LOGGER.debug((Object)("Title y = " + legendTitle.getLabelPosition().getY()));
        }
    }

    private void drawLegendBox(Graphics2D g2, RectangularShape legendArea) {
        g2.setPaint(this.backgroundPaint);
        g2.fill(legendArea);
        g2.setPaint(this.outlinePaint);
        g2.setStroke(this.outlineStroke);
        g2.draw(legendArea);
    }

    private void drawSeriesElements(Graphics2D g2, List items, Point2D translation, ChartRenderingInfo info) {
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getEntityCollection();
        }
        for (int i = 0; i < items.size(); ++i) {
            DrawableLegendItem item = (DrawableLegendItem)items.get(i);
            g2.setPaint(item.getItem().getPaint());
            Shape keyBox = item.getMarker();
            if (this.displaySeriesLines) {
                g2.setStroke(item.getLineStroke());
                g2.draw(item.getLine());
                if (this.displaySeriesShapes) {
                    if (item.isMarkerFilled()) {
                        g2.fill(keyBox);
                    } else {
                        g2.draw(keyBox);
                    }
                }
            } else if (item.isMarkerFilled()) {
                g2.fill(keyBox);
            } else {
                g2.draw(keyBox);
            }
            if (this.getOutlineShapes()) {
                g2.setPaint(this.shapeOutlinePaint);
                g2.setStroke(this.shapeOutlineStroke);
                g2.draw(keyBox);
            }
            g2.setPaint(this.itemPaint);
            g2.setFont(this.itemFont);
            TextUtilities.drawAlignedString((String)item.getItem().getLabel(), (Graphics2D)g2, (float)((float)item.getLabelPosition().getX()), (float)((float)item.getLabelPosition().getY()), (TextAnchor)TextAnchor.CENTER_LEFT);
            LOGGER.debug((Object)("Item x = " + item.getLabelPosition().getX()));
            LOGGER.debug((Object)("Item y = " + item.getLabelPosition().getY()));
            if (entities == null) continue;
            Rectangle2D.Double area = new Rectangle2D.Double(translation.getX() + item.getX(), translation.getY() + item.getY(), item.getWidth(), item.getHeight());
            LegendItemEntity entity = new LegendItemEntity(area);
            entity.setSeriesIndex(i);
            entities.addEntity(entity);
        }
    }

    private Rectangle2D calcRemainingDrawingArea(Rectangle2D available, boolean horizontal, boolean inverted, RectangularShape legendArea) {
        if (horizontal) {
            double yy = available.getY();
            double yloc = inverted ? yy : yy + legendArea.getHeight() + this.getOuterGap().getBottomSpace(available.getHeight());
            return new Rectangle2D.Double(available.getX(), yloc, available.getWidth(), available.getHeight() - legendArea.getHeight() - this.getOuterGap().getTopSpace(available.getHeight()) - this.getOuterGap().getBottomSpace(available.getHeight()));
        }
        double xloc = inverted ? available.getX() : available.getX() + legendArea.getWidth() + this.getOuterGap().getLeftSpace(available.getWidth()) + this.getOuterGap().getRightSpace(available.getWidth());
        return new Rectangle2D.Double(xloc, available.getY(), available.getWidth() - legendArea.getWidth() - this.getOuterGap().getLeftSpace(available.getWidth()) - this.getOuterGap().getRightSpace(available.getWidth()), available.getHeight());
    }

    private List createAllDrawableLinesForItem(Graphics2D g2, LegendItem legendItem, double x, double y, double wordWrapWidth) {
        ArrayList<DrawableLegendItem> drawableParts = new ArrayList<DrawableLegendItem>();
        DrawableLegendItem line = this.createDrawableLegendItem(g2, legendItem, x, y);
        if (line.getWidth() < wordWrapWidth) {
            drawableParts.add(line);
            return drawableParts;
        }
        boolean firstLine = true;
        double totalHeight = y;
        String prefix = "";
        String suffix = legendItem.getLabel().trim();
        LegendItem tmpItem = new LegendItem(prefix.trim(), legendItem.getLabel(), legendItem.getShape(), legendItem.isShapeFilled(), legendItem.getPaint(), legendItem.getStroke(), legendItem.getOutlinePaint(), legendItem.getOutlineStroke());
        line = this.createDrawableLegendItem(g2, tmpItem, x, totalHeight);
        DrawableLegendItem goodLine = null;
        do {
            String prevSuffix = suffix;
            int spacePos = suffix.indexOf(" ");
            if (spacePos < 0) {
                prefix = prefix + suffix;
                suffix = "";
            } else {
                prefix = prefix + suffix.substring(0, spacePos + 1);
                suffix = suffix.substring(spacePos + 1);
            }
            Paint background = this.getBackgroundPaint();
            tmpItem = new LegendItem(prefix.trim(), legendItem.getLabel(), legendItem.getShape(), legendItem.isShapeFilled(), firstLine ? legendItem.getPaint() : background, legendItem.getStroke(), firstLine ? legendItem.getOutlinePaint() : background, legendItem.getOutlineStroke());
            line = this.createDrawableLegendItem(g2, tmpItem, x, totalHeight);
            if (line.getWidth() < wordWrapWidth) {
                goodLine = line;
                continue;
            }
            if (goodLine == null) {
                drawableParts.add(line);
                totalHeight += line.getHeight();
            } else {
                drawableParts.add(goodLine);
                totalHeight += goodLine.getHeight();
                suffix = prevSuffix;
            }
            firstLine = false;
            prefix = "";
            suffix = suffix.trim();
            line = null;
            goodLine = null;
        } while (!suffix.equals(""));
        if (line != null) {
            drawableParts.add(line);
        }
        return drawableParts;
    }

    private DrawableLegendItem createDrawableLegendItem(Graphics2D graphics, LegendItem legendItem, double x, double y) {
        LOGGER.debug((Object)("In createDrawableLegendItem(x = " + x + ", y = " + y));
        int insideGap = 2;
        FontMetrics fm = graphics.getFontMetrics();
        LineMetrics lm = fm.getLineMetrics(legendItem.getLabel(), graphics);
        float textAscent = lm.getAscent();
        float lineHeight = textAscent + lm.getDescent() + lm.getLeading();
        DrawableLegendItem item = new DrawableLegendItem(legendItem);
        float xLabelLoc = (float)(x + (double)insideGap + (double)(1.15f * lineHeight));
        float yLabelLoc = (float)(y + (double)insideGap + (double)(0.5f * lineHeight));
        item.setLabelPosition(new Point2D.Float(xLabelLoc, yLabelLoc));
        float width = (float)(item.getLabelPosition().getX() - x + (double)fm.stringWidth(legendItem.getLabel()) + 0.5 * (double)textAscent);
        float height = (float)(2 * insideGap) + lineHeight;
        item.setBounds(x, y, width, height);
        float boxDim = lineHeight * 0.7f;
        float xloc = (float)(x + (double)insideGap + (double)(0.15f * lineHeight));
        float yloc = (float)(y + (double)insideGap + (double)(0.15f * lineHeight));
        if (this.displaySeriesLines) {
            Line2D.Float line = new Line2D.Float(xloc, yloc + boxDim / 2.0f, xloc + boxDim * 3.0f, yloc + boxDim / 2.0f);
            item.setLineStroke(legendItem.getStroke());
            item.setLine(line);
            item.setBounds(item.getX(), item.getY(), item.getWidth() + (double)(boxDim * 2.0f), item.getHeight());
            item.setLabelPosition(new Point2D.Float(xLabelLoc + boxDim * 2.0f, yLabelLoc));
            if (this.displaySeriesShapes) {
                Shape marker = legendItem.getShape();
                AffineTransform t1 = AffineTransform.getScaleInstance(this.shapeScaleX, this.shapeScaleY);
                Shape s1 = t1.createTransformedShape(marker);
                AffineTransform transformer = AffineTransform.getTranslateInstance((double)xloc + (double)boxDim * 1.5, yloc + boxDim / 2.0f);
                Shape s2 = transformer.createTransformedShape(s1);
                item.setMarker(s2);
            }
        } else if (this.displaySeriesShapes) {
            Shape marker = legendItem.getShape();
            AffineTransform t1 = AffineTransform.getScaleInstance(this.shapeScaleX, this.shapeScaleY);
            Shape s1 = t1.createTransformedShape(marker);
            AffineTransform transformer = AffineTransform.getTranslateInstance(xloc + boxDim / 2.0f, yloc + boxDim / 2.0f);
            Shape s2 = transformer.createTransformedShape(s1);
            item.setMarker(s2);
        } else {
            item.setMarker(new Rectangle2D.Float(xloc, yloc, boxDim, boxDim));
        }
        item.setMarkerFilled(legendItem.isShapeFilled());
        return item;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof StandardLegend) {
            StandardLegend l = (StandardLegend)obj;
            if (super.equals(obj)) {
                if (!ObjectUtils.equal((Object)this.outerGap, (Object)l.outerGap)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.outlineStroke, (Object)l.outlineStroke)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.outlinePaint, (Object)l.outlinePaint)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.backgroundPaint, (Object)l.backgroundPaint)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.innerGap, (Object)l.innerGap)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.title, (Object)l.title)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.titleFont, (Object)l.titleFont)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.itemFont, (Object)l.itemFont)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.itemPaint, (Object)l.itemPaint)) {
                    return false;
                }
                if (this.outlineShapes != l.outlineShapes) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.shapeOutlineStroke, (Object)l.shapeOutlineStroke)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.shapeOutlinePaint, (Object)l.shapeOutlinePaint)) {
                    return false;
                }
                if (this.displaySeriesShapes == l.displaySeriesShapes) {
                    return true;
                }
            }
        }
        return false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writeStroke((Stroke)this.outlineStroke, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.outlinePaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.backgroundPaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.itemPaint, (ObjectOutputStream)stream);
        SerialUtilities.writeStroke((Stroke)this.shapeOutlineStroke, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.shapeOutlinePaint, (ObjectOutputStream)stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.outlineStroke = SerialUtilities.readStroke((ObjectInputStream)stream);
        this.outlinePaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.backgroundPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.itemPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.shapeOutlineStroke = SerialUtilities.readStroke((ObjectInputStream)stream);
        this.shapeOutlinePaint = SerialUtilities.readPaint((ObjectInputStream)stream);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

