/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtils;

public class XYLineAnnotation
implements XYAnnotation,
Cloneable,
Serializable {
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private transient Stroke stroke;
    private transient Paint paint;

    public XYLineAnnotation(double x1, double y1, double x2, double y2) {
        this(x1, y1, x2, y2, new BasicStroke(1.0f), Color.black);
    }

    public XYLineAnnotation(double x1, double y1, double x2, double y2, Stroke stroke, Paint paint) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.stroke = stroke;
        this.paint = paint;
    }

    public void draw(Graphics2D g2, XYPlot plot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis) {
        PlotOrientation orientation = plot.getOrientation();
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation(plot.getDomainAxisLocation(), orientation);
        RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation(plot.getRangeAxisLocation(), orientation);
        float j2DX1 = 0.0f;
        float j2DX2 = 0.0f;
        float j2DY1 = 0.0f;
        float j2DY2 = 0.0f;
        if (orientation == PlotOrientation.VERTICAL) {
            j2DX1 = (float)domainAxis.valueToJava2D(this.x1, dataArea, domainEdge);
            j2DY1 = (float)rangeAxis.valueToJava2D(this.y1, dataArea, rangeEdge);
            j2DX2 = (float)domainAxis.valueToJava2D(this.x2, dataArea, domainEdge);
            j2DY2 = (float)rangeAxis.valueToJava2D(this.y2, dataArea, rangeEdge);
        } else if (orientation == PlotOrientation.HORIZONTAL) {
            j2DY1 = (float)domainAxis.valueToJava2D(this.x1, dataArea, domainEdge);
            j2DX1 = (float)rangeAxis.valueToJava2D(this.y1, dataArea, rangeEdge);
            j2DY2 = (float)domainAxis.valueToJava2D(this.x2, dataArea, domainEdge);
            j2DX2 = (float)rangeAxis.valueToJava2D(this.y2, dataArea, rangeEdge);
        }
        g2.setPaint(this.paint);
        g2.setStroke(this.stroke);
        Line2D.Float line = new Line2D.Float(j2DX1, j2DY1, j2DX2, j2DY2);
        g2.draw(line);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof XYLineAnnotation) {
            XYLineAnnotation a = (XYLineAnnotation)object;
            boolean b0 = this.x1 == a.x1;
            boolean b1 = this.y1 == a.y1;
            boolean b2 = this.x2 == a.x2;
            boolean b3 = this.y2 == a.y2;
            boolean b4 = ObjectUtils.equal((Object)this.paint, (Object)a.paint);
            boolean b5 = ObjectUtils.equal((Object)this.stroke, (Object)a.stroke);
            return b0 && b1 && b2 && b3 && b4 && b5;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.paint, (ObjectOutputStream)stream);
        SerialUtilities.writeStroke((Stroke)this.stroke, (ObjectOutputStream)stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.paint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.stroke = SerialUtilities.readStroke((ObjectInputStream)stream);
    }
}

