/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class ClusteredXYBarRenderer
extends XYBarRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private double margin;
    private double translatedRangeZero;
    private boolean centerBarAtStartValue;

    public ClusteredXYBarRenderer() {
        this(0.0, false);
    }

    public ClusteredXYBarRenderer(double margin, boolean centerBarAtStartValue) {
        super(margin);
        this.margin = margin;
        this.centerBarAtStartValue = centerBarAtStartValue;
    }

    public XYItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        XYItemRendererState state = super.initialise(g2, dataArea, plot, data, info);
        ValueAxis rangeAxis = plot.getRangeAxis();
        this.translatedRangeZero = rangeAxis.valueToJava2D(0.0, dataArea, plot.getRangeAxisEdge());
        return state;
    }

    public void setMargin(double margin) {
        this.margin = margin;
        super.setMargin(margin);
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        EntityCollection entities;
        IntervalXYDataset intervalData = (IntervalXYDataset)dataset;
        Paint seriesPaint = this.getItemPaint(series, item);
        Paint seriesOutlinePaint = this.getItemOutlinePaint(series, item);
        Number y = intervalData.getY(series, item);
        if (y == null) {
            return;
        }
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double translatedY = rangeAxis.valueToJava2D(y.doubleValue(), dataArea, yAxisLocation);
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        double x1 = intervalData.getStartXValue(series, item);
        double translatedX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double x2 = intervalData.getEndXValue(series, item);
        double translatedX2 = domainAxis.valueToJava2D(x2, dataArea, xAxisLocation);
        double translatedWidth = Math.max(1.0, Math.abs(translatedX2 - translatedX1));
        double translatedHeight = Math.abs(translatedY - this.translatedRangeZero);
        if (this.centerBarAtStartValue) {
            translatedX1 -= translatedWidth / 2.0;
        }
        if (this.margin > 0.0) {
            double cut = translatedWidth * this.margin;
            translatedWidth -= cut;
            translatedX1 += cut / 2.0;
        }
        int numSeries = dataset.getSeriesCount();
        double seriesBarWidth = translatedWidth / (double)numSeries;
        Rectangle2D.Double bar = null;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            bar = new Rectangle2D.Double(Math.min(this.translatedRangeZero, translatedY), translatedX1 - seriesBarWidth * (double)(numSeries - series), translatedHeight, seriesBarWidth);
        } else if (orientation == PlotOrientation.VERTICAL) {
            bar = new Rectangle2D.Double(translatedX1 + seriesBarWidth * (double)series, Math.min(this.translatedRangeZero, translatedY), seriesBarWidth, translatedHeight);
        }
        g2.setPaint(seriesPaint);
        g2.fill(bar);
        if (Math.abs(translatedX2 - translatedX1) > 3.0) {
            g2.setStroke(this.getItemStroke(series, item));
            g2.setPaint(seriesOutlinePaint);
            g2.draw(bar);
        }
        if (info != null && (entities = info.getOwner().getEntityCollection()) != null) {
            String tip = null;
            XYToolTipGenerator generator = this.getToolTipGenerator(series, item);
            if (generator != null) {
                tip = generator.generateToolTip(dataset, series, item);
            }
            String url = null;
            if (this.getURLGenerator() != null) {
                url = this.getURLGenerator().generateURL(dataset, series, item);
            }
            XYItemEntity entity = new XYItemEntity(bar, dataset, series, item, tip, url);
            entities.addEntity(entity);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

