/*

    WiRouter KeyRec - Salvatore Fresta

    Contact: salvatorefresta@gmail.com

    Copyright 2010-2011 Salvatore Fresta aka Drosophila

    This program is free software; you can redistribute it and/or
    modify it under the terms of  the  GNU General Public License
    as published by the  Free Software Foundation; either version
    2 of the License, or (at your option) any later version.

    This program  is  distributed  in the hope  that  it  will be
    useful, but WITHOUT ANY WARRANTY;  without  even the  implied
    warranty  of  MERCHANTABILITY  or  FITNESS  FOR  A PARTICULAR
    PURPOSE. See the GNU General Public License for more details.

    You should have  received a copy  of  the  GNU General Public
    License along  with  this program;  if not, write to the Free
    Software Foundation,Inc., 59 Temple Place, Suite 330, Boston,
    MA 02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt

*/

#include <stdio.h>
#include <string.h>
#include "netopia.h"
#include "sha1.h"
#include "wirouterkeyrec.h"

void netopia_calculate_wep_key(unsigned char *extended_ssid, int debug, Netopia_config *config) {

    SHA_CTX sha1_ctx;
    unsigned int i, ssid;
    unsigned char *ssidin = NULL;
    char *numstring[]= { "Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine" };
    
    ssidin = extended_ssid+6;
    
    for(ssid=0; ssidin[0]; ssidin++)
      ssid = (ssid << 3) + (ssidin[0]-48);
    
    if(ssidin[0]) {
      if(debug) PRINT_DEBUG("[%s] Invalid SSID.", extended_ssid);
      return;
    }
    
    ssid^=0xFCC+0x01000000;
    
    sha_init(&sha1_ctx);

    for(i=10000000; i > 0; i/=10)
      sha_update(&sha1_ctx, (unsigned char *)numstring[ssid/i%10], strlen(numstring[ssid/i%10]));

    sha_update(&sha1_ctx, (unsigned char *)"Although your world wonders me, ", 32);
    sha_final(&sha1_ctx);

    sprintf((char *)config->wep_key, "%02x%02x%02x%02x", sha1_ctx.digest[0],
	                                                 sha1_ctx.digest[1],
	                                                 sha1_ctx.digest[2],
	                                                 sha1_ctx.digest[3] >> 24);
    
}