/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PidHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    private PidHelper() {
    }

    public static long getPid() {
        return PidHelper.getPid(ManagementFactory.getRuntimeMXBean());
    }

    public static long getPid(RuntimeMXBean runtimeMXBean) {
        try {
            Method getPidMethod = runtimeMXBean.getClass().getMethod("getPid", new Class[0]);
            return (Long)getPidMethod.invoke((Object)runtimeMXBean, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOGGER.debug("ignoring exception trying to find getPid() (expected pre-JDK 10)", (Throwable)e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.debug("ignoring exception trying to execute getPid()", (Throwable)e);
        }
        try {
            Field jvmField = runtimeMXBean.getClass().getDeclaredField("jvm");
            jvmField.setAccessible(true);
            Object vmManagement = jvmField.get(runtimeMXBean);
            Method getProcessIdMethod = vmManagement.getClass().getDeclaredMethod("getProcessId", new Class[0]);
            getProcessIdMethod.setAccessible(true);
            return ((Integer)getProcessIdMethod.invoke(vmManagement, new Object[0])).intValue();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Unable to determine PID due to exception", (Throwable)e);
            return -1L;
        }
    }
}

