/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.jobgen.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksCountPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.OperatorDescriptorId;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;

public class JobBuilder
implements IHyracksJobBuilder {
    private final JobSpecification jobSpec;
    private final AlgebricksAbsolutePartitionConstraint clusterLocations;
    private final AlgebricksAbsolutePartitionConstraint countOneLocation;
    private final Map<ILogicalOperator, ArrayList<ILogicalOperator>> outEdges = new HashMap<ILogicalOperator, ArrayList<ILogicalOperator>>();
    private final Map<ILogicalOperator, ArrayList<ILogicalOperator>> inEdges = new HashMap<ILogicalOperator, ArrayList<ILogicalOperator>>();
    private final Map<ILogicalOperator, Pair<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint>> connectors = new HashMap<ILogicalOperator, Pair<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint>>();
    private final Map<ILogicalOperator, Pair<IPushRuntimeFactory, RecordDescriptor>> microOps = new HashMap<ILogicalOperator, Pair<IPushRuntimeFactory, RecordDescriptor>>();
    private final Map<IPushRuntimeFactory, ILogicalOperator> revMicroOpMap = new HashMap<IPushRuntimeFactory, ILogicalOperator>();
    private final Map<ILogicalOperator, IOperatorDescriptor> hyracksOps = new HashMap<ILogicalOperator, IOperatorDescriptor>();
    private final Map<ILogicalOperator, AlgebricksPartitionConstraint> pcForMicroOps = new HashMap<ILogicalOperator, AlgebricksPartitionConstraint>();
    private final Map<ILogicalOperator, Integer> algebraicOpBelongingToMetaAsterixOp = new HashMap<ILogicalOperator, Integer>();
    private final Map<Integer, List<Pair<IPushRuntimeFactory, RecordDescriptor>>> metaAsterixOpSkeletons = new HashMap<Integer, List<Pair<IPushRuntimeFactory, RecordDescriptor>>>();
    private final Map<Integer, AlgebricksMetaOperatorDescriptor> metaAsterixOps = new HashMap<Integer, AlgebricksMetaOperatorDescriptor>();
    private final Map<IOperatorDescriptor, AlgebricksPartitionConstraint> partitionConstraintMap = new HashMap<IOperatorDescriptor, AlgebricksPartitionConstraint>();
    private int aodCounter = 0;

    public JobBuilder(JobSpecification jobSpec, AlgebricksAbsolutePartitionConstraint clusterLocations) {
        this.jobSpec = jobSpec;
        this.clusterLocations = clusterLocations;
        int nPartitions = clusterLocations.getLocations().length;
        this.countOneLocation = new AlgebricksAbsolutePartitionConstraint(new String[]{clusterLocations.getLocations()[Math.abs(jobSpec.hashCode() % nPartitions)]});
    }

    @Override
    public void contributeMicroOperator(ILogicalOperator op, IPushRuntimeFactory runtime, RecordDescriptor recDesc) {
        this.contributeMicroOperator(op, runtime, recDesc, null);
    }

    @Override
    public void contributeMicroOperator(ILogicalOperator op, IPushRuntimeFactory runtime, RecordDescriptor recDesc, AlgebricksPartitionConstraint pc) {
        AbstractLogicalOperator logicalOp;
        this.microOps.put(op, (Pair<IPushRuntimeFactory, RecordDescriptor>)new Pair((Object)runtime, (Object)recDesc));
        this.revMicroOpMap.put(runtime, op);
        if (pc != null) {
            this.pcForMicroOps.put(op, pc);
        }
        if ((logicalOp = (AbstractLogicalOperator)op).getExecutionMode() == AbstractLogicalOperator.ExecutionMode.UNPARTITIONED && pc == null) {
            AlgebricksAbsolutePartitionConstraint apc = this.countOneLocation;
            this.pcForMicroOps.put(logicalOp, (AlgebricksPartitionConstraint)apc);
        }
    }

    @Override
    public void contributeConnector(ILogicalOperator exchgOp, IConnectorDescriptor conn) {
        this.connectors.put(exchgOp, (Pair<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint>)new Pair((Object)conn, null));
    }

    @Override
    public void contributeConnectorWithTargetConstraint(ILogicalOperator exchgOp, IConnectorDescriptor conn, IHyracksJobBuilder.TargetConstraint numberOfTargetPartitions) {
        this.connectors.put(exchgOp, (Pair<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint>)new Pair((Object)conn, (Object)numberOfTargetPartitions));
    }

    @Override
    public void contributeGraphEdge(ILogicalOperator src, int srcOutputIndex, ILogicalOperator dest, int destInputIndex) {
        ArrayList<ILogicalOperator> outputs = this.outEdges.get(src);
        if (outputs == null) {
            outputs = new ArrayList();
            this.outEdges.put(src, outputs);
        }
        this.addAtPos(outputs, dest, srcOutputIndex);
        ArrayList<ILogicalOperator> inp = this.inEdges.get(dest);
        if (inp == null) {
            inp = new ArrayList();
            this.inEdges.put(dest, inp);
        }
        this.addAtPos(inp, src, destInputIndex);
    }

    @Override
    public void contributeHyracksOperator(ILogicalOperator op, IOperatorDescriptor opDesc) {
        this.hyracksOps.put(op, opDesc);
    }

    @Override
    public void contributeAlgebricksPartitionConstraint(IOperatorDescriptor opDesc, AlgebricksPartitionConstraint apcArg) {
        AlgebricksCountPartitionConstraint constraint;
        AlgebricksPartitionConstraint apc = apcArg;
        if (apc.getPartitionConstraintType() == AlgebricksPartitionConstraint.PartitionConstraintType.COUNT && (constraint = (AlgebricksCountPartitionConstraint)apc).getCount() == 1) {
            apc = this.countOneLocation;
        }
        this.partitionConstraintMap.put(opDesc, apc);
    }

    @Override
    public JobSpecification getJobSpec() {
        return this.jobSpec;
    }

    @Override
    public void buildSpec(List<ILogicalOperator> roots) throws AlgebricksException {
        this.buildAsterixComponents();
        Map<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint> tgtConstraints = this.setupConnectors();
        for (ILogicalOperator r : roots) {
            IOperatorDescriptor opDesc = this.findOpDescForAlgebraicOp(r);
            this.jobSpec.addRoot(opDesc);
        }
        this.setAllPartitionConstraints(tgtConstraints);
    }

    public List<IOperatorDescriptor> getGeneratedMetaOps() {
        ArrayList<IOperatorDescriptor> resultOps = new ArrayList<IOperatorDescriptor>();
        for (IOperatorDescriptor opd : this.jobSpec.getOperatorMap().values()) {
            if (!(opd instanceof AlgebricksMetaOperatorDescriptor)) continue;
            resultOps.add(opd);
        }
        resultOps.sort((op1, op2) -> this.sendsOutput((IOperatorDescriptor)op1, (IOperatorDescriptor)op2) ? 1 : (this.sendsOutput((IOperatorDescriptor)op2, (IOperatorDescriptor)op1) ? -1 : 0));
        return resultOps;
    }

    private void setAllPartitionConstraints(Map<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint> tgtConstraints) throws AlgebricksException {
        List roots = this.jobSpec.getRoots();
        this.setSpecifiedPartitionConstraints();
        for (OperatorDescriptorId rootId : roots) {
            this.setPartitionConstraintsBottomup(rootId, tgtConstraints, null, false);
        }
        for (OperatorDescriptorId rootId : roots) {
            this.setPartitionConstraintsTopdown(rootId, tgtConstraints, null);
        }
        for (OperatorDescriptorId rootId : roots) {
            this.setPartitionConstraintsBottomup(rootId, tgtConstraints, null, true);
        }
    }

    private void setSpecifiedPartitionConstraints() {
        AlgebricksPartitionConstraint pc;
        for (ILogicalOperator op : this.pcForMicroOps.keySet()) {
            pc = this.pcForMicroOps.get(op);
            Integer k = this.algebraicOpBelongingToMetaAsterixOp.get(op);
            AlgebricksMetaOperatorDescriptor amod = this.metaAsterixOps.get(k);
            this.partitionConstraintMap.put((IOperatorDescriptor)amod, pc);
        }
        for (IOperatorDescriptor opDesc : this.partitionConstraintMap.keySet()) {
            pc = this.partitionConstraintMap.get(opDesc);
            AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)this.jobSpec, (IOperatorDescriptor)opDesc, (AlgebricksPartitionConstraint)pc);
        }
    }

    private void setPartitionConstraintsTopdown(OperatorDescriptorId opId, Map<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint> tgtConstraints, IOperatorDescriptor parentOp) {
        List opInputs = (List)this.jobSpec.getOperatorInputMap().get(opId);
        IOperatorDescriptor opDesc = (IOperatorDescriptor)this.jobSpec.getOperatorMap().get(opId);
        if (opInputs != null) {
            for (IConnectorDescriptor conn : opInputs) {
                ConnectorDescriptorId cid = conn.getConnectorId();
                org.apache.commons.lang3.tuple.Pair p = (org.apache.commons.lang3.tuple.Pair)this.jobSpec.getConnectorOperatorMap().get(cid);
                IOperatorDescriptor src = (IOperatorDescriptor)((org.apache.commons.lang3.tuple.Pair)p.getLeft()).getLeft();
                IHyracksJobBuilder.TargetConstraint constraint = tgtConstraints.get(conn);
                if (constraint != null && constraint == IHyracksJobBuilder.TargetConstraint.SAME_COUNT) {
                    AlgebricksPartitionConstraint opConstraint = this.partitionConstraintMap.get(opDesc);
                    if (this.partitionConstraintMap.get(src) == null && opConstraint != null) {
                        this.partitionConstraintMap.put(src, opConstraint);
                        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)this.jobSpec, (IOperatorDescriptor)src, (AlgebricksPartitionConstraint)opConstraint);
                    }
                }
                this.setPartitionConstraintsTopdown(src.getOperatorId(), tgtConstraints, opDesc);
            }
        }
    }

    private void setPartitionConstraintsBottomup(OperatorDescriptorId opId, Map<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint> tgtConstraints, IOperatorDescriptor parentOp, boolean finalPass) throws AlgebricksException {
        List opInputs = (List)this.jobSpec.getOperatorInputMap().get(opId);
        AlgebricksAbsolutePartitionConstraint opConstraint = null;
        IOperatorDescriptor opDesc = (IOperatorDescriptor)this.jobSpec.getOperatorMap().get(opId);
        if (opInputs != null) {
            for (IConnectorDescriptor conn : opInputs) {
                ConnectorDescriptorId cid = conn.getConnectorId();
                org.apache.commons.lang3.tuple.Pair p = (org.apache.commons.lang3.tuple.Pair)this.jobSpec.getConnectorOperatorMap().get(cid);
                IOperatorDescriptor src = (IOperatorDescriptor)((org.apache.commons.lang3.tuple.Pair)p.getLeft()).getLeft();
                this.setPartitionConstraintsBottomup(src.getOperatorId(), tgtConstraints, opDesc, finalPass);
                IHyracksJobBuilder.TargetConstraint constraint = tgtConstraints.get(conn);
                if (constraint == null) continue;
                switch (constraint) {
                    case ONE: {
                        opConstraint = JobBuilder.composePartitionConstraints((AlgebricksPartitionConstraint)opConstraint, (AlgebricksPartitionConstraint)this.countOneLocation);
                        break;
                    }
                    case SAME_COUNT: {
                        opConstraint = JobBuilder.composePartitionConstraints((AlgebricksPartitionConstraint)opConstraint, this.partitionConstraintMap.get(src));
                    }
                }
            }
        }
        if (this.partitionConstraintMap.get(opDesc) == null) {
            if (finalPass && opConstraint == null && (opInputs == null || opInputs.isEmpty())) {
                opConstraint = this.countOneLocation;
            }
            if (finalPass && opConstraint == null) {
                opConstraint = this.clusterLocations;
            }
            if (opConstraint != null) {
                this.partitionConstraintMap.put(opDesc, (AlgebricksPartitionConstraint)opConstraint);
                AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)this.jobSpec, (IOperatorDescriptor)opDesc, (AlgebricksPartitionConstraint)opConstraint);
            }
        }
    }

    private Map<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint> setupConnectors() throws AlgebricksException {
        HashMap<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint> tgtConstraints = new HashMap<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint>();
        for (ILogicalOperator exchg : this.connectors.keySet()) {
            ILogicalOperator inOp = this.inEdges.get(exchg).get(0);
            ILogicalOperator outOp = this.outEdges.get(exchg).get(0);
            IOperatorDescriptor inOpDesc = this.findOpDescForAlgebraicOp(inOp);
            IOperatorDescriptor outOpDesc = this.findOpDescForAlgebraicOp(outOp);
            Pair<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint> connPair = this.connectors.get(exchg);
            IConnectorDescriptor conn = (IConnectorDescriptor)connPair.first;
            int producerPort = this.outEdges.get(inOp).indexOf(exchg);
            int consumerPort = this.inEdges.get(outOp).indexOf(exchg);
            this.jobSpec.connect(conn, inOpDesc, producerPort, outOpDesc, consumerPort);
            if (connPair.second == null) continue;
            tgtConstraints.put(conn, (IHyracksJobBuilder.TargetConstraint)((Object)connPair.second));
        }
        return tgtConstraints;
    }

    private IOperatorDescriptor findOpDescForAlgebraicOp(ILogicalOperator op) throws AlgebricksException {
        IOperatorDescriptor hOpDesc = this.hyracksOps.get(op);
        if (hOpDesc != null) {
            return hOpDesc;
        }
        Integer metaOpKey = this.algebraicOpBelongingToMetaAsterixOp.get(op);
        if (metaOpKey == null) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.DESCRIPTOR_GENERATION_ERROR, (SourceLocation)op.getSourceLocation(), (Serializable[])new Serializable[]{op.getOperatorTag()});
        }
        return (IOperatorDescriptor)this.metaAsterixOps.get(metaOpKey);
    }

    private void buildAsterixComponents() {
        for (ILogicalOperator aop : this.microOps.keySet()) {
            this.addMicroOpToMetaRuntimeOp(aop);
        }
        for (Integer k : this.metaAsterixOpSkeletons.keySet()) {
            List<Pair<IPushRuntimeFactory, RecordDescriptor>> opContents = this.metaAsterixOpSkeletons.get(k);
            AlgebricksMetaOperatorDescriptor amod = this.buildMetaAsterixOpDesc(opContents);
            this.metaAsterixOps.put(k, amod);
        }
    }

    private AlgebricksMetaOperatorDescriptor buildMetaAsterixOpDesc(List<Pair<IPushRuntimeFactory, RecordDescriptor>> opContents) {
        ILogicalOperator firstLogicalOp;
        ArrayList<ILogicalOperator> inOps;
        int n = opContents.size();
        IPushRuntimeFactory[] runtimeFactories = new IPushRuntimeFactory[n];
        RecordDescriptor[] internalRecordDescriptors = new RecordDescriptor[n];
        int ln = opContents.size();
        for (int i = 0; i < ln; ++i) {
            Pair<IPushRuntimeFactory, RecordDescriptor> p = opContents.get(i);
            runtimeFactories[i] = (IPushRuntimeFactory)p.first;
            internalRecordDescriptors[i] = (RecordDescriptor)p.second;
        }
        ILogicalOperator lastLogicalOp = this.revMicroOpMap.get(runtimeFactories[n - 1]);
        ArrayList<ILogicalOperator> outOps = this.outEdges.get(lastLogicalOp);
        int outArity = outOps == null ? 0 : outOps.size();
        int[] outPositions = new int[outArity];
        IPushRuntimeFactory[] outRuntimeFactories = new IPushRuntimeFactory[outArity];
        if (outOps != null) {
            int ln2 = outOps.size();
            for (int i = 0; i < ln2; ++i) {
                ILogicalOperator outOp = outOps.get(i);
                outPositions[i] = OperatorManipulationUtil.indexOf(outOp.getInputs(), lastLogicalOp);
                Pair<IPushRuntimeFactory, RecordDescriptor> microOpPair = this.microOps.get(outOp);
                outRuntimeFactories[i] = microOpPair != null ? (IPushRuntimeFactory)microOpPair.first : null;
            }
        }
        int inArity = (inOps = this.inEdges.get(firstLogicalOp = this.revMicroOpMap.get(runtimeFactories[0]))) == null ? 0 : inOps.size();
        return new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)this.jobSpec, inArity, outArity, runtimeFactories, internalRecordDescriptors, outRuntimeFactories, outPositions);
    }

    private void addMicroOpToMetaRuntimeOp(ILogicalOperator aop) {
        ArrayList<ILogicalOperator> destList;
        Integer k = this.algebraicOpBelongingToMetaAsterixOp.get(aop);
        if (k == null) {
            k = this.createNewMetaOpInfo(aop);
        }
        if ((destList = this.outEdges.get(aop)) == null || destList.size() != 1) {
            return;
        }
        ILogicalOperator dest = destList.get(0);
        int destInputPos = OperatorManipulationUtil.indexOf(dest.getInputs(), aop);
        Integer j = this.algebraicOpBelongingToMetaAsterixOp.get(dest);
        if (destInputPos != 0) {
            return;
        }
        if (j == null && this.microOps.get(dest) != null) {
            this.algebraicOpBelongingToMetaAsterixOp.put(dest, k);
            List<Pair<IPushRuntimeFactory, RecordDescriptor>> aodContent1 = this.metaAsterixOpSkeletons.get(k);
            aodContent1.add(this.microOps.get(dest));
        } else if (j != null && j.intValue() != k.intValue()) {
            List<Pair<IPushRuntimeFactory, RecordDescriptor>> aodContent1 = this.metaAsterixOpSkeletons.get(k);
            List<Pair<IPushRuntimeFactory, RecordDescriptor>> aodContent2 = this.metaAsterixOpSkeletons.get(j);
            aodContent1.addAll(aodContent2);
            this.metaAsterixOpSkeletons.remove(j);
            for (ILogicalOperator m : this.algebraicOpBelongingToMetaAsterixOp.keySet()) {
                Integer g = this.algebraicOpBelongingToMetaAsterixOp.get(m);
                if (g.intValue() != j.intValue()) continue;
                this.algebraicOpBelongingToMetaAsterixOp.put(m, k);
            }
        }
    }

    private int createNewMetaOpInfo(ILogicalOperator aop) {
        int n = this.aodCounter++;
        ArrayList<Pair<IPushRuntimeFactory, RecordDescriptor>> metaOpContents = new ArrayList<Pair<IPushRuntimeFactory, RecordDescriptor>>();
        metaOpContents.add(this.microOps.get(aop));
        this.metaAsterixOpSkeletons.put(n, metaOpContents);
        this.algebraicOpBelongingToMetaAsterixOp.put(aop, n);
        return n;
    }

    private <E> void addAtPos(ArrayList<E> a, E elem, int pos) {
        int n = a.size();
        if (n > pos) {
            a.set(pos, elem);
        } else {
            for (int k = n; k < pos; ++k) {
                a.add(null);
            }
            a.add(elem);
        }
    }

    private boolean sendsOutput(IOperatorDescriptor src, IOperatorDescriptor trg) {
        AlgebricksPipeline srcPipeline = ((AlgebricksMetaOperatorDescriptor)src).getPipeline();
        IPushRuntimeFactory[] srcOutRts = srcPipeline.getOutputRuntimeFactories();
        if (srcOutRts == null) {
            return false;
        }
        Object[] trgRts = ((AlgebricksMetaOperatorDescriptor)trg).getPipeline().getRuntimeFactories();
        for (IPushRuntimeFactory srcOutRt : srcOutRts) {
            AlgebricksMetaOperatorDescriptor srcOutMetaOp;
            Integer k;
            if (ArrayUtils.contains((Object[])trgRts, (Object)srcOutRt)) {
                return true;
            }
            ILogicalOperator srcOutOp = this.revMicroOpMap.get(srcOutRt);
            if (srcOutOp == null || (k = this.algebraicOpBelongingToMetaAsterixOp.get(srcOutOp)) == null || (srcOutMetaOp = this.metaAsterixOps.get(k)) == null || !this.sendsOutput((IOperatorDescriptor)srcOutMetaOp, trg)) continue;
            return true;
        }
        return false;
    }

    private static AlgebricksPartitionConstraint composePartitionConstraints(AlgebricksPartitionConstraint pc1, AlgebricksPartitionConstraint pc2) throws AlgebricksException {
        return pc1 == null ? pc2 : (pc2 == null ? pc1 : pc1.compose(pc2));
    }
}

