/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.build;

import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.storage.am.common.api.IIndexBuilder;
import org.apache.hyracks.storage.am.common.api.IIndexBuilderFactory;
import org.apache.hyracks.storage.am.common.build.IndexBuilder;
import org.apache.hyracks.storage.common.IResourceFactory;
import org.apache.hyracks.storage.common.IStorageManager;

public class IndexBuilderFactory
implements IIndexBuilderFactory {
    private static final long serialVersionUID = 1L;
    protected final IStorageManager storageManager;
    protected final IFileSplitProvider fileSplitProvider;
    protected final IResourceFactory localResourceFactory;
    protected final boolean durable;

    public IndexBuilderFactory(IStorageManager storageManager, IFileSplitProvider fileSplitProvider, IResourceFactory localResourceFactory, boolean durable) {
        this.storageManager = storageManager;
        this.fileSplitProvider = fileSplitProvider;
        this.localResourceFactory = localResourceFactory;
        this.durable = durable;
    }

    @Override
    public IIndexBuilder create(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        FileReference resourceRef = this.fileSplitProvider.getFileSplits()[partition].getFileReference(ctx.getIoManager());
        return new IndexBuilder(ctx.getJobletContext().getServiceContext(), this.storageManager, this.storageManager.getResourceIdFactory(ctx.getJobletContext().getServiceContext()), resourceRef, this.localResourceFactory, this.durable);
    }
}

