/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeHelper;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;

public class OpenRecordConstructorResultType
implements IResultTypeComputer {
    public static final OpenRecordConstructorResultType INSTANCE = new OpenRecordConstructorResultType();

    @Override
    public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> metadataProvider) throws AlgebricksException {
        AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expression;
        ARecordType type = (ARecordType)TypeCastUtils.getRequiredType(f);
        if (type != null) {
            return type;
        }
        Iterator argIter = f.getArguments().iterator();
        ArrayList<String> namesList = new ArrayList<String>();
        ArrayList<IAType> typesList = new ArrayList<IAType>();
        HashSet<String> allPossibleAdditionalFieldNames = new HashSet<String>();
        boolean canProvideAdditionFieldInfo = true;
        boolean isOpen = false;
        while (argIter.hasNext()) {
            ILogicalExpression e1 = (ILogicalExpression)((Mutable)argIter.next()).getValue();
            ILogicalExpression e2 = (ILogicalExpression)((Mutable)argIter.next()).getValue();
            IAType t2 = (IAType)env.getType(e2);
            String fieldName = ConstantExpressionUtil.getStringConstant(e1);
            if (fieldName != null && t2 != null && TypeHelper.isClosed(t2)) {
                if (namesList.contains(fieldName)) {
                    throw new CompilationException(ErrorCode.DUPLICATE_FIELD_NAME, f.getSourceLocation(), new Serializable[]{fieldName});
                }
                namesList.add(fieldName);
                if (t2.getTypeTag() == ATypeTag.UNION) {
                    AUnionType unionType = (AUnionType)t2;
                    t2 = AUnionType.createUnknownableType(unionType.getActualType());
                }
                typesList.add(t2);
                continue;
            }
            if (canProvideAdditionFieldInfo && fieldName != null) {
                allPossibleAdditionalFieldNames.add(fieldName);
            } else {
                canProvideAdditionFieldInfo = false;
            }
            isOpen = true;
        }
        String[] fieldNames = namesList.toArray(new String[0]);
        IAType[] fieldTypes = typesList.toArray(new IAType[0]);
        return canProvideAdditionFieldInfo ? new ARecordType(null, fieldNames, fieldTypes, isOpen, allPossibleAdditionalFieldNames) : new ARecordType(null, fieldNames, fieldTypes, isOpen);
    }
}

