/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json.moshi;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.adapters.Rfc3339DateJsonAdapter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.json.moshi.JsonHtmlEncoder;
import org.apache.axis2.json.moshi.MoshiXMLStreamWriter;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonFormatter
implements MessageFormatter {
    private static final Log log = LogFactory.getLog(JsonFormatter.class);

    public void writeTo(MessageContext outMsgCtxt, OMOutputFormat omOutputFormat, OutputStream outputStream, boolean preserve) throws AxisFault {
        String charSetEncoding = (String)outMsgCtxt.getProperty("CHARACTER_SET_ENCODING");
        try {
            Moshi moshi = new Moshi.Builder().add(String.class, (JsonAdapter)new JsonHtmlEncoder()).add(Date.class, (JsonAdapter)new Rfc3339DateJsonAdapter()).build();
            JsonAdapter adapter = moshi.adapter(Object.class);
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((OutputStream)outputStream));
            JsonWriter jsonWriter = JsonWriter.of((BufferedSink)sink);
            Object retObj = outMsgCtxt.getProperty("returnObject");
            if (outMsgCtxt.isProcessingFault()) {
                OMElement element = outMsgCtxt.getEnvelope().getBody().getFirstElement();
                try {
                    jsonWriter.beginObject();
                    jsonWriter.name(element.getLocalName());
                    jsonWriter.beginObject();
                    Iterator childrenIterator = element.getChildElements();
                    while (childrenIterator.hasNext()) {
                        Object next = childrenIterator.next();
                        OMElement omElement = (OMElement)next;
                        jsonWriter.name(omElement.getLocalName());
                        jsonWriter.value(omElement.getText());
                    }
                    jsonWriter.endObject();
                    jsonWriter.endObject();
                    jsonWriter.flush();
                    jsonWriter.close();
                }
                catch (IOException e) {
                    throw new AxisFault("Error while processing fault code in JsonWriter");
                }
            }
            if (retObj == null) {
                OMElement element = outMsgCtxt.getEnvelope().getBody().getFirstElement();
                QName elementQname = outMsgCtxt.getAxisOperation().getMessage("Out").getElementQName();
                ArrayList schemas = outMsgCtxt.getAxisService().getSchema();
                MoshiXMLStreamWriter xmlsw = new MoshiXMLStreamWriter(jsonWriter, elementQname, schemas, outMsgCtxt.getConfigurationContext());
                try {
                    xmlsw.writeStartDocument();
                    element.serialize((XMLStreamWriter)xmlsw, preserve);
                    xmlsw.writeEndDocument();
                }
                catch (XMLStreamException e) {
                    throw new AxisFault("Error while writing to the output stream using JsonWriter", (Throwable)e);
                }
            }
            try {
                jsonWriter.beginObject();
                jsonWriter.name("response");
                Type returnType = (Type)outMsgCtxt.getProperty("returnType");
                adapter.toJson(jsonWriter, retObj);
                jsonWriter.endObject();
                jsonWriter.flush();
            }
            catch (IOException e) {
                String msg = "Exception occurred while writting to JsonWriter at the JsonFormatter ";
                log.error((Object)msg, (Throwable)e);
                throw AxisFault.makeFault((Throwable)e);
            }
            log.debug((Object)"JsonFormatter.writeTo() has completed");
        }
        catch (Exception e) {
            String msg = "Exception occurred when try to encode output stream using  CHARACTER_SET_ENCODING charset";
            log.error((Object)msg, (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public String getContentType(MessageContext outMsgCtxt, OMOutputFormat omOutputFormat, String s) {
        return (String)outMsgCtxt.getProperty("ContentType");
    }

    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat omOutputFormat, URL url) throws AxisFault {
        return null;
    }

    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat omOutputFormat, String s) {
        return null;
    }
}

