/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.comp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import org.openjdk.source.tree.LambdaExpressionTree;
import org.openjdk.source.tree.MemberReferenceTree;
import org.openjdk.source.tree.NewClassTree;
import org.openjdk.tools.javac.code.AnnoConstruct;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.code.Type;
import org.openjdk.tools.javac.code.TypeMetadata;
import org.openjdk.tools.javac.code.TypeTag;
import org.openjdk.tools.javac.code.Types;
import org.openjdk.tools.javac.comp.ArgumentAttr;
import org.openjdk.tools.javac.comp.Attr;
import org.openjdk.tools.javac.comp.AttrContext;
import org.openjdk.tools.javac.comp.Check;
import org.openjdk.tools.javac.comp.Enter;
import org.openjdk.tools.javac.comp.Env;
import org.openjdk.tools.javac.comp.Flow;
import org.openjdk.tools.javac.comp.Infer;
import org.openjdk.tools.javac.comp.InferenceContext;
import org.openjdk.tools.javac.comp.Resolve;
import org.openjdk.tools.javac.comp.TypeEnvs;
import org.openjdk.tools.javac.resources.CompilerProperties;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.tree.TreeCopier;
import org.openjdk.tools.javac.tree.TreeInfo;
import org.openjdk.tools.javac.tree.TreeMaker;
import org.openjdk.tools.javac.tree.TreeScanner;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Filter;
import org.openjdk.tools.javac.util.GraphUtils;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Name;
import org.openjdk.tools.javac.util.Names;
import org.openjdk.tools.javac.util.Warner;

public class DeferredAttr
extends JCTree.Visitor {
    protected static final Context.Key<DeferredAttr> deferredAttrKey = new Context.Key();
    final Attr attr;
    final ArgumentAttr argumentAttr;
    final Check chk;
    final JCDiagnostic.Factory diags;
    final Enter enter;
    final Infer infer;
    final Resolve rs;
    final Log log;
    final Symtab syms;
    final TreeMaker make;
    final TreeCopier<Void> treeCopier;
    final Types.TypeMapping<Void> deferredCopier;
    final Types types;
    final Flow flow;
    final Names names;
    final TypeEnvs typeEnvs;
    final JCTree stuckTree;
    DeferredTypeCompleter basicCompleter = new DeferredTypeCompleter(){

        @Override
        public Type complete(DeferredType deferredType, Attr.ResultInfo resultInfo, DeferredAttrContext deferredAttrContext) {
            switch (deferredAttrContext.mode) {
                case SPECULATIVE: {
                    Assert.check(deferredType.mode == null || deferredType.mode == AttrMode.SPECULATIVE);
                    JCTree jCTree = DeferredAttr.this.attribSpeculative(deferredType.tree, deferredType.env, resultInfo);
                    deferredType.speculativeCache.put(jCTree, resultInfo);
                    return jCTree.type;
                }
                case CHECK: {
                    Assert.check(deferredType.mode != null);
                    return DeferredAttr.this.attr.attribTree(deferredType.tree, deferredType.env, resultInfo);
                }
            }
            Assert.error();
            return null;
        }
    };
    DeferredStuckPolicy dummyStuckPolicy = new DeferredStuckPolicy(){

        @Override
        public boolean isStuck() {
            return false;
        }

        @Override
        public Set<Type> stuckVars() {
            return Collections.emptySet();
        }

        @Override
        public Set<Type> depVars() {
            return Collections.emptySet();
        }
    };
    final DeferredAttrContext emptyDeferredAttrContext;

    public static DeferredAttr instance(Context context) {
        DeferredAttr deferredAttr = context.get(deferredAttrKey);
        if (deferredAttr == null) {
            deferredAttr = new DeferredAttr(context);
        }
        return deferredAttr;
    }

    protected DeferredAttr(Context context) {
        context.put(deferredAttrKey, this);
        this.attr = Attr.instance(context);
        this.argumentAttr = ArgumentAttr.instance(context);
        this.chk = Check.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.enter = Enter.instance(context);
        this.infer = Infer.instance(context);
        this.rs = Resolve.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.make = TreeMaker.instance(context);
        this.types = Types.instance(context);
        this.flow = Flow.instance(context);
        this.names = Names.instance(context);
        this.stuckTree = this.make.Ident(this.names.empty).setType(Type.stuckType);
        this.typeEnvs = TypeEnvs.instance(context);
        this.emptyDeferredAttrContext = new DeferredAttrContext(AttrMode.CHECK, null, Resolve.MethodResolutionPhase.BOX, this.infer.emptyContext, null, null){

            @Override
            void addDeferredAttrNode(DeferredType deferredType, Attr.ResultInfo resultInfo, DeferredStuckPolicy deferredStuckPolicy) {
                Assert.error("Empty deferred context!");
            }

            @Override
            void complete() {
                Assert.error("Empty deferred context!");
            }

            public String toString() {
                return "Empty deferred context!";
            }
        };
        this.treeCopier = new TreeCopier<Void>(this.make){

            @Override
            public JCTree visitNewClass(NewClassTree newClassTree, Void void_) {
                JCTree.JCNewClass jCNewClass = (JCTree.JCNewClass)newClassTree;
                if (TreeInfo.isDiamond(jCNewClass)) {
                    JCTree.JCExpression jCExpression = this.copy(jCNewClass.encl, void_);
                    List<JCTree.JCExpression> list = this.copy(jCNewClass.typeargs, void_);
                    JCTree.JCExpression jCExpression2 = this.copy(jCNewClass.clazz, void_);
                    List<JCTree.JCExpression> list2 = this.copy(jCNewClass.args, void_);
                    JCTree.JCClassDecl jCClassDecl = null;
                    return DeferredAttr.this.make.at(jCNewClass.pos).NewClass(jCExpression, list, jCExpression2, list2, jCClassDecl);
                }
                return super.visitNewClass(newClassTree, void_);
            }

            @Override
            public JCTree visitMemberReference(MemberReferenceTree memberReferenceTree, Void void_) {
                final JCTree.JCMemberReference jCMemberReference = (JCTree.JCMemberReference)memberReferenceTree;
                JCTree.JCExpression jCExpression = this.copy(jCMemberReference.expr, void_);
                List<JCTree.JCExpression> list = this.copy(jCMemberReference.typeargs, void_);
                JCTree.JCMemberReference jCMemberReference2 = new JCTree.JCMemberReference(jCMemberReference.mode, jCMemberReference.name, jCExpression, list){

                    @Override
                    public void setOverloadKind(JCTree.JCMemberReference.OverloadKind overloadKind) {
                        super.setOverloadKind(overloadKind);
                        if (jCMemberReference.getOverloadKind() == null) {
                            jCMemberReference.setOverloadKind(overloadKind);
                        }
                    }
                };
                jCMemberReference2.pos = jCMemberReference.pos;
                return jCMemberReference2;
            }
        };
        this.deferredCopier = new Types.TypeMapping<Void>(){

            @Override
            public Type visitType(Type type, Void void_) {
                if (type.hasTag(TypeTag.DEFERRED)) {
                    DeferredType deferredType = (DeferredType)type;
                    return new DeferredType(DeferredAttr.this.treeCopier.copy(deferredType.tree), deferredType.env);
                }
                return type;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCTree.JCLambda attribSpeculativeLambda(JCTree.JCLambda jCLambda, Env<AttrContext> env, Attr.ResultInfo resultInfo) {
        ListBuffer<JCTree.JCStatement> listBuffer = new ListBuffer<JCTree.JCStatement>();
        listBuffer.addAll((Collection<JCTree.JCStatement>)jCLambda.params);
        if (jCLambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
            listBuffer.add(this.make.Return((JCTree.JCExpression)jCLambda.body));
        } else {
            listBuffer.add((JCTree.JCBlock)jCLambda.body);
        }
        JCTree.JCBlock jCBlock = this.make.Block(0L, listBuffer.toList());
        Env<AttrContext> env2 = this.attr.lambdaEnv(jCLambda, env);
        try {
            ((AttrContext)env2.info).returnResult = resultInfo;
            JCTree.JCBlock jCBlock2 = (JCTree.JCBlock)this.attribSpeculative(jCBlock, env2, resultInfo);
            List<JCTree.JCVariableDecl> list = jCBlock2.getStatements().stream().filter(jCStatement -> jCStatement.hasTag(JCTree.Tag.VARDEF)).map(jCStatement -> (JCTree.JCVariableDecl)jCStatement).collect(List.collector());
            JCTree jCTree = (JCTree)((List)jCBlock2.getStatements()).last();
            if (jCTree.hasTag(JCTree.Tag.RETURN)) {
                jCTree = ((JCTree.JCReturn)jCTree).expr;
            }
            JCTree.JCLambda jCLambda2 = this.make.Lambda(list, jCTree);
            this.attr.preFlow(jCLambda2);
            this.flow.analyzeLambda(env, jCLambda2, this.make, false);
            JCTree.JCLambda jCLambda3 = jCLambda2;
            return jCLambda3;
        }
        finally {
            ((AttrContext)env2.info).scope.leave();
        }
    }

    JCTree attribSpeculative(JCTree jCTree2, Env<AttrContext> env, Attr.ResultInfo resultInfo) {
        return this.attribSpeculative(jCTree2, env, resultInfo, this.treeCopier, jCTree -> new DeferredAttrDiagHandler(this.log, (JCTree)jCTree), null);
    }

    JCTree attribSpeculative(JCTree jCTree2, Env<AttrContext> env, Attr.ResultInfo resultInfo, ArgumentAttr.LocalCacheContext localCacheContext) {
        return this.attribSpeculative(jCTree2, env, resultInfo, this.treeCopier, jCTree -> new DeferredAttrDiagHandler(this.log, (JCTree)jCTree), localCacheContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <Z> JCTree attribSpeculative(JCTree jCTree, Env<AttrContext> env, Attr.ResultInfo resultInfo, TreeCopier<Z> treeCopier, Function<JCTree, Log.DeferredDiagnosticHandler> function, ArgumentAttr.LocalCacheContext localCacheContext) {
        JCTree jCTree2 = treeCopier.copy(jCTree);
        Env<AttrContext> env2 = env.dup(jCTree2, ((AttrContext)env.info).dup(((AttrContext)env.info).scope.dupUnshared(((AttrContext)env.info).scope.owner)));
        ((AttrContext)env2.info).isSpeculative = true;
        Log.DeferredDiagnosticHandler deferredDiagnosticHandler = function.apply(jCTree2);
        try {
            this.attr.attribTree(jCTree2, env2, resultInfo);
            JCTree jCTree3 = jCTree2;
            return jCTree3;
        }
        finally {
            new UnenterScanner(env.toplevel.modle).scan(jCTree2);
            this.log.popDiagnosticHandler(deferredDiagnosticHandler);
            if (localCacheContext != null) {
                localCacheContext.leave();
            }
        }
    }

    class OverloadStuckPolicy
    extends CheckStuckPolicy
    implements DeferredStuckPolicy {
        boolean stuck;

        @Override
        public boolean isStuck() {
            return super.isStuck() || this.stuck;
        }

        public OverloadStuckPolicy(Attr.ResultInfo resultInfo, DeferredType deferredType) {
            super(resultInfo, deferredType);
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            super.visitLambda(jCLambda);
            if (jCLambda.paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT) {
                this.stuck = true;
            }
        }

        @Override
        public void visitReference(JCTree.JCMemberReference jCMemberReference) {
            super.visitReference(jCMemberReference);
            if (jCMemberReference.getOverloadKind() == JCTree.JCMemberReference.OverloadKind.OVERLOADED) {
                this.stuck = true;
            }
        }
    }

    class CheckStuckPolicy
    extends PolyScanner
    implements DeferredStuckPolicy,
    Infer.FreeTypeListener {
        Type pt;
        InferenceContext inferenceContext;
        Set<Type> stuckVars = new LinkedHashSet<Type>();
        Set<Type> depVars = new LinkedHashSet<Type>();

        @Override
        public boolean isStuck() {
            return !this.stuckVars.isEmpty();
        }

        @Override
        public Set<Type> stuckVars() {
            return this.stuckVars;
        }

        @Override
        public Set<Type> depVars() {
            return this.depVars;
        }

        public CheckStuckPolicy(Attr.ResultInfo resultInfo, DeferredType deferredType) {
            this.pt = resultInfo.pt;
            this.inferenceContext = resultInfo.checkContext.inferenceContext();
            this.scan(deferredType.tree);
            if (!this.stuckVars.isEmpty()) {
                resultInfo.checkContext.inferenceContext().addFreeTypeListener(List.from(this.stuckVars), this);
            }
        }

        @Override
        public void typesInferred(InferenceContext inferenceContext) {
            this.stuckVars.clear();
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            if (this.inferenceContext.inferenceVars().contains(this.pt)) {
                this.stuckVars.add(this.pt);
            }
            if (!DeferredAttr.this.types.isFunctionalInterface(this.pt)) {
                return;
            }
            Type type = DeferredAttr.this.types.findDescriptorType(this.pt);
            List<Type> list = this.inferenceContext.freeVarsIn(type.getParameterTypes());
            if (jCLambda.paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT && list.nonEmpty()) {
                this.stuckVars.addAll(list);
                this.depVars.addAll(this.inferenceContext.freeVarsIn(type.getReturnType()));
            }
            this.scanLambdaBody(jCLambda, type.getReturnType());
        }

        @Override
        public void visitReference(JCTree.JCMemberReference jCMemberReference) {
            this.scan(jCMemberReference.expr);
            if (this.inferenceContext.inferenceVars().contains(this.pt)) {
                this.stuckVars.add(this.pt);
                return;
            }
            if (!DeferredAttr.this.types.isFunctionalInterface(this.pt)) {
                return;
            }
            Type type = DeferredAttr.this.types.findDescriptorType(this.pt);
            List<Type> list = this.inferenceContext.freeVarsIn(type.getParameterTypes());
            if (list.nonEmpty() && jCMemberReference.getOverloadKind() == JCTree.JCMemberReference.OverloadKind.OVERLOADED) {
                this.stuckVars.addAll(list);
                this.depVars.addAll(this.inferenceContext.freeVarsIn(type.getReturnType()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void scanLambdaBody(JCTree.JCLambda jCLambda, final Type type) {
            if (jCLambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                Type type2 = this.pt;
                try {
                    this.pt = type;
                    this.scan(jCLambda.body);
                }
                finally {
                    this.pt = type2;
                }
            } else {
                LambdaReturnScanner lambdaReturnScanner = new LambdaReturnScanner(){

                    @Override
                    public void visitReturn(JCTree.JCReturn jCReturn) {
                        if (jCReturn.expr != null) {
                            Type type2 = CheckStuckPolicy.this.pt;
                            try {
                                CheckStuckPolicy.this.pt = type;
                                CheckStuckPolicy.this.scan(jCReturn.expr);
                            }
                            finally {
                                CheckStuckPolicy.this.pt = type2;
                            }
                        }
                    }
                };
                lambdaReturnScanner.scan(jCLambda.body);
            }
        }
    }

    static class LambdaReturnScanner
    extends FilterScanner {
        LambdaReturnScanner() {
            super(EnumSet.of(JCTree.Tag.BLOCK, new JCTree.Tag[]{JCTree.Tag.CASE, JCTree.Tag.CATCH, JCTree.Tag.DOLOOP, JCTree.Tag.FOREACHLOOP, JCTree.Tag.FORLOOP, JCTree.Tag.IF, JCTree.Tag.RETURN, JCTree.Tag.SYNCHRONIZED, JCTree.Tag.SWITCH, JCTree.Tag.TRY, JCTree.Tag.WHILELOOP}));
        }
    }

    static class PolyScanner
    extends FilterScanner {
        PolyScanner() {
            super(EnumSet.of(JCTree.Tag.CONDEXPR, JCTree.Tag.PARENS, JCTree.Tag.LAMBDA, JCTree.Tag.REFERENCE));
        }
    }

    static abstract class FilterScanner
    extends TreeScanner {
        final Filter<JCTree> treeFilter = jCTree -> set.contains((Object)jCTree.getTag());

        FilterScanner(Set<JCTree.Tag> set) {
        }

        @Override
        public void scan(JCTree jCTree) {
            if (jCTree != null) {
                if (this.treeFilter.accepts(jCTree)) {
                    super.scan(jCTree);
                } else {
                    this.skip(jCTree);
                }
            }
        }

        void skip(JCTree jCTree) {
        }
    }

    public class RecoveryDeferredTypeMap
    extends DeferredTypeMap {
        public RecoveryDeferredTypeMap(AttrMode attrMode, Symbol symbol, Resolve.MethodResolutionPhase methodResolutionPhase) {
            super(attrMode, symbol, methodResolutionPhase != null ? methodResolutionPhase : Resolve.MethodResolutionPhase.BOX);
        }

        @Override
        protected Type typeOf(DeferredType deferredType) {
            Type type = super.typeOf(deferredType);
            return type == Type.noType ? this.recover(deferredType) : type;
        }

        private Type recover(DeferredType deferredType) {
            Attr attr = DeferredAttr.this.attr;
            attr.getClass();
            deferredType.check(new Attr.RecoveryInfo(attr, this.deferredAttrContext){
                {
                    Attr attr2 = attr;
                    attr2.getClass();
                    super(attr2, deferredAttrContext);
                }

                @Override
                protected Type check(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
                    return DeferredAttr.this.chk.checkNonVoid(diagnosticPosition, super.check(diagnosticPosition, type));
                }
            });
            return super.visit(deferredType);
        }
    }

    class DeferredTypeMap
    extends Type.StructuralTypeMapping<Void> {
        DeferredAttrContext deferredAttrContext;

        protected DeferredTypeMap(AttrMode attrMode, Symbol symbol, Resolve.MethodResolutionPhase methodResolutionPhase) {
            this.deferredAttrContext = new DeferredAttrContext(attrMode, symbol, methodResolutionPhase, DeferredAttr.this.infer.emptyContext, DeferredAttr.this.emptyDeferredAttrContext, DeferredAttr.this.types.noWarnings);
        }

        @Override
        public Type visitType(Type type, Void void_) {
            if (!type.hasTag(TypeTag.DEFERRED)) {
                return super.visitType(type, (Object)null);
            }
            DeferredType deferredType = (DeferredType)type;
            return this.typeOf(deferredType);
        }

        protected Type typeOf(DeferredType deferredType) {
            switch (this.deferredAttrContext.mode) {
                case CHECK: {
                    return deferredType.tree.type == null ? Type.noType : deferredType.tree.type;
                }
                case SPECULATIVE: {
                    return deferredType.speculativeType(this.deferredAttrContext.msym, this.deferredAttrContext.phase);
                }
            }
            Assert.error();
            return null;
        }
    }

    class DeferredAttrNode {
        DeferredType dt;
        Attr.ResultInfo resultInfo;
        DeferredStuckPolicy deferredStuckPolicy;

        DeferredAttrNode(DeferredType deferredType, Attr.ResultInfo resultInfo, DeferredStuckPolicy deferredStuckPolicy) {
            this.dt = deferredType;
            this.resultInfo = resultInfo;
            this.deferredStuckPolicy = deferredStuckPolicy;
        }

        boolean process(final DeferredAttrContext deferredAttrContext) {
            switch (deferredAttrContext.mode) {
                case SPECULATIVE: {
                    if (this.deferredStuckPolicy.isStuck()) {
                        this.dt.check(this.resultInfo, DeferredAttr.this.dummyStuckPolicy, new StructuralStuckChecker());
                        return true;
                    }
                    Assert.error("Cannot get here");
                }
                case CHECK: {
                    if (this.deferredStuckPolicy.isStuck()) {
                        if (deferredAttrContext.parent != DeferredAttr.this.emptyDeferredAttrContext && Type.containsAny(deferredAttrContext.parent.inferenceContext.inferencevars, List.from(this.deferredStuckPolicy.stuckVars()))) {
                            deferredAttrContext.parent.addDeferredAttrNode(this.dt, this.resultInfo.dup(new Check.NestedCheckContext(this.resultInfo.checkContext){

                                @Override
                                public InferenceContext inferenceContext() {
                                    return deferredAttrContext.parent.inferenceContext;
                                }

                                @Override
                                public DeferredAttrContext deferredAttrContext() {
                                    return deferredAttrContext.parent;
                                }
                            }), this.deferredStuckPolicy);
                            this.dt.tree.type = Type.stuckType;
                            return true;
                        }
                        return false;
                    }
                    Assert.check(!deferredAttrContext.insideOverloadPhase(), "attribution shouldn't be happening here");
                    Attr.ResultInfo resultInfo = this.resultInfo.dup(deferredAttrContext.inferenceContext.asInstType(this.resultInfo.pt));
                    this.dt.check(resultInfo, DeferredAttr.this.dummyStuckPolicy, DeferredAttr.this.basicCompleter);
                    return true;
                }
            }
            throw new AssertionError((Object)"Bad mode");
        }

        class LambdaBodyStructChecker
        extends TreeScanner {
            boolean isVoidCompatible = true;
            boolean isPotentiallyValueCompatible = true;

            LambdaBodyStructChecker() {
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            }

            @Override
            public void visitLambda(JCTree.JCLambda jCLambda) {
            }

            @Override
            public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            }

            @Override
            public void visitReturn(JCTree.JCReturn jCReturn) {
                if (jCReturn.expr != null) {
                    this.isVoidCompatible = false;
                } else {
                    this.isPotentiallyValueCompatible = false;
                }
            }
        }

        class StructuralStuckChecker
        extends TreeScanner
        implements DeferredTypeCompleter {
            Attr.ResultInfo resultInfo;
            InferenceContext inferenceContext;
            Env<AttrContext> env;

            StructuralStuckChecker() {
            }

            @Override
            public Type complete(DeferredType deferredType, Attr.ResultInfo resultInfo, DeferredAttrContext deferredAttrContext) {
                this.resultInfo = resultInfo;
                this.inferenceContext = deferredAttrContext.inferenceContext;
                this.env = deferredType.env;
                deferredType.tree.accept(this);
                deferredType.speculativeCache.put(DeferredAttr.this.stuckTree, resultInfo);
                return Type.noType;
            }

            @Override
            public void visitLambda(JCTree.JCLambda jCLambda) {
                Check.CheckContext checkContext = this.resultInfo.checkContext;
                Type type = this.resultInfo.pt;
                if (!this.inferenceContext.inferencevars.contains(type)) {
                    Type type2 = null;
                    try {
                        type2 = DeferredAttr.this.types.findDescriptorType(type);
                    }
                    catch (Types.FunctionDescriptorLookupError functionDescriptorLookupError) {
                        checkContext.report(null, functionDescriptorLookupError.getDiagnostic());
                    }
                    if (type2.getParameterTypes().length() != jCLambda.params.length()) {
                        checkContext.report(jCLambda, DeferredAttr.this.diags.fragment("incompatible.arg.types.in.lambda", new Object[0]));
                    }
                    Type type3 = type2.getReturnType();
                    boolean bl = type3.hasTag(TypeTag.VOID);
                    if (jCLambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                        boolean bl2;
                        boolean bl3 = bl2 = !bl || TreeInfo.isExpressionStatement((JCTree.JCExpression)jCLambda.getBody());
                        if (!bl2) {
                            this.resultInfo.checkContext.report(jCLambda.pos(), DeferredAttr.this.diags.fragment("incompatible.ret.type.in.lambda", DeferredAttr.this.diags.fragment("missing.ret.val", type3)));
                        }
                    } else {
                        LambdaBodyStructChecker lambdaBodyStructChecker = new LambdaBodyStructChecker();
                        jCLambda.body.accept(lambdaBodyStructChecker);
                        boolean bl4 = lambdaBodyStructChecker.isVoidCompatible;
                        if (bl) {
                            if (!bl4) {
                                this.resultInfo.checkContext.report(jCLambda.pos(), DeferredAttr.this.diags.fragment("unexpected.ret.val", new Object[0]));
                            }
                        } else {
                            boolean bl5;
                            boolean bl6 = bl5 = lambdaBodyStructChecker.isPotentiallyValueCompatible && !this.canLambdaBodyCompleteNormally(jCLambda);
                            if (!bl5 && !bl4) {
                                DeferredAttr.this.log.error(jCLambda.body.pos(), "lambda.body.neither.value.nor.void.compatible", new Object[0]);
                            }
                            if (!bl5) {
                                this.resultInfo.checkContext.report(jCLambda.pos(), DeferredAttr.this.diags.fragment("incompatible.ret.type.in.lambda", DeferredAttr.this.diags.fragment("missing.ret.val", type3)));
                            }
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean canLambdaBodyCompleteNormally(JCTree.JCLambda jCLambda) {
                List<JCTree.JCVariableDecl> list = jCLambda.params;
                ArgumentAttr.LocalCacheContext localCacheContext = DeferredAttr.this.argumentAttr.withLocalCacheContext();
                try {
                    jCLambda.params = jCLambda.params.stream().map(jCVariableDecl -> DeferredAttr.this.make.VarDef(jCVariableDecl.mods, jCVariableDecl.name, DeferredAttr.this.make.Erroneous(), null)).collect(List.collector());
                    boolean bl = DeferredAttr.this.attribSpeculativeLambda((JCTree.JCLambda)jCLambda, this.env, (Attr.ResultInfo)DeferredAttr.this.attr.unknownExprInfo).canCompleteNormally;
                    return bl;
                }
                finally {
                    localCacheContext.leave();
                    jCLambda.params = list;
                }
            }

            @Override
            public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            }

            @Override
            public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
            }

            @Override
            public void visitReference(JCTree.JCMemberReference jCMemberReference) {
                Assert.checkNonNull(jCMemberReference.getOverloadKind());
                Check.CheckContext checkContext = this.resultInfo.checkContext;
                Type type = this.resultInfo.pt;
                if (!this.inferenceContext.inferencevars.contains(type)) {
                    AnnoConstruct annoConstruct2;
                    try {
                        DeferredAttr.this.types.findDescriptorType(type);
                    }
                    catch (Types.FunctionDescriptorLookupError functionDescriptorLookupError) {
                        checkContext.report(null, functionDescriptorLookupError.getDiagnostic());
                    }
                    Env<AttrContext> env = this.env.dup(jCMemberReference);
                    JCTree.JCExpression jCExpression = (JCTree.JCExpression)DeferredAttr.this.attribSpeculative(jCMemberReference.getQualifierExpression(), env, DeferredAttr.this.attr.memberReferenceQualifierResult(jCMemberReference), DeferredAttr.this.argumentAttr.withLocalCacheContext());
                    ListBuffer<Type.JCNoType> listBuffer = new ListBuffer<Type.JCNoType>();
                    for (AnnoConstruct annoConstruct2 : DeferredAttr.this.types.findDescriptorType(type).getParameterTypes()) {
                        listBuffer.append(Type.noType);
                    }
                    JCTree.JCMemberReference jCMemberReference2 = new TreeCopier(DeferredAttr.this.make).copy(jCMemberReference);
                    jCMemberReference2.expr = jCExpression;
                    annoConstruct2 = (Symbol)DeferredAttr.this.rs.resolveMemberReference(env, (JCTree.JCMemberReference)jCMemberReference2, (Type)jCExpression.type, (Name)jCMemberReference.name, listBuffer.toList(), List.nil(), (Resolve.MethodCheck)DeferredAttr.this.rs.arityMethodCheck, (InferenceContext)this.inferenceContext, (Resolve.ReferenceChooser)DeferredAttr.this.rs.structuralReferenceChooser).fst;
                    switch (((Symbol)annoConstruct2).kind) {
                        case WRONG_MTH: 
                        case WRONG_MTHS: {
                            checkContext.report(jCMemberReference, DeferredAttr.this.diags.fragment(CompilerProperties.Fragments.IncompatibleArgTypesInMref));
                            break;
                        }
                        case ABSENT_MTH: 
                        case STATICERR: {
                            checkContext.report(jCMemberReference, ((Resolve.ResolveError)annoConstruct2).getDiagnostic(JCDiagnostic.DiagnosticType.FRAGMENT, jCMemberReference, jCExpression.type.tsym, jCExpression.type, jCMemberReference.name, listBuffer.toList(), List.nil()));
                        }
                    }
                }
            }
        }
    }

    class DeferredAttrContext {
        final AttrMode mode;
        final Symbol msym;
        final Resolve.MethodResolutionPhase phase;
        final InferenceContext inferenceContext;
        final DeferredAttrContext parent;
        final Warner warn;
        ArrayList<DeferredAttrNode> deferredAttrNodes = new ArrayList();

        DeferredAttrContext(AttrMode attrMode, Symbol symbol, Resolve.MethodResolutionPhase methodResolutionPhase, InferenceContext inferenceContext, DeferredAttrContext deferredAttrContext, Warner warner) {
            this.mode = attrMode;
            this.msym = symbol;
            this.phase = methodResolutionPhase;
            this.parent = deferredAttrContext;
            this.warn = warner;
            this.inferenceContext = inferenceContext;
        }

        void addDeferredAttrNode(DeferredType deferredType, Attr.ResultInfo resultInfo, DeferredStuckPolicy deferredStuckPolicy) {
            this.deferredAttrNodes.add(new DeferredAttrNode(deferredType, resultInfo, deferredStuckPolicy));
        }

        void complete() {
            while (!this.deferredAttrNodes.isEmpty()) {
                boolean bl = false;
                for (DeferredAttrNode deferredAttrNode : List.from(this.deferredAttrNodes)) {
                    if (!deferredAttrNode.process(this)) continue;
                    this.deferredAttrNodes.remove(deferredAttrNode);
                    bl = true;
                }
                if (bl) continue;
                if (this.insideOverloadPhase()) {
                    for (DeferredAttrNode deferredAttrNode : this.deferredAttrNodes) {
                        deferredAttrNode.dt.tree.type = Type.noType;
                    }
                    return;
                }
                try {
                    DeferredAttrNode deferredAttrNode = this.pickDeferredNode();
                    this.inferenceContext.solveAny(List.from(deferredAttrNode.deferredStuckPolicy.stuckVars()), this.warn);
                    this.inferenceContext.notifyChange();
                }
                catch (Infer.GraphStrategy.NodeNotFoundException nodeNotFoundException) {
                    break;
                }
            }
        }

        public boolean insideOverloadPhase() {
            DeferredAttrContext deferredAttrContext = this;
            if (deferredAttrContext == DeferredAttr.this.emptyDeferredAttrContext) {
                return false;
            }
            if (deferredAttrContext.mode == AttrMode.SPECULATIVE) {
                return true;
            }
            return deferredAttrContext.parent.insideOverloadPhase();
        }

        DeferredAttrNode pickDeferredNode() {
            List list = this.deferredAttrNodes.stream().map(deferredAttrNode -> new StuckNode((DeferredAttrNode)deferredAttrNode)).collect(List.collector());
            for (StuckNode stuckNode : list) {
                for (Type type : ((DeferredAttrNode)stuckNode.data).deferredStuckPolicy.stuckVars()) {
                    for (StuckNode stuckNode2 : list) {
                        if (stuckNode == stuckNode2 || !((DeferredAttrNode)stuckNode2.data).deferredStuckPolicy.depVars().contains(type)) continue;
                        stuckNode.deps.add(stuckNode2);
                    }
                }
            }
            List list2 = GraphUtils.tarjan(list).get(0);
            return list2.length() == 1 ? (DeferredAttrNode)((StuckNode)list2.get((int)0)).data : this.deferredAttrNodes.get(0);
        }

        class StuckNode
        extends GraphUtils.TarjanNode<DeferredAttrNode, StuckNode> {
            Set<StuckNode> deps;

            StuckNode(DeferredAttrNode deferredAttrNode) {
                super(deferredAttrNode);
                this.deps = new HashSet<StuckNode>();
            }

            @Override
            public GraphUtils.DependencyKind[] getSupportedDependencyKinds() {
                return new GraphUtils.DependencyKind[]{Infer.DependencyKind.STUCK};
            }

            @Override
            public Collection<? extends StuckNode> getDependenciesByKind(GraphUtils.DependencyKind dependencyKind) {
                if (dependencyKind == Infer.DependencyKind.STUCK) {
                    return this.deps;
                }
                throw new IllegalStateException();
            }

            @Override
            public Iterable<? extends StuckNode> getAllDependencies() {
                return this.deps;
            }
        }
    }

    static class DeferredAttrDiagHandler
    extends Log.DeferredDiagnosticHandler {
        DeferredAttrDiagHandler(Log log, JCTree jCTree) {
            super(log, (JCDiagnostic jCDiagnostic) -> {
                PosScanner posScanner = new PosScanner(jCDiagnostic.getDiagnosticPosition());
                posScanner.scan(jCTree);
                return posScanner.found;
            });
        }

        static class PosScanner
        extends TreeScanner {
            JCDiagnostic.DiagnosticPosition pos;
            boolean found = false;

            PosScanner(JCDiagnostic.DiagnosticPosition diagnosticPosition) {
                this.pos = diagnosticPosition;
            }

            @Override
            public void scan(JCTree jCTree) {
                if (jCTree != null && jCTree.pos() == this.pos) {
                    this.found = true;
                }
                super.scan(jCTree);
            }
        }
    }

    class UnenterScanner
    extends TreeScanner {
        private final Symbol.ModuleSymbol msym;

        public UnenterScanner(Symbol.ModuleSymbol moduleSymbol) {
            this.msym = moduleSymbol;
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            Symbol.ClassSymbol classSymbol = jCClassDecl.sym;
            if (classSymbol == null) {
                return;
            }
            DeferredAttr.this.typeEnvs.remove(classSymbol);
            DeferredAttr.this.chk.removeCompiled(classSymbol);
            DeferredAttr.this.chk.clearLocalClassNameIndexes(classSymbol);
            DeferredAttr.this.syms.removeClass(this.msym, classSymbol.flatname);
            super.visitClassDef(jCClassDecl);
        }
    }

    public static enum AttrMode {
        SPECULATIVE,
        CHECK;

    }

    static interface DeferredStuckPolicy {
        public boolean isStuck();

        public Set<Type> stuckVars();

        public Set<Type> depVars();
    }

    static interface DeferredTypeCompleter {
        public Type complete(DeferredType var1, Attr.ResultInfo var2, DeferredAttrContext var3);
    }

    public class DeferredType
    extends Type {
        public JCTree.JCExpression tree;
        Env<AttrContext> env;
        AttrMode mode;
        boolean pertinentToApplicability;
        SpeculativeCache speculativeCache;

        DeferredType(JCTree.JCExpression jCExpression, Env<AttrContext> env) {
            super(null, TypeMetadata.EMPTY);
            this.pertinentToApplicability = true;
            this.tree = jCExpression;
            this.env = DeferredAttr.this.attr.copyEnv(env);
            this.speculativeCache = new SpeculativeCache();
        }

        @Override
        public DeferredType cloneWithMetadata(TypeMetadata typeMetadata) {
            throw new AssertionError((Object)"Cannot add metadata to a deferred type");
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.DEFERRED;
        }

        @Override
        public String toString() {
            return "DeferredType";
        }

        Type speculativeType(Symbol symbol, Resolve.MethodResolutionPhase methodResolutionPhase) {
            SpeculativeCache.Entry entry = this.speculativeCache.get(symbol, methodResolutionPhase);
            return entry != null ? entry.speculativeTree.type : Type.noType;
        }

        JCTree speculativeTree(DeferredAttrContext deferredAttrContext) {
            SpeculativeCache.Entry entry = this.speculativeCache.get(deferredAttrContext.msym, deferredAttrContext.phase);
            return entry != null ? entry.speculativeTree : DeferredAttr.this.stuckTree;
        }

        DeferredTypeCompleter completer() {
            return DeferredAttr.this.basicCompleter;
        }

        Type check(Attr.ResultInfo resultInfo) {
            DeferredStuckPolicy deferredStuckPolicy = resultInfo.pt.hasTag(TypeTag.NONE) || resultInfo.pt.isErroneous() ? DeferredAttr.this.dummyStuckPolicy : (resultInfo.checkContext.deferredAttrContext().mode == AttrMode.SPECULATIVE || resultInfo.checkContext.deferredAttrContext().insideOverloadPhase() ? new OverloadStuckPolicy(resultInfo, this) : new CheckStuckPolicy(resultInfo, this));
            return this.check(resultInfo, deferredStuckPolicy, this.completer());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Type check(Attr.ResultInfo resultInfo, DeferredStuckPolicy deferredStuckPolicy, DeferredTypeCompleter deferredTypeCompleter) {
            DeferredAttrContext deferredAttrContext = resultInfo.checkContext.deferredAttrContext();
            Assert.check(deferredAttrContext != DeferredAttr.this.emptyDeferredAttrContext);
            if (deferredStuckPolicy.isStuck()) {
                this.pertinentToApplicability = false;
                deferredAttrContext.addDeferredAttrNode(this, resultInfo, deferredStuckPolicy);
                return Type.noType;
            }
            try {
                Type type = deferredTypeCompleter.complete(this, resultInfo, deferredAttrContext);
                return type;
            }
            finally {
                this.mode = deferredAttrContext.mode;
            }
        }

        class SpeculativeCache {
            private Map<Symbol, List<Entry>> cache = new WeakHashMap<Symbol, List<Entry>>();

            SpeculativeCache() {
            }

            Entry get(Symbol symbol, Resolve.MethodResolutionPhase methodResolutionPhase) {
                List<Entry> list = this.cache.get(symbol);
                if (list == null) {
                    return null;
                }
                for (Entry entry : list) {
                    if (!entry.matches(methodResolutionPhase)) continue;
                    return entry;
                }
                return null;
            }

            void put(JCTree jCTree, Attr.ResultInfo resultInfo) {
                Symbol symbol = resultInfo.checkContext.deferredAttrContext().msym;
                List<Entry> list = this.cache.get(symbol);
                if (list == null) {
                    list = List.nil();
                }
                this.cache.put(symbol, list.prepend(new Entry(jCTree, resultInfo)));
            }

            class Entry {
                JCTree speculativeTree;
                Attr.ResultInfo resultInfo;

                public Entry(JCTree jCTree, Attr.ResultInfo resultInfo) {
                    this.speculativeTree = jCTree;
                    this.resultInfo = resultInfo;
                }

                boolean matches(Resolve.MethodResolutionPhase methodResolutionPhase) {
                    return this.resultInfo.checkContext.deferredAttrContext().phase == methodResolutionPhase;
                }
            }
        }
    }
}

