/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.main;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.MissingResourceException;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import org.openjdk.javax.annotation.processing.Processor;
import org.openjdk.javax.lang.model.SourceVersion;
import org.openjdk.javax.lang.model.element.ElementVisitor;
import org.openjdk.javax.tools.Diagnostic;
import org.openjdk.javax.tools.DiagnosticListener;
import org.openjdk.javax.tools.JavaFileManager;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.javax.tools.StandardLocation;
import org.openjdk.source.util.TaskEvent;
import org.openjdk.tools.javac.api.MultiTaskListener;
import org.openjdk.tools.javac.code.ClassFinder;
import org.openjdk.tools.javac.code.Kinds;
import org.openjdk.tools.javac.code.Lint;
import org.openjdk.tools.javac.code.ModuleFinder;
import org.openjdk.tools.javac.code.Source;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.code.Type;
import org.openjdk.tools.javac.code.TypeTag;
import org.openjdk.tools.javac.code.Types;
import org.openjdk.tools.javac.comp.Annotate;
import org.openjdk.tools.javac.comp.Attr;
import org.openjdk.tools.javac.comp.AttrContext;
import org.openjdk.tools.javac.comp.Check;
import org.openjdk.tools.javac.comp.CompileStates;
import org.openjdk.tools.javac.comp.Enter;
import org.openjdk.tools.javac.comp.Env;
import org.openjdk.tools.javac.comp.Flow;
import org.openjdk.tools.javac.comp.LambdaToMethod;
import org.openjdk.tools.javac.comp.Lower;
import org.openjdk.tools.javac.comp.Modules;
import org.openjdk.tools.javac.comp.Todo;
import org.openjdk.tools.javac.comp.TransTypes;
import org.openjdk.tools.javac.file.JavacFileManager;
import org.openjdk.tools.javac.jvm.ClassReader;
import org.openjdk.tools.javac.jvm.ClassWriter;
import org.openjdk.tools.javac.jvm.Gen;
import org.openjdk.tools.javac.jvm.JNIWriter;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.parser.ParserFactory;
import org.openjdk.tools.javac.platform.PlatformDescription;
import org.openjdk.tools.javac.processing.JavacProcessingEnvironment;
import org.openjdk.tools.javac.resources.CompilerProperties;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.tree.Pretty;
import org.openjdk.tools.javac.tree.TreeInfo;
import org.openjdk.tools.javac.tree.TreeMaker;
import org.openjdk.tools.javac.tree.TreeScanner;
import org.openjdk.tools.javac.tree.TreeTranslator;
import org.openjdk.tools.javac.util.Abort;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.FatalError;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Name;
import org.openjdk.tools.javac.util.Names;
import org.openjdk.tools.javac.util.Options;
import org.openjdk.tools.javac.util.Pair;
import org.openjdk.tools.javac.util.RichDiagnosticFormatter;

public class JavaCompiler {
    public static final Context.Key<JavaCompiler> compilerKey = new Context.Key();
    private static final String versionRBName = "org.openjdk.tools.javac.resources.version";
    private static ResourceBundle versionRB;
    private static final CompilePolicy DEFAULT_COMPILE_POLICY;
    public Log log;
    JCDiagnostic.Factory diagFactory;
    protected TreeMaker make;
    protected ClassFinder finder;
    protected ClassReader reader;
    protected ClassWriter writer;
    protected JNIWriter jniWriter;
    protected Enter enter;
    protected Symtab syms;
    protected Source source;
    protected Gen gen;
    protected Names names;
    protected Attr attr;
    protected Check chk;
    protected Flow flow;
    protected Modules modules;
    protected ModuleFinder moduleFinder;
    protected JCDiagnostic.Factory diags;
    protected TransTypes transTypes;
    protected Lower lower;
    protected Annotate annotate;
    protected final Name completionFailureName;
    protected Types types;
    protected JavaFileManager fileManager;
    protected ParserFactory parserFactory;
    protected MultiTaskListener taskListener;
    protected final Symbol.Completer sourceCompleter;
    protected Options options;
    protected Context context;
    protected boolean annotationProcessingOccurred;
    protected boolean implicitSourceFilesRead;
    private boolean enterDone;
    protected CompileStates compileStates;
    public boolean verbose;
    public boolean sourceOutput;
    public boolean lineDebugInfo;
    public boolean genEndPos;
    protected boolean devVerbose;
    protected boolean processPcks;
    protected boolean werror;
    protected boolean explicitAnnotationProcessingRequested;
    protected CompilePolicy compilePolicy;
    protected ImplicitSourcePolicy implicitSourcePolicy;
    public boolean verboseCompilePolicy;
    public CompileStates.CompileState shouldStopPolicyIfError;
    public CompileStates.CompileState shouldStopPolicyIfNoError;
    public Todo todo;
    public List<Closeable> closeables;
    protected Set<JavaFileObject> inputFiles;
    private final Symbol silentFail;
    public boolean keepComments;
    private boolean hasBeenUsed;
    private long start_msec;
    public long elapsed_msec;
    private List<JCTree.JCClassDecl> rootClasses;
    boolean processAnnotations;
    Log.DeferredDiagnosticHandler deferredDiagnosticHandler;
    private JavacProcessingEnvironment procEnvImpl;
    HashMap<Env<AttrContext>, Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>>> desugaredEnvs;

    public static JavaCompiler instance(Context context) {
        JavaCompiler javaCompiler = context.get(compilerKey);
        if (javaCompiler == null) {
            javaCompiler = new JavaCompiler(context);
        }
        return javaCompiler;
    }

    public static String version() {
        return JavaCompiler.version("release");
    }

    public static String fullVersion() {
        return JavaCompiler.version("full");
    }

    private static String version(String string) {
        if (versionRB == null) {
            try {
                versionRB = ResourceBundle.getBundle(versionRBName);
            }
            catch (MissingResourceException missingResourceException) {
                return Log.getLocalizedString("version.not.available", new Object[0]);
            }
        }
        try {
            return versionRB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return Log.getLocalizedString("version.not.available", new Object[0]);
        }
    }

    public JavaCompiler(Context context) {
        PlatformDescription platformDescription;
        block5: {
            this.sourceCompleter = symbol -> this.readSourceFile((Symbol.ClassSymbol)symbol);
            this.explicitAnnotationProcessingRequested = false;
            this.closeables = List.nil();
            this.inputFiles = new HashSet<JavaFileObject>();
            this.keepComments = false;
            this.hasBeenUsed = false;
            this.start_msec = 0L;
            this.elapsed_msec = 0L;
            this.processAnnotations = false;
            this.procEnvImpl = null;
            this.desugaredEnvs = new HashMap();
            this.context = context;
            context.put(compilerKey, this);
            if (context.get(JavaFileManager.class) == null) {
                JavacFileManager.preRegister(context);
            }
            this.names = Names.instance(context);
            this.log = Log.instance(context);
            this.diagFactory = JCDiagnostic.Factory.instance(context);
            this.finder = ClassFinder.instance(context);
            this.reader = ClassReader.instance(context);
            this.make = TreeMaker.instance(context);
            this.writer = ClassWriter.instance(context);
            this.jniWriter = JNIWriter.instance(context);
            this.enter = Enter.instance(context);
            this.todo = Todo.instance(context);
            this.fileManager = context.get(JavaFileManager.class);
            this.parserFactory = ParserFactory.instance(context);
            this.compileStates = CompileStates.instance(context);
            try {
                this.syms = Symtab.instance(context);
            }
            catch (Symbol.CompletionFailure completionFailure) {
                this.log.error("cant.access", completionFailure.sym, completionFailure.getDetailValue());
                if (!(completionFailure instanceof ClassFinder.BadClassFile)) break block5;
                throw new Abort();
            }
        }
        this.source = Source.instance(context);
        this.attr = Attr.instance(context);
        this.chk = Check.instance(context);
        this.gen = Gen.instance(context);
        this.flow = Flow.instance(context);
        this.transTypes = TransTypes.instance(context);
        this.lower = Lower.instance(context);
        this.annotate = Annotate.instance(context);
        this.types = Types.instance(context);
        this.taskListener = MultiTaskListener.instance(context);
        this.modules = Modules.instance(context);
        this.moduleFinder = ModuleFinder.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.finder.sourceCompleter = this.sourceCompleter;
        this.modules.findPackageInFile = this::findPackageInFile;
        this.moduleFinder.moduleNameFromSourceReader = this::readModuleName;
        this.options = Options.instance(context);
        this.verbose = this.options.isSet(Option.VERBOSE);
        this.sourceOutput = this.options.isSet(Option.PRINTSOURCE);
        this.lineDebugInfo = this.options.isUnset(Option.G_CUSTOM) || this.options.isSet(Option.G_CUSTOM, "lines");
        this.genEndPos = this.options.isSet(Option.XJCOV) || context.get(DiagnosticListener.class) != null;
        this.devVerbose = this.options.isSet("dev");
        this.processPcks = this.options.isSet("process.packages");
        this.werror = this.options.isSet(Option.WERROR);
        this.verboseCompilePolicy = this.options.isSet("verboseCompilePolicy");
        this.compilePolicy = this.options.isSet("should-stop.at") && CompileStates.CompileState.valueOf(this.options.get("should-stop.at")) == CompileStates.CompileState.ATTR ? CompilePolicy.ATTR_ONLY : CompilePolicy.decode(this.options.get("compilePolicy"));
        this.implicitSourcePolicy = ImplicitSourcePolicy.decode(this.options.get("-implicit"));
        Name name = this.completionFailureName = this.options.isSet("failcomplete") ? this.names.fromString(this.options.get("failcomplete")) : null;
        this.shouldStopPolicyIfError = this.options.isSet("should-stop.at") ? CompileStates.CompileState.valueOf(this.options.get("should-stop.at")) : (this.options.isSet("should-stop.ifError") ? CompileStates.CompileState.valueOf(this.options.get("should-stop.ifError")) : CompileStates.CompileState.INIT);
        CompileStates.CompileState compileState = this.shouldStopPolicyIfNoError = this.options.isSet("should-stop.ifNoError") ? CompileStates.CompileState.valueOf(this.options.get("should-stop.ifNoError")) : CompileStates.CompileState.GENERATE;
        if (this.options.isUnset("diags.legacy")) {
            this.log.setDiagnosticFormatter(RichDiagnosticFormatter.instance(context));
        }
        if ((platformDescription = context.get(PlatformDescription.class)) != null) {
            this.closeables = this.closeables.prepend(platformDescription);
        }
        this.silentFail = new Symbol(Kinds.Kind.ABSENT_TYP, 0L, this.names.empty, Type.noType, this.syms.rootPackage){

            @Override
            public <R, P> R accept(ElementVisitor<R, P> elementVisitor, P p) {
                return elementVisitor.visitUnknown(this, p);
            }

            @Override
            public boolean exists() {
                return false;
            }
        };
    }

    protected boolean shouldStop(CompileStates.CompileState compileState) {
        CompileStates.CompileState compileState2 = this.errorCount() > 0 || this.unrecoverableError() ? this.shouldStopPolicyIfError : this.shouldStopPolicyIfNoError;
        return compileState.isAfter(compileState2);
    }

    public int errorCount() {
        if (this.werror && this.log.nerrors == 0 && this.log.nwarnings > 0) {
            this.log.error("warnings.and.werror", new Object[0]);
        }
        return this.log.nerrors;
    }

    protected final <T> Queue<T> stopIfError(CompileStates.CompileState compileState, Queue<T> listBuffer) {
        return this.shouldStop(compileState) ? new ListBuffer() : listBuffer;
    }

    protected final <T> List<T> stopIfError(CompileStates.CompileState compileState, List<T> list) {
        return this.shouldStop(compileState) ? List.nil() : list;
    }

    public int warningCount() {
        return this.log.nwarnings;
    }

    public CharSequence readSource(JavaFileObject javaFileObject) {
        try {
            this.inputFiles.add(javaFileObject);
            return javaFileObject.getCharContent(false);
        }
        catch (IOException iOException) {
            this.log.error("error.reading.file", javaFileObject, JavacFileManager.getMessage(iOException));
            return null;
        }
    }

    protected JCTree.JCCompilationUnit parse(JavaFileObject javaFileObject, CharSequence charSequence) {
        Object object;
        long l = JavaCompiler.now();
        JCTree.JCCompilationUnit jCCompilationUnit = this.make.TopLevel(List.nil());
        if (charSequence != null) {
            if (this.verbose) {
                this.log.printVerbose("parsing.started", javaFileObject);
            }
            if (!this.taskListener.isEmpty()) {
                object = new TaskEvent(TaskEvent.Kind.PARSE, javaFileObject);
                this.taskListener.started((TaskEvent)object);
                this.keepComments = true;
                this.genEndPos = true;
            }
            object = this.parserFactory.newParser(charSequence, this.keepComments(), this.genEndPos, this.lineDebugInfo, javaFileObject.isNameCompatible("module-info", JavaFileObject.Kind.SOURCE));
            jCCompilationUnit = object.parseCompilationUnit();
            if (this.verbose) {
                this.log.printVerbose("parsing.done", Long.toString(JavaCompiler.elapsed(l)));
            }
        }
        jCCompilationUnit.sourcefile = javaFileObject;
        if (charSequence != null && !this.taskListener.isEmpty()) {
            object = new TaskEvent(TaskEvent.Kind.PARSE, jCCompilationUnit);
            this.taskListener.finished((TaskEvent)object);
        }
        return jCCompilationUnit;
    }

    protected boolean keepComments() {
        return this.keepComments || this.sourceOutput;
    }

    @Deprecated
    public JCTree.JCCompilationUnit parse(String string) {
        JavacFileManager javacFileManager = (JavacFileManager)this.fileManager;
        return this.parse(javacFileManager.getJavaFileObjectsFromStrings(List.of(string)).iterator().next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCTree.JCCompilationUnit parse(JavaFileObject javaFileObject) {
        JavaFileObject javaFileObject2 = this.log.useSource(javaFileObject);
        try {
            JCTree.JCCompilationUnit jCCompilationUnit = this.parse(javaFileObject, this.readSource(javaFileObject));
            if (jCCompilationUnit.endPositions != null) {
                this.log.setEndPosTable(javaFileObject, jCCompilationUnit.endPositions);
            }
            JCTree.JCCompilationUnit jCCompilationUnit2 = jCCompilationUnit;
            return jCCompilationUnit2;
        }
        finally {
            this.log.useSource(javaFileObject2);
        }
    }

    public Symbol resolveBinaryNameOrIdent(String string) {
        String string2;
        Symbol.ModuleSymbol moduleSymbol;
        int n = string.indexOf(47);
        if (n == -1) {
            moduleSymbol = this.modules.getDefaultModule();
            string2 = string;
        } else if (this.source.allowModules()) {
            Name name = this.names.fromString(string.substring(0, n));
            moduleSymbol = this.moduleFinder.findModule(name);
            string2 = string.substring(n + 1);
        } else {
            this.log.error(CompilerProperties.Errors.InvalidModuleSpecifier(string));
            return this.silentFail;
        }
        return this.resolveBinaryNameOrIdent(moduleSymbol, string2);
    }

    public Symbol resolveBinaryNameOrIdent(Symbol.ModuleSymbol moduleSymbol, String string) {
        try {
            Name name = this.names.fromString(string.replace("/", "."));
            return this.finder.loadClass(moduleSymbol, name);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            return this.resolveIdent(moduleSymbol, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol resolveIdent(Symbol.ModuleSymbol moduleSymbol, String string) {
        if (string.equals("")) {
            return this.syms.errSymbol;
        }
        JavaFileObject javaFileObject = this.log.useSource(null);
        try {
            JCTree.JCExpression jCExpression = null;
            for (String string2 : string.split("\\.", -1)) {
                if (!SourceVersion.isIdentifier(string2)) {
                    Symbol.ClassSymbol classSymbol = this.syms.errSymbol;
                    return classSymbol;
                }
                jCExpression = jCExpression == null ? this.make.Ident(this.names.fromString(string2)) : this.make.Select(jCExpression, this.names.fromString(string2));
            }
            JCTree.JCCompilationUnit jCCompilationUnit = this.make.TopLevel(List.nil());
            jCCompilationUnit.modle = moduleSymbol;
            jCCompilationUnit.packge = moduleSymbol.unnamedPackage;
            Symbol symbol = this.attr.attribIdent(jCExpression, jCCompilationUnit);
            return symbol;
        }
        finally {
            this.log.useSource(javaFileObject);
        }
    }

    JavaFileObject genCode(Env<AttrContext> env, JCTree.JCClassDecl jCClassDecl) throws IOException {
        try {
            if (this.gen.genClass(env, jCClassDecl) && this.errorCount() == 0) {
                return this.writer.writeClass(jCClassDecl.sym);
            }
        }
        catch (ClassWriter.PoolOverflow poolOverflow) {
            this.log.error(jCClassDecl.pos(), "limit.pool", new Object[0]);
        }
        catch (ClassWriter.StringOverflow stringOverflow) {
            this.log.error(jCClassDecl.pos(), "limit.string.overflow", stringOverflow.value.substring(0, 20));
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.chk.completionError(jCClassDecl.pos(), completionFailure);
        }
        return null;
    }

    JavaFileObject printSource(Env<AttrContext> env, JCTree.JCClassDecl jCClassDecl) throws IOException {
        JavaFileObject javaFileObject = this.fileManager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, jCClassDecl.sym.flatname.toString(), JavaFileObject.Kind.SOURCE, null);
        if (this.inputFiles.contains(javaFileObject)) {
            this.log.error(jCClassDecl.pos(), "source.cant.overwrite.input.file", javaFileObject);
            return null;
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(javaFileObject.openWriter());){
            new Pretty(bufferedWriter, true).printUnit(env.toplevel, jCClassDecl);
            if (this.verbose) {
                this.log.printVerbose("wrote.file", javaFileObject);
            }
        }
        return javaFileObject;
    }

    private void readSourceFile(Symbol.ClassSymbol classSymbol) throws Symbol.CompletionFailure {
        this.readSourceFile(null, classSymbol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSourceFile(JCTree.JCCompilationUnit jCCompilationUnit, Symbol.ClassSymbol classSymbol) throws Symbol.CompletionFailure {
        TaskEvent taskEvent;
        if (this.completionFailureName == classSymbol.fullname) {
            throw new Symbol.CompletionFailure((Symbol)classSymbol, "user-selected completion failure by class name");
        }
        JavaFileObject javaFileObject = classSymbol.classfile;
        JavaFileObject javaFileObject2 = this.log.useSource(javaFileObject);
        if (jCCompilationUnit == null) {
            try {
                jCCompilationUnit = this.parse(javaFileObject, javaFileObject.getCharContent(false));
            }
            catch (IOException iOException) {
                this.log.error("error.reading.file", javaFileObject, JavacFileManager.getMessage(iOException));
                jCCompilationUnit = this.make.TopLevel(List.nil());
            }
            finally {
                this.log.useSource(javaFileObject2);
            }
        }
        if (!this.taskListener.isEmpty()) {
            taskEvent = new TaskEvent(TaskEvent.Kind.ENTER, jCCompilationUnit);
            this.taskListener.started(taskEvent);
        }
        if (!this.modules.enter(List.of(jCCompilationUnit), classSymbol)) {
            throw new Symbol.CompletionFailure((Symbol)classSymbol, this.diags.fragment("cant.resolve.modules", new Object[0]));
        }
        this.enter.complete(List.of(jCCompilationUnit), classSymbol);
        if (!this.taskListener.isEmpty()) {
            taskEvent = new TaskEvent(TaskEvent.Kind.ENTER, jCCompilationUnit);
            this.taskListener.finished(taskEvent);
        }
        if (this.enter.getEnv(classSymbol) == null) {
            boolean bl = jCCompilationUnit.sourcefile.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE);
            boolean bl2 = jCCompilationUnit.sourcefile.isNameCompatible("module-info", JavaFileObject.Kind.SOURCE);
            if (bl2) {
                if (this.enter.getEnv(jCCompilationUnit.modle) == null) {
                    JCDiagnostic jCDiagnostic = this.diagFactory.fragment("file.does.not.contain.module", new Object[0]);
                    throw new ClassFinder.BadClassFile(classSymbol, javaFileObject, jCDiagnostic, this.diagFactory);
                }
            } else if (bl) {
                if (this.enter.getEnv(jCCompilationUnit.packge) == null) {
                    JCDiagnostic jCDiagnostic = this.diagFactory.fragment("file.does.not.contain.package", classSymbol.location());
                    throw new ClassFinder.BadClassFile(classSymbol, javaFileObject, jCDiagnostic, this.diagFactory);
                }
            } else {
                JCDiagnostic jCDiagnostic = this.diagFactory.fragment("file.doesnt.contain.class", classSymbol.getQualifiedName());
                throw new ClassFinder.BadClassFile(classSymbol, javaFileObject, jCDiagnostic, this.diagFactory);
            }
        }
        this.implicitSourceFilesRead = true;
    }

    public void compile(List<JavaFileObject> list) throws Throwable {
        this.compile(list, List.nil(), null, List.nil());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(Collection<JavaFileObject> collection, Collection<String> collection2, Iterable<? extends Processor> iterable, Collection<String> collection3) {
        block30: {
            if (!this.taskListener.isEmpty()) {
                this.taskListener.started(new TaskEvent(TaskEvent.Kind.COMPILATION));
            }
            if (iterable != null && iterable.iterator().hasNext()) {
                this.explicitAnnotationProcessingRequested = true;
            }
            if (this.hasBeenUsed) {
                this.checkReusable();
            }
            this.hasBeenUsed = true;
            this.options.put(Option.XLINT_CUSTOM.primaryName + "-" + Lint.LintCategory.OPTIONS.option, "true");
            this.options.remove(Option.XLINT_CUSTOM.primaryName + Lint.LintCategory.OPTIONS.option);
            this.start_msec = JavaCompiler.now();
            try {
                this.initProcessAnnotations(iterable, collection, collection2);
                for (String string : collection2) {
                    int n = string.indexOf(47);
                    if (n == -1) continue;
                    this.modules.addExtraAddModules(string.substring(0, n));
                }
                for (String string : collection3) {
                    this.modules.addExtraAddModules(string);
                }
                this.processAnnotations(this.enterTrees(this.stopIfError(CompileStates.CompileState.PARSE, this.initModules(this.stopIfError(CompileStates.CompileState.PARSE, this.parseFiles(collection))))), collection2);
                if (this.taskListener.isEmpty() && this.implicitSourcePolicy == ImplicitSourcePolicy.NONE) {
                    this.todo.retainFiles(this.inputFiles);
                }
                switch (this.compilePolicy) {
                    case ATTR_ONLY: {
                        this.attribute(this.todo);
                        break;
                    }
                    case CHECK_ONLY: {
                        this.flow(this.attribute(this.todo));
                        break;
                    }
                    case SIMPLE: {
                        this.generate(this.desugar(this.flow(this.attribute(this.todo))));
                        break;
                    }
                    case BY_FILE: {
                        Queue<Queue<Env<AttrContext>>> queue = this.todo.groupByFile();
                        while (!queue.isEmpty() && !this.shouldStop(CompileStates.CompileState.ATTR)) {
                            this.generate(this.desugar(this.flow(this.attribute((Queue)queue.remove()))));
                        }
                        break;
                    }
                    case BY_TODO: {
                        while (!this.todo.isEmpty()) {
                            this.generate(this.desugar(this.flow(this.attribute((Env)this.todo.remove()))));
                        }
                        break;
                    }
                    default: {
                        Assert.error("unknown compile policy");
                    }
                }
                if (!this.verbose) break block30;
            }
            catch (Abort abort) {
                block31: {
                    try {
                        if (this.devVerbose) {
                            abort.printStackTrace(System.err);
                        }
                        if (!this.verbose) break block31;
                    }
                    catch (Throwable throwable) {
                        if (this.verbose) {
                            this.elapsed_msec = JavaCompiler.elapsed(this.start_msec);
                            this.log.printVerbose("total", Long.toString(this.elapsed_msec));
                        }
                        this.reportDeferredDiagnostics();
                        if (!this.log.hasDiagnosticListener()) {
                            this.printCount("error", this.errorCount());
                            this.printCount("warn", this.warningCount());
                        }
                        if (!this.taskListener.isEmpty()) {
                            this.taskListener.finished(new TaskEvent(TaskEvent.Kind.COMPILATION));
                        }
                        this.close();
                        if (this.procEnvImpl != null) {
                            this.procEnvImpl.close();
                        }
                        throw throwable;
                    }
                    this.elapsed_msec = JavaCompiler.elapsed(this.start_msec);
                    this.log.printVerbose("total", Long.toString(this.elapsed_msec));
                }
                this.reportDeferredDiagnostics();
                if (!this.log.hasDiagnosticListener()) {
                    this.printCount("error", this.errorCount());
                    this.printCount("warn", this.warningCount());
                }
                if (!this.taskListener.isEmpty()) {
                    this.taskListener.finished(new TaskEvent(TaskEvent.Kind.COMPILATION));
                }
                this.close();
                if (this.procEnvImpl != null) {
                    this.procEnvImpl.close();
                }
            }
            this.elapsed_msec = JavaCompiler.elapsed(this.start_msec);
            this.log.printVerbose("total", Long.toString(this.elapsed_msec));
        }
        this.reportDeferredDiagnostics();
        if (!this.log.hasDiagnosticListener()) {
            this.printCount("error", this.errorCount());
            this.printCount("warn", this.warningCount());
        }
        if (!this.taskListener.isEmpty()) {
            this.taskListener.finished(new TaskEvent(TaskEvent.Kind.COMPILATION));
        }
        this.close();
        if (this.procEnvImpl != null) {
            this.procEnvImpl.close();
        }
    }

    protected void checkReusable() {
        throw new AssertionError((Object)"attempt to reuse JavaCompiler");
    }

    public List<JCTree.JCCompilationUnit> parseFiles(Iterable<JavaFileObject> iterable) {
        if (this.shouldStop(CompileStates.CompileState.PARSE)) {
            return List.nil();
        }
        ListBuffer<JCTree.JCCompilationUnit> listBuffer = new ListBuffer<JCTree.JCCompilationUnit>();
        HashSet<JavaFileObject> hashSet = new HashSet<JavaFileObject>();
        for (JavaFileObject javaFileObject : iterable) {
            if (hashSet.contains(javaFileObject)) continue;
            hashSet.add(javaFileObject);
            listBuffer.append(this.parse(javaFileObject));
        }
        return listBuffer.toList();
    }

    public List<JCTree.JCCompilationUnit> enterTreesIfNeeded(List<JCTree.JCCompilationUnit> list) {
        if (this.shouldStop(CompileStates.CompileState.ATTR)) {
            return List.nil();
        }
        return this.enterTrees(this.initModules(list));
    }

    public List<JCTree.JCCompilationUnit> initModules(List<JCTree.JCCompilationUnit> list) {
        this.modules.initModules(list);
        if (list.isEmpty()) {
            this.enterDone();
        }
        return list;
    }

    public List<JCTree.JCCompilationUnit> enterTrees(List<JCTree.JCCompilationUnit> list) {
        if (!this.taskListener.isEmpty()) {
            for (JCTree.JCCompilationUnit object2 : list) {
                TaskEvent taskEvent = new TaskEvent(TaskEvent.Kind.ENTER, object2);
                this.taskListener.started(taskEvent);
            }
        }
        this.enter.main(list);
        this.enterDone();
        if (!this.taskListener.isEmpty()) {
            for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
                TaskEvent taskEvent = new TaskEvent(TaskEvent.Kind.ENTER, jCCompilationUnit);
                this.taskListener.finished(taskEvent);
            }
        }
        if (this.sourceOutput) {
            ListBuffer listBuffer = new ListBuffer();
            for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
                List<JCTree> list2 = jCCompilationUnit.defs;
                while (list2.nonEmpty()) {
                    if (list2.head instanceof JCTree.JCClassDecl) {
                        listBuffer.append((JCTree.JCClassDecl)list2.head);
                    }
                    list2 = list2.tail;
                }
            }
            this.rootClasses = listBuffer.toList();
        }
        for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
            this.inputFiles.add(jCCompilationUnit.sourcefile);
        }
        return list;
    }

    public void initProcessAnnotations(Iterable<? extends Processor> iterable, Collection<? extends JavaFileObject> collection, Collection<String> collection2) {
        if (this.options.isSet(Option.PROC, "none")) {
            this.processAnnotations = false;
        } else if (this.procEnvImpl == null) {
            this.procEnvImpl = JavacProcessingEnvironment.instance(this.context);
            this.procEnvImpl.setProcessors(iterable);
            this.processAnnotations = this.procEnvImpl.atLeastOneProcessor();
            if (this.processAnnotations) {
                this.options.put("parameters", "parameters");
                this.reader.saveParameterNames = true;
                this.keepComments = true;
                this.genEndPos = true;
                if (!this.taskListener.isEmpty()) {
                    this.taskListener.started(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING));
                }
                this.deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(this.log);
                this.procEnvImpl.getFiler().setInitialState(collection, collection2);
            } else {
                this.procEnvImpl.close();
            }
        }
    }

    public void processAnnotations(List<JCTree.JCCompilationUnit> list) {
        this.processAnnotations(list, List.nil());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAnnotations(List<JCTree.JCCompilationUnit> list, Collection<String> collection) {
        block20: {
            if (this.shouldStop(CompileStates.CompileState.PROCESS) && this.unrecoverableError()) {
                this.deferredDiagnosticHandler.reportDeferredDiagnostics();
                this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
                return;
            }
            if (!this.processAnnotations) {
                if (this.options.isSet(Option.PROC, "only")) {
                    this.log.warning("proc.proc-only.requested.no.procs", new Object[0]);
                    this.todo.clear();
                }
                if (!collection.isEmpty()) {
                    this.log.error("proc.no.explicit.annotation.processing.requested", collection);
                }
                Assert.checkNull(this.deferredDiagnosticHandler);
                return;
            }
            Assert.checkNonNull(this.deferredDiagnosticHandler);
            try {
                List<Symbol.ClassSymbol> list2 = List.nil();
                List<Object> list3 = List.nil();
                if (!collection.isEmpty()) {
                    if (!this.explicitAnnotationProcessingRequested()) {
                        this.log.error("proc.no.explicit.annotation.processing.requested", collection);
                        this.deferredDiagnosticHandler.reportDeferredDiagnostics();
                        this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
                        return;
                    }
                    boolean bl = false;
                    for (String string : collection) {
                        Symbol symbol = this.resolveBinaryNameOrIdent(string);
                        if (symbol == null || symbol.kind == Kinds.Kind.PCK && !this.processPcks || symbol.kind == Kinds.Kind.ABSENT_TYP) {
                            if (symbol != this.silentFail) {
                                this.log.error(CompilerProperties.Errors.ProcCantFindClass(string));
                            }
                            bl = true;
                            continue;
                        }
                        try {
                            if (symbol.kind == Kinds.Kind.PCK) {
                                symbol.complete();
                            }
                            if (symbol.exists()) {
                                if (symbol.kind == Kinds.Kind.PCK) {
                                    list3 = list3.prepend((Symbol.PackageSymbol)symbol);
                                    continue;
                                }
                                list2 = list2.prepend((Symbol.ClassSymbol)symbol);
                                continue;
                            }
                            Assert.check(symbol.kind == Kinds.Kind.PCK);
                            this.log.warning(CompilerProperties.Warnings.ProcPackageDoesNotExist(string));
                            list3 = list3.prepend((Symbol.PackageSymbol)symbol);
                        }
                        catch (Symbol.CompletionFailure completionFailure) {
                            this.log.error(CompilerProperties.Errors.ProcCantFindClass(string));
                            bl = true;
                        }
                    }
                    if (bl) {
                        this.deferredDiagnosticHandler.reportDeferredDiagnostics();
                        this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
                        return;
                    }
                }
                try {
                    this.annotationProcessingOccurred = this.procEnvImpl.doProcessing(list, list2, list3, this.deferredDiagnosticHandler);
                }
                finally {
                    this.procEnvImpl.close();
                }
            }
            catch (Symbol.CompletionFailure completionFailure) {
                this.log.error("cant.access", completionFailure.sym, completionFailure.getDetailValue());
                if (this.deferredDiagnosticHandler == null) break block20;
                this.deferredDiagnosticHandler.reportDeferredDiagnostics();
                this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
            }
        }
    }

    private boolean unrecoverableError() {
        if (this.deferredDiagnosticHandler != null) {
            for (JCDiagnostic jCDiagnostic : this.deferredDiagnosticHandler.getDiagnostics()) {
                if (jCDiagnostic.getKind() != Diagnostic.Kind.ERROR || jCDiagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.RECOVERABLE)) continue;
                return true;
            }
        }
        return false;
    }

    boolean explicitAnnotationProcessingRequested() {
        return this.explicitAnnotationProcessingRequested || JavaCompiler.explicitAnnotationProcessingRequested(this.options);
    }

    static boolean explicitAnnotationProcessingRequested(Options options) {
        return options.isSet(Option.PROCESSOR) || options.isSet(Option.PROCESSOR_PATH) || options.isSet(Option.PROCESSOR_MODULE_PATH) || options.isSet(Option.PROC, "only") || options.isSet(Option.XPRINT);
    }

    public void setDeferredDiagnosticHandler(Log.DeferredDiagnosticHandler deferredDiagnosticHandler) {
        this.deferredDiagnosticHandler = deferredDiagnosticHandler;
    }

    public Queue<Env<AttrContext>> attribute(Queue<Env<AttrContext>> queue) {
        ListBuffer<Env<AttrContext>> listBuffer = new ListBuffer<Env<AttrContext>>();
        while (!queue.isEmpty()) {
            listBuffer.append(this.attribute(queue.remove()));
        }
        return this.stopIfError(CompileStates.CompileState.ATTR, listBuffer);
    }

    public Env<AttrContext> attribute(Env<AttrContext> env) {
        Object object;
        if (this.compileStates.isDone(env, CompileStates.CompileState.ATTR)) {
            return env;
        }
        if (this.verboseCompilePolicy) {
            this.printNote("[attribute " + env.enclClass.sym + "]");
        }
        if (this.verbose) {
            this.log.printVerbose("checking.attribution", env.enclClass.sym);
        }
        if (!this.taskListener.isEmpty()) {
            object = new TaskEvent(TaskEvent.Kind.ANALYZE, env.toplevel, env.enclClass.sym);
            this.taskListener.started((TaskEvent)object);
        }
        object = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
        try {
            this.attr.attrib(env);
            if (this.errorCount() > 0 && !this.shouldStop(CompileStates.CompileState.ATTR)) {
                this.attr.postAttr(env.tree);
            }
            this.compileStates.put(env, CompileStates.CompileState.ATTR);
        }
        finally {
            this.log.useSource((JavaFileObject)object);
        }
        return env;
    }

    public Queue<Env<AttrContext>> flow(Queue<Env<AttrContext>> queue) {
        ListBuffer<Env<AttrContext>> listBuffer = new ListBuffer<Env<AttrContext>>();
        for (Env env : queue) {
            this.flow(env, listBuffer);
        }
        return this.stopIfError(CompileStates.CompileState.FLOW, listBuffer);
    }

    public Queue<Env<AttrContext>> flow(Env<AttrContext> env) {
        ListBuffer<Env<AttrContext>> listBuffer = new ListBuffer<Env<AttrContext>>();
        this.flow(env, listBuffer);
        return this.stopIfError(CompileStates.CompileState.FLOW, listBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flow(Env<AttrContext> env, Queue<Env<AttrContext>> queue) {
        if (this.compileStates.isDone(env, CompileStates.CompileState.FLOW)) {
            queue.add(env);
            return;
        }
        try {
            if (this.shouldStop(CompileStates.CompileState.FLOW)) {
                return;
            }
            if (this.verboseCompilePolicy) {
                this.printNote("[flow " + env.enclClass.sym + "]");
            }
            JavaFileObject javaFileObject = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
            try {
                this.make.at(0);
                TreeMaker treeMaker = this.make.forToplevel(env.toplevel);
                this.flow.analyzeTree(env, treeMaker);
                this.compileStates.put(env, CompileStates.CompileState.FLOW);
                if (this.shouldStop(CompileStates.CompileState.FLOW)) {
                    return;
                }
                queue.add(env);
            }
            finally {
                this.log.useSource(javaFileObject);
            }
        }
        finally {
            if (!this.taskListener.isEmpty()) {
                TaskEvent taskEvent = new TaskEvent(TaskEvent.Kind.ANALYZE, env.toplevel, env.enclClass.sym);
                this.taskListener.finished(taskEvent);
            }
        }
    }

    public Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> desugar(Queue<Env<AttrContext>> queue) {
        ListBuffer<Pair<Env<AttrContext>, JCTree.JCClassDecl>> listBuffer = new ListBuffer<Pair<Env<AttrContext>, JCTree.JCClassDecl>>();
        for (Env env : queue) {
            this.desugar(env, listBuffer);
        }
        return this.stopIfError(CompileStates.CompileState.FLOW, listBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void desugar(final Env<AttrContext> env, Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> queue) {
        if (this.shouldStop(CompileStates.CompileState.TRANSTYPES)) {
            return;
        }
        if (this.implicitSourcePolicy == ImplicitSourcePolicy.NONE && !this.inputFiles.contains(env.toplevel.sourcefile)) {
            return;
        }
        if (!this.modules.multiModuleMode && env.toplevel.modle != this.modules.getDefaultModule()) {
            return;
        }
        if (this.compileStates.isDone(env, CompileStates.CompileState.LOWER)) {
            queue.addAll((Collection<Pair<Env<AttrContext>, JCTree.JCClassDecl>>)this.desugaredEnvs.get(env));
            return;
        }
        class ScanNested
        extends TreeScanner {
            Set<Env<AttrContext>> dependencies = new LinkedHashSet<Env<AttrContext>>();
            protected boolean hasLambdas;

            ScanNested() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
                Type type = JavaCompiler.this.types.supertype(jCClassDecl.sym.type);
                boolean bl = false;
                while (!bl && type.hasTag(TypeTag.CLASS)) {
                    Symbol.ClassSymbol classSymbol = type.tsym.outermostClass();
                    Env<AttrContext> env2 = JavaCompiler.this.enter.getEnv(classSymbol);
                    if (env2 != null && env != env2) {
                        if (this.dependencies.add(env2)) {
                            boolean bl2 = this.hasLambdas;
                            try {
                                this.scan(env2.tree);
                            }
                            finally {
                                this.hasLambdas = bl2;
                            }
                        }
                        bl = true;
                    }
                    type = JavaCompiler.this.types.supertype(type);
                }
                super.visitClassDef(jCClassDecl);
            }

            @Override
            public void visitLambda(JCTree.JCLambda jCLambda) {
                this.hasLambdas = true;
                super.visitLambda(jCLambda);
            }

            @Override
            public void visitReference(JCTree.JCMemberReference jCMemberReference) {
                this.hasLambdas = true;
                super.visitReference(jCMemberReference);
            }
        }
        ScanNested scanNested = new ScanNested();
        scanNested.scan(env.tree);
        if (this.compilePolicy == CompilePolicy.BY_FILE) {
            this.desugarByFile(scanNested.dependencies);
        } else {
            for (Env<AttrContext> env2 : scanNested.dependencies) {
                if (this.compileStates.isDone(env2, CompileStates.CompileState.FLOW)) continue;
                this.desugaredEnvs.put(env2, this.desugar(this.flow(this.attribute(env2))));
            }
        }
        if (this.shouldStop(CompileStates.CompileState.TRANSTYPES)) {
            return;
        }
        if (this.verboseCompilePolicy) {
            this.printNote("[desugar " + env.enclClass.sym + "]");
        }
        JavaFileObject javaFileObject = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
        try {
            Env<AttrContext> env2;
            env2 = env.tree;
            this.make.at(0);
            TreeMaker treeMaker = this.make.forToplevel(env.toplevel);
            if (env.tree.hasTag(JCTree.Tag.PACKAGEDEF) || env.tree.hasTag(JCTree.Tag.MODULEDEF)) {
                if (!this.sourceOutput) {
                    if (this.shouldStop(CompileStates.CompileState.LOWER)) {
                        return;
                    }
                    List<JCTree> list = this.lower.translateTopLevelClass(env, env.tree, treeMaker);
                    if (list.head != null) {
                        Assert.check(list.tail.isEmpty());
                        queue.add(new Pair<Env<AttrContext>, JCTree.JCClassDecl>(env, (JCTree.JCClassDecl)list.head));
                    }
                }
                return;
            }
            if (this.shouldStop(CompileStates.CompileState.TRANSTYPES)) {
                return;
            }
            env.tree = this.transTypes.translateTopLevelClass(env.tree, treeMaker);
            this.compileStates.put(env, CompileStates.CompileState.TRANSTYPES);
            if (this.source.allowLambda() && scanNested.hasLambdas) {
                if (this.shouldStop(CompileStates.CompileState.UNLAMBDA)) {
                    return;
                }
                env.tree = LambdaToMethod.instance(this.context).translateTopLevelClass(env, env.tree, treeMaker);
                this.compileStates.put(env, CompileStates.CompileState.UNLAMBDA);
            }
            if (this.shouldStop(CompileStates.CompileState.LOWER)) {
                return;
            }
            if (this.sourceOutput) {
                JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)env.tree;
                if (env2 instanceof JCTree.JCClassDecl && this.rootClasses.contains((JCTree.JCClassDecl)((Object)env2))) {
                    queue.add(new Pair<Env<AttrContext>, JCTree.JCClassDecl>(env, jCClassDecl));
                }
                return;
            }
            List<JCTree> list = this.lower.translateTopLevelClass(env, env.tree, treeMaker);
            this.compileStates.put(env, CompileStates.CompileState.LOWER);
            if (this.shouldStop(CompileStates.CompileState.LOWER)) {
                return;
            }
            List<JCTree> list2 = list;
            while (list2.nonEmpty()) {
                JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)list2.head;
                queue.add(new Pair<Env<AttrContext>, JCTree.JCClassDecl>(env, jCClassDecl));
                list2 = list2.tail;
            }
        }
        finally {
            this.log.useSource(javaFileObject);
        }
    }

    private void desugarByFile(Iterable<Env<AttrContext>> iterable) {
        HashSet<JCTree.JCCompilationUnit> hashSet = new HashSet<JCTree.JCCompilationUnit>();
        for (Env<AttrContext> env : iterable) {
            if (this.compileStates.isDone(env, CompileStates.CompileState.FLOW)) continue;
            if (hashSet.add(env.toplevel)) {
                this.flow(this.attribute(this.todo.groupByFile(env)));
            }
            this.desugaredEnvs.put(env, this.desugar(ListBuffer.of(env)));
        }
    }

    public void generate(Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> queue) {
        this.generate(queue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> queue, Queue<JavaFileObject> queue2) {
        if (this.shouldStop(CompileStates.CompileState.GENERATE)) {
            return;
        }
        for (Pair pair : queue) {
            Object object;
            Object object2;
            Env env = (Env)pair.fst;
            JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)pair.snd;
            if (this.verboseCompilePolicy) {
                this.printNote("[generate " + (this.sourceOutput ? " source" : "code") + " " + jCClassDecl.sym + "]");
            }
            if (!this.taskListener.isEmpty()) {
                object2 = new TaskEvent(TaskEvent.Kind.GENERATE, env.toplevel, jCClassDecl.sym);
                this.taskListener.started((TaskEvent)object2);
            }
            object2 = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
            try {
                if (this.sourceOutput) {
                    object = this.printSource(env, jCClassDecl);
                } else {
                    if (this.fileManager.hasLocation(StandardLocation.NATIVE_HEADER_OUTPUT) && this.jniWriter.needsHeader(jCClassDecl.sym)) {
                        this.jniWriter.write(jCClassDecl.sym);
                    }
                    object = this.genCode(env, jCClassDecl);
                }
                if (queue2 != null && object != null) {
                    queue2.add((JavaFileObject)object);
                }
            }
            catch (IOException iOException) {
                this.log.error(jCClassDecl.pos(), "class.cant.write", jCClassDecl.sym, iOException.getMessage());
                return;
            }
            finally {
                this.log.useSource((JavaFileObject)object2);
            }
            if (this.taskListener.isEmpty()) continue;
            object = new TaskEvent(TaskEvent.Kind.GENERATE, env.toplevel, jCClassDecl.sym);
            this.taskListener.finished((TaskEvent)object);
        }
    }

    JCTree.JCClassDecl removeMethodBodies(JCTree.JCClassDecl jCClassDecl) {
        final boolean bl = (jCClassDecl.mods.flags & 0x200L) != 0L;
        class MethodBodyRemover
        extends TreeTranslator {
            MethodBodyRemover() {
            }

            @Override
            public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
                jCMethodDecl.mods.flags &= 0xFFFFFFFFFFFFFFDFL;
                for (JCTree.JCVariableDecl jCVariableDecl : jCMethodDecl.params) {
                    jCVariableDecl.mods.flags &= 0xFFFFFFFFFFFFFFEFL;
                }
                jCMethodDecl.body = null;
                super.visitMethodDef(jCMethodDecl);
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
                if (jCVariableDecl.init != null && jCVariableDecl.init.type.constValue() == null) {
                    jCVariableDecl.init = null;
                }
                super.visitVarDef(jCVariableDecl);
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
                ListBuffer<JCTree> listBuffer = new ListBuffer<JCTree>();
                List<JCTree> list = jCClassDecl.defs;
                while (list.tail != null) {
                    JCTree jCTree = (JCTree)list.head;
                    switch (jCTree.getTag()) {
                        case CLASSDEF: {
                            if (!bl && (((JCTree.JCClassDecl)jCTree).mods.flags & 5L) == 0L && ((((JCTree.JCClassDecl)jCTree).mods.flags & 2L) != 0L || ((JCTree.JCClassDecl)jCTree).sym.packge().getQualifiedName() != JavaCompiler.this.names.java_lang)) break;
                            listBuffer.append(jCTree);
                            break;
                        }
                        case METHODDEF: {
                            if (!bl && (((JCTree.JCMethodDecl)jCTree).mods.flags & 5L) == 0L && ((JCTree.JCMethodDecl)jCTree).sym.name != JavaCompiler.this.names.init && ((((JCTree.JCMethodDecl)jCTree).mods.flags & 2L) != 0L || ((JCTree.JCMethodDecl)jCTree).sym.packge().getQualifiedName() != JavaCompiler.this.names.java_lang)) break;
                            listBuffer.append(jCTree);
                            break;
                        }
                        case VARDEF: {
                            if (!bl && (((JCTree.JCVariableDecl)jCTree).mods.flags & 5L) == 0L && ((((JCTree.JCVariableDecl)jCTree).mods.flags & 2L) != 0L || ((JCTree.JCVariableDecl)jCTree).sym.packge().getQualifiedName() != JavaCompiler.this.names.java_lang)) break;
                            listBuffer.append(jCTree);
                            break;
                        }
                    }
                    list = list.tail;
                }
                jCClassDecl.defs = listBuffer.toList();
                super.visitClassDef(jCClassDecl);
            }
        }
        MethodBodyRemover methodBodyRemover = new MethodBodyRemover();
        return methodBodyRemover.translate(jCClassDecl);
    }

    public void reportDeferredDiagnostics() {
        if (this.errorCount() == 0 && this.annotationProcessingOccurred && this.implicitSourceFilesRead && this.implicitSourcePolicy == ImplicitSourcePolicy.UNSET) {
            if (this.explicitAnnotationProcessingRequested()) {
                this.log.warning("proc.use.implicit", new Object[0]);
            } else {
                this.log.warning("proc.use.proc.or.implicit", new Object[0]);
            }
        }
        this.chk.reportDeferredDiagnostics();
        if (this.log.compressedOutput) {
            this.log.mandatoryNote(null, "compressed.diags", new Object[0]);
        }
    }

    public void enterDone() {
        this.enterDone = true;
        this.annotate.enterDone();
    }

    public boolean isEnterDone() {
        return this.enterDone;
    }

    private Name readModuleName(JavaFileObject javaFileObject) {
        return this.parseAndGetName(javaFileObject, jCCompilationUnit -> {
            JCTree.JCModuleDecl jCModuleDecl = jCCompilationUnit.getModuleDecl();
            return jCModuleDecl != null ? TreeInfo.fullName(jCModuleDecl.getName()) : null;
        });
    }

    private Name findPackageInFile(JavaFileObject javaFileObject) {
        return this.parseAndGetName(javaFileObject, jCCompilationUnit -> jCCompilationUnit.getPackage() != null ? TreeInfo.fullName(jCCompilationUnit.getPackage().getPackageName()) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Name parseAndGetName(JavaFileObject javaFileObject, Function<JCTree.JCCompilationUnit, Name> function) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            JCTree.JCCompilationUnit jCCompilationUnit = this.parse(javaFileObject, javaFileObject.getCharContent(false));
            Name name = function.apply(jCCompilationUnit);
            return name;
        }
        catch (IOException iOException) {
            Name name = null;
            return name;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    public void close() {
        this.rootClasses = null;
        this.finder = null;
        this.reader = null;
        this.make = null;
        this.writer = null;
        this.enter = null;
        if (this.todo != null) {
            this.todo.clear();
        }
        this.todo = null;
        this.parserFactory = null;
        this.syms = null;
        this.source = null;
        this.attr = null;
        this.chk = null;
        this.gen = null;
        this.flow = null;
        this.transTypes = null;
        this.lower = null;
        this.annotate = null;
        this.types = null;
        this.log.flush();
        try {
            this.fileManager.flush();
        }
        catch (IOException iOException) {
            throw new Abort(iOException);
        }
        finally {
            if (this.names != null) {
                this.names.dispose();
            }
            this.names = null;
            for (Closeable closeable : this.closeables) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    JCDiagnostic jCDiagnostic = this.diagFactory.fragment("fatal.err.cant.close", new Object[0]);
                    throw new FatalError(jCDiagnostic, (Throwable)iOException);
                }
            }
            this.closeables = List.nil();
        }
    }

    protected void printNote(String string) {
        this.log.printRawLines(Log.WriterKind.NOTICE, string);
    }

    public void printCount(String string, int n) {
        if (n != 0) {
            String string2 = n == 1 ? "count." + string : "count." + string + ".plural";
            this.log.printLines(Log.WriterKind.ERROR, string2, String.valueOf(n));
            this.log.flush(Log.WriterKind.ERROR);
        }
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private static long elapsed(long l) {
        return JavaCompiler.now() - l;
    }

    public void newRound() {
        this.inputFiles.clear();
        this.todo.clear();
    }

    static {
        DEFAULT_COMPILE_POLICY = CompilePolicy.BY_TODO;
    }

    protected static enum ImplicitSourcePolicy {
        NONE,
        CLASS,
        UNSET;


        static ImplicitSourcePolicy decode(String string) {
            if (string == null) {
                return UNSET;
            }
            if (string.equals("none")) {
                return NONE;
            }
            if (string.equals("class")) {
                return CLASS;
            }
            return UNSET;
        }
    }

    protected static enum CompilePolicy {
        ATTR_ONLY,
        CHECK_ONLY,
        SIMPLE,
        BY_FILE,
        BY_TODO;


        static CompilePolicy decode(String string) {
            if (string == null) {
                return DEFAULT_COMPILE_POLICY;
            }
            if (string.equals("attr")) {
                return ATTR_ONLY;
            }
            if (string.equals("check")) {
                return CHECK_ONLY;
            }
            if (string.equals("simple")) {
                return SIMPLE;
            }
            if (string.equals("byfile")) {
                return BY_FILE;
            }
            if (string.equals("bytodo")) {
                return BY_TODO;
            }
            return DEFAULT_COMPILE_POLICY;
        }
    }
}

