/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class Code
extends Attribute {
    private int max_stack;
    private int max_locals;
    private byte[] code;
    private CodeException[] exception_table;
    private Attribute[] attributes;

    public Code(Code c) {
        this(c.getNameIndex(), c.getLength(), c.getMaxStack(), c.getMaxLocals(), c.getCode(), c.getExceptionTable(), c.getAttributes(), c.getConstantPool());
    }

    Code(int name_index, int length, DataInput file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, file.readUnsignedShort(), file.readUnsignedShort(), null, null, null, constant_pool);
        int code_length = file.readInt();
        this.code = new byte[code_length];
        file.readFully(this.code);
        int exception_table_length = file.readUnsignedShort();
        this.exception_table = new CodeException[exception_table_length];
        for (int i = 0; i < exception_table_length; ++i) {
            this.exception_table[i] = new CodeException(file);
        }
        int attributes_count = file.readUnsignedShort();
        this.attributes = new Attribute[attributes_count];
        for (int i = 0; i < attributes_count; ++i) {
            this.attributes[i] = Attribute.readAttribute(file, constant_pool);
        }
        super.setLength(length);
    }

    public Code(int name_index, int length, int max_stack, int max_locals, byte[] code, CodeException[] exception_table, Attribute[] attributes, ConstantPool constant_pool) {
        super((byte)2, name_index, length, constant_pool);
        this.max_stack = max_stack;
        this.max_locals = max_locals;
        this.code = code != null ? code : new byte[]{};
        this.exception_table = exception_table != null ? exception_table : new CodeException[]{};
        this.attributes = attributes != null ? attributes : new Attribute[]{};
        super.setLength(this.calculateLength());
    }

    @Override
    public void accept(Visitor v) {
        v.visitCode(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.max_stack);
        file.writeShort(this.max_locals);
        file.writeInt(this.code.length);
        file.write(this.code, 0, this.code.length);
        file.writeShort(this.exception_table.length);
        for (CodeException codeException : this.exception_table) {
            codeException.dump(file);
        }
        file.writeShort(this.attributes.length);
        for (Node node : this.attributes) {
            ((Attribute)node).dump(file);
        }
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public LineNumberTable getLineNumberTable() {
        for (Attribute attribute : this.attributes) {
            if (!(attribute instanceof LineNumberTable)) continue;
            return (LineNumberTable)attribute;
        }
        return null;
    }

    public LocalVariableTable getLocalVariableTable() {
        for (Attribute attribute : this.attributes) {
            if (!(attribute instanceof LocalVariableTable)) continue;
            return (LocalVariableTable)attribute;
        }
        return null;
    }

    public byte[] getCode() {
        return this.code;
    }

    public CodeException[] getExceptionTable() {
        return this.exception_table;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    private int getInternalLength() {
        return 8 + this.code.length + 2 + 8 * (this.exception_table == null ? 0 : this.exception_table.length) + 2;
    }

    private int calculateLength() {
        int len = 0;
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                len += attribute.getLength() + 6;
            }
        }
        return len + this.getInternalLength();
    }

    public void setAttributes(Attribute[] attributes) {
        this.attributes = attributes != null ? attributes : new Attribute[]{};
        super.setLength(this.calculateLength());
    }

    public void setCode(byte[] code) {
        this.code = code != null ? code : new byte[]{};
        super.setLength(this.calculateLength());
    }

    public void setExceptionTable(CodeException[] exception_table) {
        this.exception_table = exception_table != null ? exception_table : new CodeException[]{};
        super.setLength(this.calculateLength());
    }

    public void setMaxLocals(int max_locals) {
        this.max_locals = max_locals;
    }

    public void setMaxStack(int max_stack) {
        this.max_stack = max_stack;
    }

    public String toString(boolean verbose) {
        StringBuilder buf = new StringBuilder(100);
        buf.append("Code(max_stack = ").append(this.max_stack).append(", max_locals = ").append(this.max_locals).append(", code_length = ").append(this.code.length).append(")\n").append(Utility.codeToString(this.code, super.getConstantPool(), 0, -1, verbose));
        if (this.exception_table.length > 0) {
            buf.append("\nException handler(s) = \n").append("From\tTo\tHandler\tType\n");
            for (Node node : this.exception_table) {
                buf.append(((CodeException)node).toString(super.getConstantPool(), verbose)).append("\n");
            }
        }
        if (this.attributes.length > 0) {
            buf.append("\nAttribute(s) = ");
            for (Node node : this.attributes) {
                buf.append("\n").append(node);
            }
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        int i;
        Code c = (Code)this.clone();
        if (this.code != null) {
            c.code = new byte[this.code.length];
            System.arraycopy(this.code, 0, c.code, 0, this.code.length);
        }
        c.setConstantPool(_constant_pool);
        c.exception_table = new CodeException[this.exception_table.length];
        for (i = 0; i < this.exception_table.length; ++i) {
            c.exception_table[i] = this.exception_table[i].copy();
        }
        c.attributes = new Attribute[this.attributes.length];
        for (i = 0; i < this.attributes.length; ++i) {
            c.attributes[i] = this.attributes[i].copy(_constant_pool);
        }
        return c;
    }
}

