/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.comp;

import java.util.Map;
import java.util.Optional;
import org.openjdk.javax.tools.JavaFileManager;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.tools.javac.code.Kinds;
import org.openjdk.tools.javac.code.Lint;
import org.openjdk.tools.javac.code.Scope;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.code.Type;
import org.openjdk.tools.javac.code.Types;
import org.openjdk.tools.javac.comp.Annotate;
import org.openjdk.tools.javac.comp.AttrContext;
import org.openjdk.tools.javac.comp.Check;
import org.openjdk.tools.javac.comp.Env;
import org.openjdk.tools.javac.comp.Modules;
import org.openjdk.tools.javac.comp.Todo;
import org.openjdk.tools.javac.comp.TypeEnter;
import org.openjdk.tools.javac.comp.TypeEnvs;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.resources.CompilerProperties;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.tree.TreeInfo;
import org.openjdk.tools.javac.tree.TreeMaker;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Name;
import org.openjdk.tools.javac.util.Names;
import org.openjdk.tools.javac.util.Options;

public class Enter
extends JCTree.Visitor {
    protected static final Context.Key<Enter> enterKey = new Context.Key();
    Annotate annotate;
    Log log;
    Symtab syms;
    Check chk;
    TreeMaker make;
    TypeEnter typeEnter;
    Types types;
    Lint lint;
    Names names;
    JavaFileManager fileManager;
    Option.PkgInfo pkginfoOpt;
    TypeEnvs typeEnvs;
    Modules modules;
    JCDiagnostic.Factory diags;
    private final Todo todo;
    ListBuffer<Symbol.ClassSymbol> uncompleted;
    ListBuffer<JCTree.JCCompilationUnit> unfinishedModules = new ListBuffer();
    private JCTree.JCClassDecl predefClassDef;
    protected Env<AttrContext> env;
    Type result;

    public static Enter instance(Context context) {
        Enter enter = context.get(enterKey);
        if (enter == null) {
            enter = new Enter(context);
        }
        return enter;
    }

    protected Enter(Context context) {
        context.put(enterKey, this);
        this.log = Log.instance(context);
        this.make = TreeMaker.instance(context);
        this.syms = Symtab.instance(context);
        this.chk = Check.instance(context);
        this.typeEnter = TypeEnter.instance(context);
        this.types = Types.instance(context);
        this.annotate = Annotate.instance(context);
        this.lint = Lint.instance(context);
        this.names = Names.instance(context);
        this.modules = Modules.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.predefClassDef = this.make.ClassDef(this.make.Modifiers(1L), this.syms.predefClass.name, List.nil(), null, List.nil(), List.nil());
        this.predefClassDef.sym = this.syms.predefClass;
        this.todo = Todo.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        Options options = Options.instance(context);
        this.pkginfoOpt = Option.PkgInfo.get(options);
        this.typeEnvs = TypeEnvs.instance(context);
    }

    public Env<AttrContext> getEnv(Symbol.TypeSymbol typeSymbol) {
        return this.typeEnvs.get(typeSymbol);
    }

    public Iterable<Env<AttrContext>> getEnvs() {
        return this.typeEnvs.values();
    }

    public Env<AttrContext> getClassEnv(Symbol.TypeSymbol typeSymbol) {
        Env<AttrContext> env = this.getEnv(typeSymbol);
        if (env == null) {
            return null;
        }
        Env<AttrContext> env2 = env;
        while (((AttrContext)env2.info).lint == null) {
            env2 = env2.next;
        }
        ((AttrContext)env.info).lint = ((AttrContext)env2.info).lint.augment(typeSymbol);
        return env;
    }

    public Env<AttrContext> classEnv(JCTree.JCClassDecl jCClassDecl, Env<AttrContext> env) {
        Env<AttrContext> env2 = env.dup(jCClassDecl, ((AttrContext)env.info).dup(Scope.WriteableScope.create(jCClassDecl.sym)));
        env2.enclClass = jCClassDecl;
        env2.outer = env;
        ((AttrContext)env2.info).isSelfCall = false;
        ((AttrContext)env2.info).lint = null;
        ((AttrContext)env2.info).isAnonymousDiamond = TreeInfo.isDiamond(env.tree);
        return env2;
    }

    Env<AttrContext> topLevelEnv(JCTree.JCCompilationUnit jCCompilationUnit) {
        Env<AttrContext> env = new Env<AttrContext>(jCCompilationUnit, new AttrContext());
        env.toplevel = jCCompilationUnit;
        env.enclClass = this.predefClassDef;
        jCCompilationUnit.toplevelScope = Scope.WriteableScope.create(jCCompilationUnit.packge);
        jCCompilationUnit.namedImportScope = new Scope.NamedImportScope(jCCompilationUnit.packge, jCCompilationUnit.toplevelScope);
        jCCompilationUnit.starImportScope = new Scope.StarImportScope(jCCompilationUnit.packge);
        ((AttrContext)env.info).scope = jCCompilationUnit.toplevelScope;
        ((AttrContext)env.info).lint = this.lint;
        return env;
    }

    public Env<AttrContext> getTopLevelEnv(JCTree.JCCompilationUnit jCCompilationUnit) {
        Env<AttrContext> env = new Env<AttrContext>(jCCompilationUnit, new AttrContext());
        env.toplevel = jCCompilationUnit;
        env.enclClass = this.predefClassDef;
        ((AttrContext)env.info).scope = jCCompilationUnit.toplevelScope;
        ((AttrContext)env.info).lint = this.lint;
        return env;
    }

    Scope.WriteableScope enterScope(Env<AttrContext> env) {
        return env.tree.hasTag(JCTree.Tag.CLASSDEF) ? ((JCTree.JCClassDecl)env.tree).sym.members_field : ((AttrContext)env.info).scope;
    }

    public Env<AttrContext> moduleEnv(JCTree.JCModuleDecl jCModuleDecl, Env<AttrContext> env) {
        Assert.checkNonNull(jCModuleDecl.sym);
        Env<AttrContext> env2 = env.dup(jCModuleDecl, ((AttrContext)env.info).dup(Scope.WriteableScope.create(jCModuleDecl.sym)));
        env2.enclClass = this.predefClassDef;
        env2.outer = env;
        ((AttrContext)env2.info).isSelfCall = false;
        ((AttrContext)env2.info).lint = null;
        return env2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type classEnter(JCTree jCTree, Env<AttrContext> env) {
        Env<AttrContext> env2 = this.env;
        try {
            this.env = env;
            this.annotate.blockAnnotations();
            jCTree.accept(this);
            Type type = this.result;
            return type;
        }
        catch (Symbol.CompletionFailure completionFailure) {
            Type type = this.chk.completionError(jCTree.pos(), completionFailure);
            return type;
        }
        finally {
            this.annotate.unblockAnnotations();
            this.env = env2;
        }
    }

    <T extends JCTree> List<Type> classEnter(List<T> list, Env<AttrContext> env) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        List<Object> list2 = list;
        while (list2.nonEmpty()) {
            Type type = this.classEnter((JCTree)list2.head, env);
            if (type != null) {
                listBuffer.append(type);
            }
            list2 = list2.tail;
        }
        return listBuffer.toList();
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit jCCompilationUnit) {
        JavaFileObject javaFileObject = this.log.useSource(jCCompilationUnit.sourcefile);
        boolean bl = false;
        boolean bl2 = jCCompilationUnit.sourcefile.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE);
        if (TreeInfo.isModuleInfo(jCCompilationUnit)) {
            JCTree.JCPackageDecl jCPackageDecl = jCCompilationUnit.getPackage();
            if (jCPackageDecl != null) {
                this.log.error(jCPackageDecl.pos(), CompilerProperties.Errors.NoPkgInModuleInfoJava);
            }
            jCCompilationUnit.packge = this.syms.rootPackage;
            Env<AttrContext> env = this.topLevelEnv(jCCompilationUnit);
            this.classEnter(jCCompilationUnit.defs, env);
            jCCompilationUnit.modle.usesProvidesCompleter = this.modules.getUsesProvidesCompleter();
        } else {
            Env<AttrContext> env;
            JCTree.JCPackageDecl jCPackageDecl = jCCompilationUnit.getPackage();
            if (jCPackageDecl != null) {
                jCCompilationUnit.packge = jCPackageDecl.packge = this.syms.enterPackage(jCCompilationUnit.modle, TreeInfo.fullName(jCPackageDecl.pid));
                if (jCPackageDecl.annotations.nonEmpty() || this.pkginfoOpt == Option.PkgInfo.ALWAYS || jCCompilationUnit.docComments != null) {
                    if (bl2) {
                        bl = true;
                    } else if (jCPackageDecl.annotations.nonEmpty()) {
                        this.log.error(((JCTree.JCAnnotation)jCPackageDecl.annotations.head).pos(), "pkg.annotations.sb.in.package-info.java", new Object[0]);
                    }
                }
            } else {
                jCCompilationUnit.packge = jCCompilationUnit.modle.unnamedPackage;
            }
            Map<Name, Symbol.PackageSymbol> map = jCCompilationUnit.modle.visiblePackages;
            Optional<Symbol.ModuleSymbol> optional = this.syms.listPackageModules(jCCompilationUnit.packge.fullname).stream().filter(moduleSymbol -> moduleSymbol != jCCompilationUnit.modle).filter(moduleSymbol -> map.get(jCCompilationUnit.packge.fullname) == this.syms.getPackage((Symbol.ModuleSymbol)moduleSymbol, jCCompilationUnit.packge.fullname)).findAny();
            if (optional.isPresent()) {
                this.log.error(jCPackageDecl, CompilerProperties.Errors.PackageInOtherModule(optional.get()));
            }
            jCCompilationUnit.packge.complete();
            Env<AttrContext> env2 = this.topLevelEnv(jCCompilationUnit);
            Env<AttrContext> env3 = env = bl2 ? env2.dup(jCPackageDecl) : null;
            if (bl2) {
                Object object;
                Env<AttrContext> env4 = this.typeEnvs.get(jCCompilationUnit.packge);
                if (env4 != null) {
                    object = env4.toplevel;
                    if (!this.fileManager.isSameFile(jCCompilationUnit.sourcefile, ((JCTree.JCCompilationUnit)object).sourcefile)) {
                        this.log.warning(jCPackageDecl != null ? jCPackageDecl.pid.pos() : null, "pkg-info.already.seen", jCCompilationUnit.packge);
                    }
                }
                this.typeEnvs.put(jCCompilationUnit.packge, env);
                object = jCCompilationUnit.packge;
                while (object != null && ((Symbol)object).kind == Kinds.Kind.PCK) {
                    ((Symbol)object).flags_field |= 0x800000L;
                    object = ((Symbol)object).owner;
                }
                object = this.names.package_info;
                Symbol.ClassSymbol classSymbol = this.syms.enterClass(jCCompilationUnit.modle, (Name)object, jCCompilationUnit.packge);
                classSymbol.flatname = this.names.fromString(jCCompilationUnit.packge + "." + object);
                classSymbol.sourcefile = jCCompilationUnit.sourcefile;
                classSymbol.completer = Symbol.Completer.NULL_COMPLETER;
                classSymbol.members_field = Scope.WriteableScope.create(classSymbol);
                jCCompilationUnit.packge.package_info = classSymbol;
            }
            this.classEnter(jCCompilationUnit.defs, env2);
            if (bl) {
                this.todo.append(env);
            }
        }
        this.log.useSource(javaFileObject);
        this.result = null;
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        Symbol.ClassSymbol classSymbol;
        Object object;
        Object object2;
        Symbol symbol = ((AttrContext)this.env.info).scope.owner;
        Scope.WriteableScope writeableScope = this.enterScope(this.env);
        if (symbol.kind == Kinds.Kind.PCK) {
            object = object2 = (Symbol.PackageSymbol)symbol;
            while (object != null && ((Symbol)object).kind == Kinds.Kind.PCK) {
                ((Symbol)object).flags_field |= 0x800000L;
                object = ((Symbol)object).owner;
            }
            classSymbol = this.syms.enterClass(this.env.toplevel.modle, jCClassDecl.name, (Symbol.TypeSymbol)object2);
            ((Symbol.PackageSymbol)object2).members().enterIfAbsent(classSymbol);
            if ((jCClassDecl.mods.flags & 1L) != 0L && !Enter.classNameMatchesFileName(classSymbol, this.env)) {
                object = Kinds.KindName.CLASS;
                if ((jCClassDecl.mods.flags & 0x4000L) != 0L) {
                    object = Kinds.KindName.ENUM;
                } else if ((jCClassDecl.mods.flags & 0x200L) != 0L) {
                    object = Kinds.KindName.INTERFACE;
                }
                this.log.error(jCClassDecl.pos(), "class.public.should.be.in.file", object, jCClassDecl.name);
            }
        } else {
            if (!jCClassDecl.name.isEmpty() && !this.chk.checkUniqueClassName(jCClassDecl.pos(), jCClassDecl.name, writeableScope)) {
                this.result = null;
                return;
            }
            if (symbol.kind == Kinds.Kind.TYP) {
                classSymbol = this.syms.enterClass(this.env.toplevel.modle, jCClassDecl.name, (Symbol.TypeSymbol)symbol);
                if (classSymbol.owner != symbol) {
                    Assert.check(symbol.owner.kind != Kinds.Kind.TYP, symbol::toString);
                    Assert.check(classSymbol.owner.kind == Kinds.Kind.TYP, () -> classSymbol.owner.toString());
                    object2 = (Symbol.ClassSymbol)classSymbol.owner;
                    if (((Symbol.ClassSymbol)object2).members_field != null) {
                        ((Symbol.ClassSymbol)object2).members_field.remove(classSymbol);
                    }
                    classSymbol.owner = symbol;
                }
                if ((symbol.flags_field & 0x200L) != 0L) {
                    jCClassDecl.mods.flags |= 9L;
                }
            } else {
                classSymbol = this.syms.defineClass(jCClassDecl.name, symbol);
                classSymbol.flatname = this.chk.localClassName(classSymbol);
                if (!classSymbol.name.isEmpty()) {
                    this.chk.checkTransparentClass(jCClassDecl.pos(), classSymbol, ((AttrContext)this.env.info).scope);
                }
            }
        }
        jCClassDecl.sym = classSymbol;
        if (this.chk.getCompiled(classSymbol) != null) {
            this.duplicateClass(jCClassDecl.pos(), classSymbol);
            this.result = this.types.createErrorType(jCClassDecl.name, (Symbol.TypeSymbol)symbol, Type.noType);
            jCClassDecl.sym = (Symbol.ClassSymbol)this.result.tsym;
            return;
        }
        this.chk.putCompiled(classSymbol);
        writeableScope.enter(classSymbol);
        object2 = this.classEnv(jCClassDecl, this.env);
        this.typeEnvs.put(classSymbol, (Env<AttrContext>)object2);
        classSymbol.completer = Symbol.Completer.NULL_COMPLETER;
        classSymbol.flags_field = this.chk.checkFlags(jCClassDecl.pos(), jCClassDecl.mods.flags, classSymbol, jCClassDecl);
        classSymbol.sourcefile = this.env.toplevel.sourcefile;
        classSymbol.members_field = Scope.WriteableScope.create(classSymbol);
        classSymbol.clearAnnotationMetadata();
        object = (Type.ClassType)classSymbol.type;
        if (symbol.kind != Kinds.Kind.PCK && (classSymbol.flags_field & 8L) == 0L) {
            Symbol symbol2 = symbol;
            while (symbol2.kind.matches(Kinds.KindSelector.VAL_MTH) && (symbol2.flags_field & 8L) == 0L) {
                symbol2 = symbol2.owner;
            }
            if (symbol2.kind == Kinds.Kind.TYP) {
                ((Type.ClassType)object).setEnclosingType(symbol2.type);
            }
        }
        ((Type.ClassType)object).typarams_field = this.classEnter(jCClassDecl.typarams, (Env<AttrContext>)object2);
        ((Type.ClassType)object).allparams_field = null;
        classSymbol.completer = this.typeEnter;
        if (!classSymbol.isLocal() && this.uncompleted != null) {
            this.uncompleted.append(classSymbol);
        }
        this.classEnter(jCClassDecl.defs, (Env<AttrContext>)object2);
        this.result = classSymbol.type;
    }

    private static boolean classNameMatchesFileName(Symbol.ClassSymbol classSymbol, Env<AttrContext> env) {
        return env.toplevel.sourcefile.isNameCompatible(classSymbol.name.toString(), JavaFileObject.Kind.SOURCE);
    }

    protected void duplicateClass(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.ClassSymbol classSymbol) {
        this.log.error(diagnosticPosition, "duplicate.class", classSymbol.fullname);
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
        Type.TypeVar typeVar = jCTypeParameter.type != null ? (Type.TypeVar)jCTypeParameter.type : new Type.TypeVar(jCTypeParameter.name, ((AttrContext)this.env.info).scope.owner, this.syms.botType);
        jCTypeParameter.type = typeVar;
        if (this.chk.checkUnique(jCTypeParameter.pos(), typeVar.tsym, ((AttrContext)this.env.info).scope)) {
            ((AttrContext)this.env.info).scope.enter(typeVar.tsym);
        }
        this.result = typeVar;
    }

    @Override
    public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
        Env<AttrContext> env = this.moduleEnv(jCModuleDecl, this.env);
        this.typeEnvs.put(jCModuleDecl.sym, env);
        if (this.modules.isInModuleGraph(jCModuleDecl.sym)) {
            this.todo.append(env);
        }
    }

    @Override
    public void visitTree(JCTree jCTree) {
        this.result = null;
    }

    public void main(List<JCTree.JCCompilationUnit> list) {
        this.complete(list, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(List<JCTree.JCCompilationUnit> list, Symbol.ClassSymbol classSymbol) {
        this.annotate.blockAnnotations();
        ListBuffer<Symbol.ClassSymbol> listBuffer = this.uncompleted;
        if (this.typeEnter.completionEnabled) {
            this.uncompleted = new ListBuffer();
        }
        try {
            this.classEnter(list, null);
            if (this.typeEnter.completionEnabled) {
                while (this.uncompleted.nonEmpty()) {
                    Symbol.ClassSymbol classSymbol2 = this.uncompleted.next();
                    if (classSymbol == null || classSymbol == classSymbol2 || listBuffer == null) {
                        classSymbol2.complete();
                        continue;
                    }
                    listBuffer.append(classSymbol2);
                }
                if (!this.modules.modulesInitialized()) {
                    for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
                        if (jCCompilationUnit.getModuleDecl() != null) {
                            this.unfinishedModules.append(jCCompilationUnit);
                            continue;
                        }
                        this.typeEnter.ensureImportsChecked(List.of(jCCompilationUnit));
                    }
                } else {
                    this.typeEnter.ensureImportsChecked(this.unfinishedModules.toList());
                    this.unfinishedModules.clear();
                    this.typeEnter.ensureImportsChecked(list);
                }
            }
        }
        finally {
            this.uncompleted = listBuffer;
            this.annotate.unblockAnnotations();
        }
    }

    public void newRound() {
        this.typeEnvs.clear();
    }
}

