/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.xmpp.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMException;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.kernel.TransportUtils;
import org.apache.axis2.transport.xmpp.XMPPSender;
import org.apache.axis2.transport.xmpp.util.XMPPConnectionFactory;
import org.apache.axis2.transport.xmpp.util.XMPPOutTransportInfo;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.axis2.util.MultipleEntryHashMap;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;

public class XMPPPacketListener
implements PacketListener {
    private static final Log log = LogFactory.getLog(XMPPPacketListener.class);
    private XMPPConnectionFactory xmppConnectionFactory = null;
    private ConfigurationContext configurationContext = null;
    private Executor workerPool = null;
    public static final String CONTENT_TYPE = "mail.contenttype";

    public XMPPPacketListener(XMPPConnectionFactory xmppConnectionFactory, ConfigurationContext configurationContext, Executor workerPool) {
        this.xmppConnectionFactory = xmppConnectionFactory;
        this.configurationContext = configurationContext;
        this.workerPool = workerPool;
    }

    public void processPacket(Packet packet) {
        log.debug((Object)("Received : " + packet.toXML()));
        if (packet instanceof Message) {
            this.workerPool.execute(new Worker(packet));
        }
    }

    private MessageContext createMessageContext(Packet packet) throws AxisFault {
        XMPPOutTransportInfo xmppOutTransportInfo;
        Message message = (Message)packet;
        Boolean isServerSide = (Boolean)message.getProperty("isServerSide");
        String serviceName = (String)message.getProperty("ServiceName");
        String action = (String)message.getProperty("Action");
        MessageContext msgContext = null;
        TransportInDescription transportIn = this.configurationContext.getAxisConfiguration().getTransportIn("xmpp");
        TransportOutDescription transportOut = this.configurationContext.getAxisConfiguration().getTransportOut("xmpp");
        if (transportIn != null && transportOut != null) {
            String xmppMessageId;
            msgContext = this.configurationContext.createMessageContext();
            msgContext.setTransportIn(transportIn);
            msgContext.setTransportOut(transportOut);
            if (isServerSide != null) {
                msgContext.setServerSide(isServerSide.booleanValue());
            }
            msgContext.setProperty(CONTENT_TYPE, (Object)"text/xml");
            msgContext.setProperty("CHARACTER_SET_ENCODING", (Object)"UTF-8");
            msgContext.setIncomingTransportName("xmpp");
            HashMap services = this.configurationContext.getAxisConfiguration().getServices();
            AxisService axisService = (AxisService)services.get(serviceName);
            msgContext.setAxisService(axisService);
            msgContext.setSoapAction(action);
            msgContext.setProperty("XMPPConfigurationFactory", (Object)this.xmppConnectionFactory);
            if (packet.getFrom() != null) {
                msgContext.setFrom(new EndpointReference(packet.getFrom()));
            }
            if (packet.getTo() != null) {
                msgContext.setTo(new EndpointReference(packet.getTo()));
            }
            xmppOutTransportInfo = new XMPPOutTransportInfo();
            xmppOutTransportInfo.setConnectionFactory(this.xmppConnectionFactory);
            String packetFrom = packet.getFrom();
            if (packetFrom != null) {
                EndpointReference fromEPR = new EndpointReference(packetFrom);
                xmppOutTransportInfo.setFrom(fromEPR);
                xmppOutTransportInfo.setDestinationAccount(packetFrom);
            }
            if ((xmppMessageId = packet.getPacketID()) != null) {
                xmppOutTransportInfo.setInReplyTo(xmppMessageId);
            }
        } else {
            throw new AxisFault("Either transport in or transport out is null");
        }
        xmppOutTransportInfo.setSequenceID((String)message.getProperty("transport.xmpp.sequenceID"));
        msgContext.setProperty("OutTransportInfo", (Object)xmppOutTransportInfo);
        this.buildSOAPEnvelope(packet, msgContext);
        return msgContext;
    }

    private void buildSOAPEnvelope(Packet packet, MessageContext msgContext) throws AxisFault {
        Message message = (Message)packet;
        String logMsg = "Trying to create message content using XMPP message received :" + packet.toXML();
        String messageBody = StringEscapeUtils.unescapeXml((String)message.getBody());
        if (msgContext.isServerSide()) {
            log.debug((Object)("Received Envelope : " + messageBody));
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(messageBody.getBytes());
        SOAPEnvelope envelope = null;
        try {
            Object obj = message.getProperty("transport.xmpp.containsSOAPEnvelope");
            if (obj != null && ((Boolean)obj).booleanValue()) {
                String contentType = (String)message.getProperty("ContentType");
                if (contentType == null) {
                    throw new AxisFault("Can not Find Content type Property in the XMPP Message");
                }
                envelope = TransportUtils.createSOAPMessage((MessageContext)msgContext, (InputStream)inputStream, (String)contentType);
                msgContext.setProperty("transport.xmpp.containsSOAPEnvelope", (Object)new Boolean(true));
            } else if (!this.messageContainsCommandsFromChat(messageBody, msgContext)) {
                envelope = this.createSOAPEnvelopeForRawMessage(msgContext, messageBody);
            }
            if (envelope != null) {
                msgContext.setEnvelope(envelope);
            }
        }
        catch (OMException e) {
            log.error((Object)logMsg, (Throwable)e);
            throw new AxisFault(logMsg);
        }
        catch (XMLStreamException e) {
            log.error((Object)logMsg, (Throwable)e);
            throw new AxisFault(logMsg);
        }
        catch (FactoryConfigurationError e) {
            log.error((Object)logMsg, (Throwable)e);
            throw new AxisFault(logMsg);
        }
        catch (AxisFault e) {
            log.error((Object)logMsg, (Throwable)e);
            throw new AxisFault(logMsg);
        }
    }

    private boolean messageContainsCommandsFromChat(String message, MessageContext msgContext) {
        boolean containsKnownCommand = false;
        if (message.trim().startsWith("help")) {
            containsKnownCommand = true;
        } else if (message.trim().startsWith("listServices")) {
            containsKnownCommand = true;
        } else if (message.trim().startsWith("getOperations")) {
            containsKnownCommand = true;
        }
        if (containsKnownCommand) {
            msgContext.setProperty("transport.xmpp.message.from.chat", (Object)message.trim());
        }
        return containsKnownCommand;
    }

    private SOAPEnvelope createSOAPEnvelopeForRawMessage(MessageContext msgCtx, String chatMessage) throws AxisFault {
        String callRemoved = chatMessage.replaceFirst("call", "");
        String serviceName = callRemoved.trim().substring(0, callRemoved.indexOf(":") - 1);
        String operationName = callRemoved.trim().substring(callRemoved.indexOf(":"), callRemoved.indexOf("(") - 1);
        String parameterList = callRemoved.trim().substring(callRemoved.indexOf("("), callRemoved.trim().length() - 1);
        StringTokenizer st = new StringTokenizer(parameterList, ",");
        MultipleEntryHashMap parameterMap = new MultipleEntryHashMap();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String name = token.substring(0, token.indexOf("="));
            String value = token.substring(token.indexOf("=") + 1);
            parameterMap.put((Object)name, (Object)value);
        }
        SOAPEnvelope envelope = null;
        try {
            msgCtx.setProperty("transport.xmpp.containsSOAPEnvelope", (Object)new Boolean(true));
            if (serviceName != null && serviceName.trim().length() > 0) {
                AxisService axisService = msgCtx.getConfigurationContext().getAxisConfiguration().getService(serviceName);
                msgCtx.setAxisService(axisService);
                AxisOperation axisOperation = axisService.getOperationBySOAPAction("urn:" + operationName);
                if (axisOperation != null) {
                    msgCtx.setAxisOperation(axisOperation);
                }
            }
            if (operationName != null && operationName.trim().length() > 0) {
                msgCtx.setSoapAction("urn:" + operationName);
            }
            XMPPOutTransportInfo xmppOutTransportInfo = (XMPPOutTransportInfo)msgCtx.getProperty("OutTransportInfo");
            xmppOutTransportInfo.setContentType("xmpp/text");
            msgCtx.setServerSide(true);
            SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
            envelope = BuilderUtil.buildsoapMessage((MessageContext)msgCtx, (MultipleEntryHashMap)parameterMap, (SOAPFactory)soapFactory);
        }
        catch (AxisFault e) {
            throw new AxisFault(e.getMessage());
        }
        catch (OMException e) {
            throw new AxisFault(e.getMessage());
        }
        catch (FactoryConfigurationError e) {
            throw new AxisFault(e.getMessage());
        }
        return envelope;
    }

    class Worker
    implements Runnable {
        private Packet packet = null;

        Worker(Packet packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            block8: {
                MessageContext msgCtx = null;
                try {
                    msgCtx = XMPPPacketListener.this.createMessageContext(this.packet);
                    Object obj = msgCtx.getProperty("transport.xmpp.containsSOAPEnvelope");
                    if (obj != null && ((Boolean)obj).booleanValue()) {
                        if (msgCtx.isProcessingFault() && msgCtx.isServerSide()) {
                            AxisEngine.sendFault((MessageContext)msgCtx);
                        } else {
                            AxisEngine.receive((MessageContext)msgCtx);
                        }
                    } else {
                        XMPPSender.processChatMessage(msgCtx);
                    }
                }
                catch (AxisFault e) {
                    log.error((Object)("Error occurred while sending message" + String.valueOf((Object)e)));
                    if (msgCtx == null || !msgCtx.isServerSide()) break block8;
                    try {
                        MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)msgCtx, (Throwable)e);
                        AxisEngine.sendFault((MessageContext)faultContext);
                    }
                    catch (AxisFault e1) {
                        log.error((Object)("Error occurred while creating SOAPFault message" + String.valueOf((Object)e1)));
                    }
                }
            }
        }
    }
}

