/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.MessageSender;
import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.catalina.tribes.ByteMessage;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChannelSender
implements MessageSender {
    private static Log log = LogFactory.getLog(ChannelSender.class);
    private Channel channel;
    private boolean synchronizeAllMembers;
    private MembershipManager membershipManager;

    public ChannelSender(Channel channel, MembershipManager membershipManager, boolean synchronizeAllMembers) {
        this.channel = channel;
        this.membershipManager = membershipManager;
        this.synchronizeAllMembers = synchronizeAllMembers;
    }

    public synchronized void sendToGroup(ClusteringCommand msg, MembershipManager membershipManager, int additionalOptions) throws ClusteringFault {
        if (this.channel == null) {
            return;
        }
        Member[] members = membershipManager.getMembers();
        if (members.length > 0) {
            try {
                if (this.synchronizeAllMembers) {
                    this.channel.send(members, (Serializable)this.toByteMessage(msg), 0xA07 | additionalOptions);
                } else {
                    this.channel.send(members, (Serializable)this.toByteMessage(msg), 0xA09 | additionalOptions);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sent " + String.valueOf(msg) + " to group"));
                }
            }
            catch (NotSerializableException e) {
                String message = "Could not send command message " + String.valueOf(msg) + " to group since it is not serializable.";
                log.error((Object)message, (Throwable)e);
                throw new ClusteringFault(message, (Exception)e);
            }
            catch (ChannelException e) {
                ChannelException.FaultyMember[] faultyMembers;
                log.error((Object)"Could not send message to some members", (Throwable)e);
                for (ChannelException.FaultyMember faultyMember : faultyMembers = e.getFaultyMembers()) {
                    Member member = faultyMember.getMember();
                    log.error((Object)("Member " + TribesUtil.getName(member) + " is faulty"), (Throwable)faultyMember.getCause());
                }
            }
            catch (Exception e) {
                String message = "Error sending command message : " + String.valueOf(msg) + ". Reason " + e.getMessage();
                log.warn((Object)message, (Throwable)e);
            }
        }
    }

    public void sendToGroup(ClusteringCommand msg) throws ClusteringFault {
        this.sendToGroup(msg, this.membershipManager, 0);
    }

    private ByteMessage toByteMessage(ClusteringCommand msg) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(msg);
        out.flush();
        out.close();
        return new ByteMessage(bos.toByteArray());
    }

    public void sendToSelf(ClusteringCommand msg) throws ClusteringFault {
        if (this.channel == null) {
            return;
        }
        try {
            this.channel.send(new Member[]{this.channel.getLocalMember(true)}, (Serializable)this.toByteMessage(msg), 3);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sent " + String.valueOf(msg) + " to self"));
            }
        }
        catch (Exception e) {
            throw new ClusteringFault(e);
        }
    }

    public void sendToMember(ClusteringCommand cmd, Member member) throws ClusteringFault {
        try {
            if (member.isReady()) {
                this.channel.send(new Member[]{member}, (Serializable)this.toByteMessage(cmd), 2567);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sent " + String.valueOf(cmd) + " to " + TribesUtil.getName(member)));
                }
            }
        }
        catch (NotSerializableException e) {
            String message = "Could not send command message to " + TribesUtil.getName(member) + " since it is not serializable.";
            log.error((Object)message, (Throwable)e);
            throw new ClusteringFault(message, (Exception)e);
        }
        catch (ChannelException e) {
            log.error((Object)("Could not send message to " + TribesUtil.getName(member)));
            ChannelException.FaultyMember[] faultyMembers = e.getFaultyMembers();
            log.error((Object)("Member " + TribesUtil.getName(member) + " is faulty"), (Throwable)faultyMembers[0].getCause());
        }
        catch (Exception e) {
            String message = "Could not send message to " + TribesUtil.getName(member) + ". Reason " + e.getMessage();
            log.warn((Object)message, (Throwable)e);
        }
    }
}

