/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TransportHeaders
implements Map<String, String> {
    HttpServletRequest req;
    Map<String, String> headerMap = null;
    Map<String, String> localHeaderMap = new HashMap<String, String>();

    public TransportHeaders(HttpServletRequest req) {
        this.req = req;
    }

    private void init() {
        this.headerMap = new HashMap<String, String>();
        Enumeration headerNames = this.req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = this.req.getHeader(key);
            this.headerMap.put(key, value);
        }
        for (Map.Entry<String, String> localHeaderEntry : this.localHeaderMap.entrySet()) {
            this.headerMap.put(localHeaderEntry.getKey(), localHeaderEntry.getValue());
        }
        this.localHeaderMap = null;
    }

    @Override
    public int size() {
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.size();
    }

    @Override
    public void clear() {
        if (this.headerMap != null) {
            this.headerMap.clear();
        }
        if (this.localHeaderMap != null) {
            this.localHeaderMap.clear();
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.containsValue(value);
    }

    @Override
    public Collection<String> values() {
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.values();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> t) {
        if (this.headerMap == null) {
            this.init();
        }
        this.headerMap.putAll(t);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.entrySet();
    }

    @Override
    public Set<String> keySet() {
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.keySet();
    }

    @Override
    public String get(Object key) {
        if (this.localHeaderMap != null) {
            String returnValue = null;
            returnValue = this.localHeaderMap.get(key);
            if (returnValue != null) {
                return returnValue;
            }
        }
        if (this.headerMap == null) {
            return this.req.getHeader((String)key);
        }
        return this.headerMap.get(key);
    }

    @Override
    public String remove(Object key) {
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.remove(key);
    }

    @Override
    public String put(String key, String value) {
        if (this.localHeaderMap != null) {
            return this.localHeaderMap.put(key, value);
        }
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.put(key, value);
    }
}

