/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core;

import org.apache.axiom.core.AttributeMatcher;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNSAwareAttribute;
import org.apache.axiom.core.CoreNSUnawareAttribute;
import org.apache.axiom.core.NodeFactory2;
import org.apache.axiom.core.Semantics;

public final class NSAwareAttributeMatcher
implements AttributeMatcher {
    private final Semantics semantics;
    private final boolean matchNSUnawareAttributes;
    private final boolean updatePrefix;

    public NSAwareAttributeMatcher(Semantics semantics, boolean matchNSUnawareAttributes, boolean updatePrefix) {
        this.semantics = semantics;
        this.matchNSUnawareAttributes = matchNSUnawareAttributes;
        this.updatePrefix = updatePrefix;
    }

    @Override
    public boolean matches(CoreAttribute attr, String namespaceURI, String name) {
        if (attr instanceof CoreNSAwareAttribute) {
            CoreNSAwareAttribute nsAwareAttr = (CoreNSAwareAttribute)attr;
            return name.equals(nsAwareAttr.coreGetLocalName()) && namespaceURI.equals(nsAwareAttr.coreGetNamespaceURI());
        }
        if (this.matchNSUnawareAttributes && namespaceURI.length() == 0 && attr instanceof CoreNSUnawareAttribute) {
            return name.equals(((CoreNSUnawareAttribute)attr).coreGetName());
        }
        return false;
    }

    @Override
    public String getNamespaceURI(CoreAttribute attr) {
        return ((CoreNSAwareAttribute)attr).coreGetNamespaceURI();
    }

    @Override
    public String getName(CoreAttribute attr) {
        return ((CoreNSAwareAttribute)attr).coreGetLocalName();
    }

    @Override
    public CoreAttribute createAttribute(NodeFactory2 nodeFactory, String namespaceURI, String name, String prefix, String value) throws CoreModelException {
        CoreNSAwareAttribute attr = nodeFactory.createNSAwareAttribute();
        attr.coreSetName(namespaceURI, name, prefix);
        attr.coreSetCharacterData(value, null);
        return attr;
    }

    @Override
    public void update(CoreAttribute attr, String prefix, String value) throws CoreModelException {
        attr.coreSetCharacterData(value, this.semantics);
        if (this.updatePrefix && attr instanceof CoreNSAwareAttribute) {
            ((CoreNSAwareAttribute)attr).coreSetPrefix(prefix);
        }
    }
}

