/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.dispatchers;

import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JSONBasedDefaultDispatcher
extends AbstractDispatcher {
    public static final String NAME = "JSONBasedDefaultDispatcher";
    private static final Log log = LogFactory.getLog(JSONBasedDefaultDispatcher.class);

    @Override
    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        String jsonMessageName = (String)messageContext.getProperty("jsonMessageName");
        if (jsonMessageName == null) {
            log.error((Object)"JSONBasedDefaultDispatcher.findOperation() returning null on null jsonMessageName");
            return null;
        }
        AxisOperation axisOperation = service.getOperationByJSONMessageName(jsonMessageName);
        if (axisOperation == null) {
            log.error((Object)(messageContext.getLogIDString() + " , axisOperation is null in findOperation() with jsonMessageName: " + jsonMessageName + " , service name: " + service.getName()));
            return null;
        }
        log.debug((Object)(messageContext.getLogIDString() + " , axisOperation found from  with service name: " + service.getName() + " , operation: " + axisOperation.getName().getLocalPart() + " , jsonMessageName: " + jsonMessageName));
        return axisOperation;
    }

    @Override
    public AxisService findService(MessageContext messageContext) throws AxisFault {
        OMNamespace ns;
        String localPart = messageContext.getEnvelope().getSOAPBodyFirstElementLocalName();
        if (localPart != null && (ns = messageContext.getEnvelope().getSOAPBodyFirstElementNS()) != null) {
            ConfigurationContext configurationContext;
            String[] values;
            String filePart = ns.getNamespaceURI();
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(messageContext.getLogIDString() + " Checking for Service using SOAP message body's first child's namespace : " + filePart));
            }
            if ((values = Utils.parseRequestURLForServiceAndOperation(filePart, (configurationContext = messageContext.getConfigurationContext()).getServiceContextPath()))[0] != null) {
                String serviceName = values[0];
                AxisConfiguration registry = configurationContext.getAxisConfiguration();
                return registry.getService(serviceName);
            }
        }
        return null;
    }

    @Override
    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }
}

