/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OptionsTest {
    OptionsTest() {
    }

    private void assertToStrings(Option option) {
        Assertions.assertNotNull((Object)option.toString());
        Assertions.assertNotNull((Object)option.toDeprecatedString());
    }

    @Test
    void testAddConflictingOptions() {
        Options options1 = new Options();
        OptionGroup optionGroup1 = new OptionGroup();
        optionGroup1.addOption(Option.builder((String)"a").get());
        optionGroup1.addOption(Option.builder((String)"b").get());
        options1.addOptionGroup(optionGroup1);
        options1.addOption(Option.builder((String)"x").get());
        options1.addOption(Option.builder((String)"y").get());
        Options options2 = new Options();
        OptionGroup optionGroup2 = new OptionGroup();
        optionGroup2.addOption(Option.builder((String)"x").type(Integer.class).get());
        optionGroup2.addOption(Option.builder((String)"b").type(Integer.class).get());
        options2.addOptionGroup(optionGroup2);
        options2.addOption(Option.builder((String)"c").get());
        Assertions.assertThrows(IllegalArgumentException.class, () -> options1.addOptions(options2));
    }

    @Test
    void testAddNonConflictingOptions() {
        Options options1 = new Options();
        OptionGroup optionGroup1 = new OptionGroup();
        optionGroup1.addOption(Option.builder((String)"a").get());
        optionGroup1.addOption(Option.builder((String)"b").get());
        options1.addOptionGroup(optionGroup1);
        options1.addOption(Option.builder((String)"x").get());
        options1.addOption(Option.builder((String)"y").get());
        Options options2 = new Options();
        OptionGroup group2 = new OptionGroup();
        group2.addOption(Option.builder((String)"c").type(Integer.class).get());
        group2.addOption(Option.builder((String)"d").type(Integer.class).get());
        options2.addOptionGroup(group2);
        options1.addOption(Option.builder((String)"e").get());
        options1.addOption(Option.builder((String)"f").get());
        Options underTest = new Options();
        underTest.addOptions(options1);
        underTest.addOptions(options2);
        List<OptionGroup> expected = Arrays.asList(optionGroup1, group2);
        Assertions.assertTrue((expected.size() == underTest.getOptionGroups().size() && expected.containsAll(underTest.getOptionGroups()) ? 1 : 0) != 0);
        HashSet expectOpt = new HashSet(options1.getOptions());
        expectOpt.addAll(options2.getOptions());
        Assertions.assertEquals((int)8, (int)expectOpt.size());
        Assertions.assertTrue((expectOpt.size() == underTest.getOptions().size() && expectOpt.containsAll(underTest.getOptions()) ? 1 : 0) != 0);
    }

    @Test
    void testAddOptions() {
        Options options = new Options();
        OptionGroup optionGroup1 = new OptionGroup();
        optionGroup1.addOption(Option.builder((String)"a").get());
        optionGroup1.addOption(Option.builder((String)"b").get());
        options.addOptionGroup(optionGroup1);
        options.addOption(Option.builder((String)"X").get());
        options.addOption(Option.builder((String)"y").get());
        Options underTest = new Options();
        underTest.addOptions(options);
        Assertions.assertEquals((Object)options.getOptionGroups(), (Object)underTest.getOptionGroups());
        Assertions.assertArrayEquals((Object[])options.getOptions().toArray(), (Object[])underTest.getOptions().toArray());
    }

    @Test
    void testAddOptions2X() {
        Options options = new Options();
        OptionGroup optionGroup1 = new OptionGroup();
        optionGroup1.addOption(Option.builder((String)"a").get());
        optionGroup1.addOption(Option.builder((String)"b").get());
        options.addOptionGroup(optionGroup1);
        options.addOption(Option.builder((String)"X").get());
        options.addOption(Option.builder((String)"y").get());
        Assertions.assertThrows(IllegalArgumentException.class, () -> options.addOptions(options));
    }

    @Test
    void testDeprecated() {
        Options options = new Options();
        options.addOption(Option.builder().option("a").get());
        options.addOption(Option.builder().option("b").deprecated().get());
        options.addOption(Option.builder().option("c").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("2.0").setDescription("Use X.").get()).get());
        options.addOption(Option.builder().option("d").deprecated().longOpt("longD").hasArgs().get());
        Assertions.assertTrue((boolean)options.getOption("a").toString().startsWith("[ Option a"));
        Assertions.assertTrue((boolean)options.getOption("b").toString().startsWith("[ Option b"));
        Assertions.assertTrue((boolean)options.getOption("c").toString().startsWith("[ Option c"));
        Assertions.assertFalse((boolean)options.getOption("a").toDeprecatedString().startsWith("Option a"));
        Assertions.assertEquals((Object)"Option 'b': Deprecated", (Object)options.getOption("b").toDeprecatedString());
        Assertions.assertEquals((Object)"Option 'c': Deprecated for removal since 2.0: Use X.", (Object)options.getOption("c").toDeprecatedString());
        this.assertToStrings(options.getOption("a"));
        this.assertToStrings(options.getOption("b"));
        this.assertToStrings(options.getOption("c"));
        this.assertToStrings(options.getOption("d"));
    }

    @Test
    void testDuplicateLong() {
        Options options = new Options();
        options.addOption("a", "--a", false, "toggle -a");
        options.addOption("a", "--a", false, "toggle -a*");
        Assertions.assertEquals((Object)"toggle -a*", (Object)options.getOption("a").getDescription(), (String)"last one in wins");
        this.assertToStrings(options.getOption("a"));
    }

    @Test
    void testDuplicateSimple() {
        Options options = new Options();
        options.addOption("a", false, "toggle -a");
        this.assertToStrings(options.getOption("a"));
        options.addOption("a", true, "toggle -a*");
        Assertions.assertEquals((Object)"toggle -a*", (Object)options.getOption("a").getDescription(), (String)"last one in wins");
        this.assertToStrings(options.getOption("a"));
    }

    @Test
    void testGetMatchingOpts() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"verbose");
        options.addOption(OptionBuilder.create());
        Assertions.assertTrue((boolean)options.getMatchingOptions("foo").isEmpty());
        Assertions.assertEquals((int)1, (int)options.getMatchingOptions("version").size());
        Assertions.assertEquals((int)2, (int)options.getMatchingOptions("ver").size());
        this.assertToStrings(options.getOption("version"));
        this.assertToStrings(options.getOption("verbose"));
    }

    @Test
    void testGetOptionsGroups() {
        Options options = new Options();
        OptionGroup optionGroup1 = new OptionGroup();
        optionGroup1.addOption(OptionBuilder.create((char)'a'));
        optionGroup1.addOption(OptionBuilder.create((char)'b'));
        OptionGroup optionGroup2 = new OptionGroup();
        optionGroup2.addOption(OptionBuilder.create((char)'x'));
        optionGroup2.addOption(OptionBuilder.create((char)'y'));
        options.addOptionGroup(optionGroup1);
        options.addOptionGroup(optionGroup2);
        Assertions.assertNotNull((Object)options.getOptionGroups());
        Assertions.assertEquals((int)2, (int)options.getOptionGroups().size());
    }

    @Test
    void testHelpOptions() {
        OptionBuilder.withLongOpt((String)"long-only1");
        Option longOnly1 = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"long-only2");
        Option longOnly2 = OptionBuilder.create();
        Option shortOnly1 = OptionBuilder.create((String)"1");
        Option shortOnly2 = OptionBuilder.create((String)"2");
        OptionBuilder.withLongOpt((String)"bothA");
        Option bothA = OptionBuilder.create((String)"a");
        OptionBuilder.withLongOpt((String)"bothB");
        Option bothB = OptionBuilder.create((String)"b");
        Options options = new Options();
        options.addOption(longOnly1);
        options.addOption(longOnly2);
        options.addOption(shortOnly1);
        options.addOption(shortOnly2);
        options.addOption(bothA);
        options.addOption(bothB);
        ArrayList<Option> allOptions = new ArrayList<Option>();
        allOptions.add(longOnly1);
        allOptions.add(longOnly2);
        allOptions.add(shortOnly1);
        allOptions.add(shortOnly2);
        allOptions.add(bothA);
        allOptions.add(bothB);
        List helpOptions = options.helpOptions();
        Assertions.assertTrue((boolean)helpOptions.containsAll(allOptions), (String)"Everything in all should be in help");
        Assertions.assertTrue((boolean)allOptions.containsAll(helpOptions), (String)"Everything in help should be in all");
    }

    @Test
    void testLong() {
        Options options = new Options();
        options.addOption("a", "--a", false, "toggle -a");
        options.addOption("b", "--b", true, "set -b");
        Assertions.assertTrue((boolean)options.hasOption("a"));
        Assertions.assertTrue((boolean)options.hasOption("b"));
    }

    @Test
    void testMissingOptionException() throws ParseException {
        Options options = new Options();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"f"));
        MissingOptionException e = (MissingOptionException)Assertions.assertThrows(MissingOptionException.class, () -> new PosixParser().parse(options, new String[0]));
        Assertions.assertEquals((Object)"Missing required option: f", (Object)e.getMessage());
    }

    @Test
    void testMissingOptionsException() throws ParseException {
        Options options = new Options();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"x"));
        MissingOptionException e = (MissingOptionException)Assertions.assertThrows(MissingOptionException.class, () -> new PosixParser().parse(options, new String[0]));
        Assertions.assertEquals((Object)"Missing required options: f, x", (Object)e.getMessage());
    }

    @Test
    void testRequiredOptionInGroupShouldNotBeInRequiredList() {
        String key = "a";
        Option option = new Option("a", "along", false, "Option A");
        option.setRequired(true);
        Options options = new Options();
        options.addOption(option);
        Assertions.assertTrue((boolean)options.getRequiredOptions().contains("a"));
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.addOption(option);
        options.addOptionGroup(optionGroup);
        Assertions.assertFalse((boolean)options.getOption("a").isRequired());
        Assertions.assertFalse((boolean)options.getRequiredOptions().contains("a"), (String)"Option in group shouldn't be in required options list.");
    }

    @Test
    void testSimple() {
        Options options = new Options();
        options.addOption("a", false, "toggle -a");
        options.addOption("b", true, "toggle -b");
        Assertions.assertTrue((boolean)options.hasOption("a"));
        Assertions.assertTrue((boolean)options.hasOption("b"));
    }

    @Test
    void testToString() {
        Options options = new Options();
        options.addOption("f", "foo", true, "Foo");
        options.addOption("b", "bar", false, "Bar");
        String s = options.toString();
        Assertions.assertNotNull((Object)s, (String)"null string returned");
        Assertions.assertTrue((boolean)s.toLowerCase().contains("foo"), (String)"foo option missing");
        Assertions.assertTrue((boolean)s.toLowerCase().contains("bar"), (String)"bar option missing");
    }
}

