/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.cli.Converter;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PatternOptionBuilder;
import org.apache.commons.cli.TypeHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.DefaultLocale;

class TypeHandlerTest {
    private static final Converter<Path, InvalidPathException> PATH_CONVERTER = s -> Paths.get("foo", new String[0]);

    TypeHandlerTest() {
    }

    private static Stream<Date> createDateFixtures() {
        return Stream.of(Date.from(Instant.EPOCH), Date.from(Instant.ofEpochSecond(0L)), Date.from(Instant.ofEpochSecond(40000L)));
    }

    private static Stream<Arguments> createValueTestParameters() throws MalformedURLException {
        Class loadStatic = PatternOptionBuilder.FILES_VALUE;
        ArrayList<Arguments> list = new ArrayList<Arguments>();
        Date date = new Date(1023400137000L);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        list.add(Arguments.of((Object[])new Object[]{Instantiable.class.getName(), PatternOptionBuilder.CLASS_VALUE, Instantiable.class}));
        list.add(Arguments.of((Object[])new Object[]{"what ever", PatternOptionBuilder.CLASS_VALUE, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"what ever", PatternOptionBuilder.DATE_VALUE, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{dateFormat.format(date), PatternOptionBuilder.DATE_VALUE, date}));
        list.add(Arguments.of((Object[])new Object[]{"Jun 06 17:48:57 EDT 2002", PatternOptionBuilder.DATE_VALUE, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"non-existing.file", PatternOptionBuilder.EXISTING_FILE_VALUE, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"some-file.txt", PatternOptionBuilder.FILE_VALUE, new File("some-file.txt")}));
        list.add(Arguments.of((Object[])new Object[]{"some-path.txt", Path.class, new File("some-path.txt").toPath()}));
        list.add(Arguments.of((Object[])new Object[]{"some.files", PatternOptionBuilder.FILES_VALUE, "some.files"}));
        list.add(Arguments.of((Object[])new Object[]{"just-a-string", Integer.class, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"5", Integer.class, 5}));
        list.add(Arguments.of((Object[])new Object[]{"5.5", Integer.class, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{Long.toString(Long.MAX_VALUE), Integer.class, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"just-a-string", Long.class, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"5", Long.class, 5L}));
        list.add(Arguments.of((Object[])new Object[]{"5.5", Long.class, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"just-a-string", Short.class, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"5", Short.class, (short)5}));
        list.add(Arguments.of((Object[])new Object[]{"5.5", Short.class, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{Integer.toString(Integer.MAX_VALUE), Short.class, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"just-a-string", Byte.class, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"5", Byte.class, (byte)5}));
        list.add(Arguments.of((Object[])new Object[]{"5.5", Byte.class, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{Short.toString((short)Short.MAX_VALUE), Byte.class, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"just-a-string", Character.class, Character.valueOf('j')}));
        list.add(Arguments.of((Object[])new Object[]{"5", Character.class, Character.valueOf('5')}));
        list.add(Arguments.of((Object[])new Object[]{"5.5", Character.class, Character.valueOf('5')}));
        list.add(Arguments.of((Object[])new Object[]{"\\u0124", Character.class, Character.valueOf(Character.toChars(292)[0])}));
        list.add(Arguments.of((Object[])new Object[]{"just-a-string", Double.class, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"5", Double.class, 5.0}));
        list.add(Arguments.of((Object[])new Object[]{"5.5", Double.class, 5.5}));
        list.add(Arguments.of((Object[])new Object[]{"just-a-string", Float.class, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"5", Float.class, Float.valueOf(5.0f)}));
        list.add(Arguments.of((Object[])new Object[]{"5.5", Float.class, Float.valueOf(5.5f)}));
        list.add(Arguments.of((Object[])new Object[]{Double.toString(Double.MAX_VALUE), Float.class, Float.valueOf(Float.POSITIVE_INFINITY)}));
        list.add(Arguments.of((Object[])new Object[]{"just-a-string", BigInteger.class, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"5", BigInteger.class, new BigInteger("5")}));
        list.add(Arguments.of((Object[])new Object[]{"5.5", BigInteger.class, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"just-a-string", BigDecimal.class, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"5", BigDecimal.class, new BigDecimal("5")}));
        list.add(Arguments.of((Object[])new Object[]{"5.5", BigDecimal.class, new BigDecimal(5.5)}));
        list.add(Arguments.of((Object[])new Object[]{"1.5", PatternOptionBuilder.NUMBER_VALUE, 1.5}));
        list.add(Arguments.of((Object[])new Object[]{"15", PatternOptionBuilder.NUMBER_VALUE, 15L}));
        list.add(Arguments.of((Object[])new Object[]{"not a number", PatternOptionBuilder.NUMBER_VALUE, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{Instantiable.class.getName(), PatternOptionBuilder.OBJECT_VALUE, new Instantiable()}));
        list.add(Arguments.of((Object[])new Object[]{NotInstantiable.class.getName(), PatternOptionBuilder.OBJECT_VALUE, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"unknown", PatternOptionBuilder.OBJECT_VALUE, ParseException.class}));
        list.add(Arguments.of((Object[])new Object[]{"String", PatternOptionBuilder.STRING_VALUE, "String"}));
        String urlString = "https://commons.apache.org";
        list.add(Arguments.of((Object[])new Object[]{"https://commons.apache.org", PatternOptionBuilder.URL_VALUE, new URL("https://commons.apache.org")}));
        list.add(Arguments.of((Object[])new Object[]{"Malformed-url", PatternOptionBuilder.URL_VALUE, ParseException.class}));
        return list.stream();
    }

    @Test
    void testCreateClass() throws ParseException {
        Class<?> cls = this.getClass();
        Assertions.assertEquals(cls, (Object)TypeHandler.createClass((String)cls.getName()));
    }

    @ParameterizedTest
    @MethodSource(value={"createDateFixtures"})
    @DefaultLocale(language="en", country="US")
    void testCreateDate(Date date) {
        Assertions.assertEquals((Object)date, (Object)TypeHandler.createDate((String)date.toString()));
    }

    @Test
    void testCreateFile() {
        File file = FileUtils.current().getAbsoluteFile();
        Assertions.assertEquals((Object)file, (Object)TypeHandler.createFile((String)file.toString()));
    }

    @Test
    void testCreateFiles() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> TypeHandler.createFiles(null));
    }

    @Test
    void testCreateNumber() throws ParseException {
        Assertions.assertEquals((Object)0L, (Object)TypeHandler.createNumber((String)"0"));
        Assertions.assertEquals((Object)0.0, (Object)TypeHandler.createNumber((String)"0.0"));
    }

    @Test
    void testCreateObject() throws ParseException {
        Assertions.assertTrue((boolean)(TypeHandler.createObject((String)Date.class.getName()) instanceof Date));
    }

    @Test
    void testCreateURL() throws ParseException, MalformedURLException {
        URL file = Paths.get("", new String[0]).toAbsolutePath().toUri().toURL();
        Assertions.assertEquals((Object)file, (Object)TypeHandler.createURL((String)file.toString()));
    }

    @ParameterizedTest(name="{0} as {1}")
    @MethodSource(value={"createValueTestParameters"})
    void testCreateValue(String str, Class<?> type, Object expected) throws Exception {
        Class<?> objectApiTest = type;
        if (expected instanceof Class && Throwable.class.isAssignableFrom((Class)expected)) {
            Assertions.assertThrows((Class)((Class)expected), () -> TypeHandler.createValue((String)str, (Class)type));
            Assertions.assertThrows((Class)((Class)expected), () -> TypeHandler.createValue((String)str, (Object)objectApiTest));
        } else {
            Assertions.assertEquals((Object)expected, (Object)TypeHandler.createValue((String)str, type));
            Assertions.assertEquals((Object)expected, (Object)TypeHandler.createValue((String)str, objectApiTest));
        }
    }

    @Test
    void testCreateValueExistingFile() throws Exception {
        try (FileInputStream result = (FileInputStream)TypeHandler.createValue((String)"src/test/resources/org/apache/commons/cli/existing-readable.file", (Class)PatternOptionBuilder.EXISTING_FILE_VALUE);){
            Assertions.assertNotNull((Object)result);
        }
    }

    @Test
    void testnstantiableEquals() {
        Assertions.assertEquals((Object)new Instantiable(), (Object)new Instantiable());
    }

    @Test
    void testOpenFile() throws ParseException, IOException {
        try (FileInputStream fis = TypeHandler.openFile((String)"src/test/resources/org/apache/commons/cli/existing-readable.file");){
            IOUtils.consume((InputStream)fis);
        }
    }

    @Test
    void testRegister() {
        Map map = TypeHandler.createDefaultMap();
        TypeHandler typeHandler = new TypeHandler(map);
        Assertions.assertEquals((Object)Converter.PATH, (Object)typeHandler.getConverter(Path.class));
        try {
            map.put(Path.class, PATH_CONVERTER);
            Assertions.assertEquals(PATH_CONVERTER, (Object)typeHandler.getConverter(Path.class));
        }
        finally {
            map.remove(Path.class);
            Assertions.assertEquals((Object)Converter.DEFAULT, (Object)typeHandler.getConverter(Path.class));
        }
    }

    public static class Instantiable {
        public boolean equals(Object arg0) {
            return arg0 instanceof Instantiable;
        }

        public int hashCode() {
            return 1;
        }
    }

    public static final class NotInstantiable {
        private NotInstantiable() {
        }
    }
}

