/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.ode.nonstiff;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.MaxCountExceededException;
import org.apache.commons.math4.legacy.exception.NoBracketingException;
import org.apache.commons.math4.legacy.exception.NumberIsTooSmallException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.ode.AbstractIntegrator;
import org.apache.commons.math4.legacy.ode.ExpandableStatefulODE;

public abstract class AdaptiveStepsizeIntegrator
extends AbstractIntegrator {
    protected double scalAbsoluteTolerance;
    protected double scalRelativeTolerance;
    protected double[] vecAbsoluteTolerance;
    protected double[] vecRelativeTolerance;
    protected int mainSetDimension;
    private double initialStep;
    private double minStep;
    private double maxStep;

    public AdaptiveStepsizeIntegrator(String name, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(name);
        this.setStepSizeControl(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.resetInternalState();
    }

    public AdaptiveStepsizeIntegrator(String name, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(name);
        this.setStepSizeControl(minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.resetInternalState();
    }

    public void setStepSizeControl(double minimalStep, double maximalStep, double absoluteTolerance, double relativeTolerance) {
        this.minStep = JdkMath.abs((double)minimalStep);
        this.maxStep = JdkMath.abs((double)maximalStep);
        this.initialStep = -1.0;
        this.scalAbsoluteTolerance = absoluteTolerance;
        this.scalRelativeTolerance = relativeTolerance;
        this.vecAbsoluteTolerance = null;
        this.vecRelativeTolerance = null;
    }

    public void setStepSizeControl(double minimalStep, double maximalStep, double[] absoluteTolerance, double[] relativeTolerance) {
        this.minStep = JdkMath.abs((double)minimalStep);
        this.maxStep = JdkMath.abs((double)maximalStep);
        this.initialStep = -1.0;
        this.scalAbsoluteTolerance = 0.0;
        this.scalRelativeTolerance = 0.0;
        this.vecAbsoluteTolerance = (double[])absoluteTolerance.clone();
        this.vecRelativeTolerance = (double[])relativeTolerance.clone();
    }

    public void setInitialStepSize(double initialStepSize) {
        this.initialStep = initialStepSize < this.minStep || initialStepSize > this.maxStep ? -1.0 : initialStepSize;
    }

    @Override
    protected void sanityChecks(ExpandableStatefulODE equations, double t) throws DimensionMismatchException, NumberIsTooSmallException {
        super.sanityChecks(equations, t);
        this.mainSetDimension = equations.getPrimaryMapper().getDimension();
        if (this.vecAbsoluteTolerance != null && this.vecAbsoluteTolerance.length != this.mainSetDimension) {
            throw new DimensionMismatchException(this.mainSetDimension, this.vecAbsoluteTolerance.length);
        }
        if (this.vecRelativeTolerance != null && this.vecRelativeTolerance.length != this.mainSetDimension) {
            throw new DimensionMismatchException(this.mainSetDimension, this.vecRelativeTolerance.length);
        }
    }

    public double initializeStep(boolean forward, int order, double[] scale, double t0, double[] y0, double[] yDot0, double[] y1, double[] yDot1) throws MaxCountExceededException, DimensionMismatchException {
        double h;
        double ratio;
        if (this.initialStep > 0.0) {
            return forward ? this.initialStep : -this.initialStep;
        }
        double yOnScale2 = 0.0;
        double yDotOnScale2 = 0.0;
        for (int j = 0; j < scale.length; ++j) {
            ratio = y0[j] / scale[j];
            yOnScale2 += ratio * ratio;
            ratio = yDot0[j] / scale[j];
            yDotOnScale2 += ratio * ratio;
        }
        double d = h = yOnScale2 < 1.0E-10 || yDotOnScale2 < 1.0E-10 ? 1.0E-6 : 0.01 * JdkMath.sqrt((double)(yOnScale2 / yDotOnScale2));
        if (!forward) {
            h = -h;
        }
        for (int j = 0; j < y0.length; ++j) {
            y1[j] = y0[j] + h * yDot0[j];
        }
        this.computeDerivatives(t0 + h, y1, yDot1);
        double yDDotOnScale = 0.0;
        for (int j = 0; j < scale.length; ++j) {
            ratio = (yDot1[j] - yDot0[j]) / scale[j];
            yDDotOnScale += ratio * ratio;
        }
        yDDotOnScale = JdkMath.sqrt((double)yDDotOnScale) / h;
        double maxInv2 = JdkMath.max((double)JdkMath.sqrt((double)yDotOnScale2), (double)yDDotOnScale);
        double h1 = maxInv2 < 1.0E-15 ? JdkMath.max((double)1.0E-6, (double)(0.001 * JdkMath.abs((double)h))) : JdkMath.pow((double)(0.01 / maxInv2), (double)(1.0 / (double)order));
        h = JdkMath.min((double)(100.0 * JdkMath.abs((double)h)), (double)h1);
        if ((h = JdkMath.max((double)h, (double)(1.0E-12 * JdkMath.abs((double)t0)))) < this.getMinStep()) {
            h = this.getMinStep();
        }
        if (h > this.getMaxStep()) {
            h = this.getMaxStep();
        }
        if (!forward) {
            h = -h;
        }
        return h;
    }

    protected double filterStep(double h, boolean forward, boolean acceptSmall) throws NumberIsTooSmallException {
        double filteredH = h;
        if (JdkMath.abs((double)h) < this.minStep) {
            if (acceptSmall) {
                filteredH = forward ? this.minStep : -this.minStep;
            } else {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.MINIMAL_STEPSIZE_REACHED_DURING_INTEGRATION, (Number)JdkMath.abs((double)h), (Number)this.minStep, true);
            }
        }
        if (filteredH > this.maxStep) {
            filteredH = this.maxStep;
        } else if (filteredH < -this.maxStep) {
            filteredH = -this.maxStep;
        }
        return filteredH;
    }

    @Override
    public abstract void integrate(ExpandableStatefulODE var1, double var2) throws NumberIsTooSmallException, DimensionMismatchException, MaxCountExceededException, NoBracketingException;

    @Override
    public double getCurrentStepStart() {
        return this.stepStart;
    }

    protected void resetInternalState() {
        this.stepStart = Double.NaN;
        this.stepSize = JdkMath.sqrt((double)(this.minStep * this.maxStep));
    }

    public double getMinStep() {
        return this.minStep;
    }

    public double getMaxStep() {
        return this.maxStep;
    }
}

