/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#include <catch2/catch.hpp>
#include <fstream>

#include "tdigest.hpp"

namespace datasketches {

// assume the binary sketches for this test have been generated by datasketches-java code
// in the subdirectory called "java" in the root directory of this project
static std::string testBinaryInputPath = std::string(TEST_BINARY_INPUT_PATH) + "../../java/";

TEST_CASE("tdigest double", "[serde_compat]") {
  const unsigned n_arr[] = {0, 1, 10, 100, 1000, 10000, 100000, 1000000};
  for (const unsigned n: n_arr) {
    std::ifstream is;
    is.exceptions(std::ios::failbit | std::ios::badbit);
    is.open(testBinaryInputPath + "tdigest_double_n" + std::to_string(n) + "_java.sk", std::ios::binary);
    const auto td = tdigest<double>::deserialize(is);
    REQUIRE(td.is_empty() == (n == 0));
    REQUIRE(td.get_total_weight() == n);
    if (n > 0) {
      REQUIRE(td.get_min_value() == 1.0);
      REQUIRE(td.get_max_value() == static_cast<double>(n));
      REQUIRE(td.get_rank(0) == 0);
      REQUIRE(td.get_rank(n + 1) == 1);
      if (n == 1) {
        REQUIRE(td.get_rank(n) == 0.5);
      } else {
        REQUIRE(td.get_rank(n / 2) == Approx(0.5).margin(0.05));
      }
    }
  }
}

} /* namespace datasketches */
