/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hash;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.datasketches.memory.Memory;

public final class MurmurHash3FFM21 {
    private static final long C1 = -8663945395140668459L;
    private static final long C2 = 5545529020109919103L;

    public static long[] hash(long[] in, long seed) {
        if (in == null || in.length == 0) {
            throw new IllegalArgumentException("Input in is empty or null.");
        }
        return MurmurHash3FFM21.hash(MemorySegment.ofArray(in), 0L, (long)(in.length << 3), seed, new long[2]);
    }

    public static long[] hash(int[] in, long seed) {
        if (in == null || in.length == 0) {
            throw new IllegalArgumentException("Input in is empty or null.");
        }
        return MurmurHash3FFM21.hash(MemorySegment.ofArray(in), 0L, (long)(in.length << 2), seed, new long[2]);
    }

    public static long[] hash(char[] in, long seed) {
        if (in == null || in.length == 0) {
            throw new IllegalArgumentException("Input in is empty or null.");
        }
        return MurmurHash3FFM21.hash(MemorySegment.ofArray(in), 0L, (long)(in.length << 1), seed, new long[2]);
    }

    public static long[] hash(byte[] in, long seed) {
        if (in == null || in.length == 0) {
            throw new IllegalArgumentException("Input in is empty or null.");
        }
        return MurmurHash3FFM21.hash(MemorySegment.ofArray(in), 0L, (long)in.length, seed, new long[2]);
    }

    public static long[] hash(long in, long seed, long[] hashOut) {
        long h1 = seed ^ MurmurHash3FFM21.mixK1(in);
        long h2 = seed;
        return MurmurHash3FFM21.finalMix128(h1, h2, 8L, hashOut);
    }

    public static long[] hash(double in, long seed, long[] hashOut) {
        double d = in == 0.0 ? 0.0 : in;
        long k1 = Double.doubleToLongBits(d);
        long h1 = seed ^ MurmurHash3FFM21.mixK1(k1);
        long h2 = seed;
        return MurmurHash3FFM21.finalMix128(h1, h2, 8L, hashOut);
    }

    public static long[] hash(String in, long seed, long[] hashOut) {
        if (in == null || in.length() == 0) {
            throw new IllegalArgumentException("Input in is empty or null.");
        }
        byte[] byteArr = in.getBytes(StandardCharsets.UTF_8);
        return MurmurHash3FFM21.hash(MemorySegment.ofArray(byteArr), 0L, (long)byteArr.length, seed, hashOut);
    }

    public static long[] hash(Memory mem, long offsetBytes, long lengthBytes, long seed, long[] hashOut) {
        Objects.requireNonNull(mem, "Input Memory is null");
        MemorySegment seg = mem.getMemorySegment();
        return MurmurHash3FFM21.hash(seg, offsetBytes, lengthBytes, seed, hashOut);
    }

    public static long[] hash(MemorySegment seg, long offsetBytes, long lengthBytes, long seed, long[] hashOut) {
        long k2;
        long k1;
        Objects.requireNonNull(seg, "Input MemorySegment is null");
        if (seg.byteSize() == 0L) {
            throw new IllegalArgumentException("Input MemorySegment is empty.");
        }
        long cumOff = offsetBytes;
        long h1 = seed;
        long h2 = seed;
        long rem = lengthBytes;
        while (rem >= 16L) {
            k1 = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, cumOff);
            k2 = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, cumOff + 8L);
            cumOff += 16L;
            rem -= 16L;
            h1 ^= MurmurHash3FFM21.mixK1(k1);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            h2 ^= MurmurHash3FFM21.mixK2(k2);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        if (rem > 0L) {
            k1 = 0L;
            k2 = 0L;
            switch ((int)rem) {
                case 15: {
                    k2 ^= ((long)seg.get(ValueLayout.JAVA_BYTE, cumOff + 14L) & 0xFFL) << 48;
                }
                case 14: {
                    k2 ^= ((long)seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, cumOff + 12L) & 0xFFFFL) << 32;
                    k2 ^= (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, cumOff + 8L) & 0xFFFFFFFFL;
                    k1 = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, cumOff);
                    break;
                }
                case 13: {
                    k2 ^= ((long)seg.get(ValueLayout.JAVA_BYTE, cumOff + 12L) & 0xFFL) << 32;
                }
                case 12: {
                    k2 ^= (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, cumOff + 8L) & 0xFFFFFFFFL;
                    k1 = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, cumOff);
                    break;
                }
                case 11: {
                    k2 ^= ((long)seg.get(ValueLayout.JAVA_BYTE, cumOff + 10L) & 0xFFL) << 16;
                }
                case 10: {
                    k2 ^= (long)seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, cumOff + 8L) & 0xFFFFL;
                    k1 = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, cumOff);
                    break;
                }
                case 9: {
                    k2 ^= (long)seg.get(ValueLayout.JAVA_BYTE, cumOff + 8L) & 0xFFL;
                }
                case 8: {
                    k1 = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, cumOff);
                    break;
                }
                case 7: {
                    k1 ^= ((long)seg.get(ValueLayout.JAVA_BYTE, cumOff + 6L) & 0xFFL) << 48;
                }
                case 6: {
                    k1 ^= ((long)seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, cumOff + 4L) & 0xFFFFL) << 32;
                    k1 ^= (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, cumOff) & 0xFFFFFFFFL;
                    break;
                }
                case 5: {
                    k1 ^= ((long)seg.get(ValueLayout.JAVA_BYTE, cumOff + 4L) & 0xFFL) << 32;
                }
                case 4: {
                    k1 ^= (long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, cumOff) & 0xFFFFFFFFL;
                    break;
                }
                case 3: {
                    k1 ^= ((long)seg.get(ValueLayout.JAVA_BYTE, cumOff + 2L) & 0xFFL) << 16;
                }
                case 2: {
                    k1 ^= (long)seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, cumOff) & 0xFFFFL;
                    break;
                }
                case 1: {
                    k1 ^= (long)seg.get(ValueLayout.JAVA_BYTE, cumOff) & 0xFFL;
                    break;
                }
            }
            h1 ^= MurmurHash3FFM21.mixK1(k1);
            h2 ^= MurmurHash3FFM21.mixK2(k2);
        }
        return MurmurHash3FFM21.finalMix128(h1, h2, lengthBytes, hashOut);
    }

    private static long mixK1(long k1) {
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        return k1 *= 5545529020109919103L;
    }

    private static long mixK2(long k2) {
        k2 *= 5545529020109919103L;
        k2 = Long.rotateLeft(k2, 33);
        return k2 *= -8663945395140668459L;
    }

    private static long finalMix64(long h) {
        h ^= h >>> 33;
        h *= -49064778989728563L;
        h ^= h >>> 33;
        h *= -4265267296055464877L;
        h ^= h >>> 33;
        return h;
    }

    private static long[] finalMix128(long h1, long h2, long lengthBytes, long[] hashOut) {
        h1 ^= lengthBytes;
        h1 += (h2 ^= lengthBytes);
        h2 += h1;
        h1 = MurmurHash3FFM21.finalMix64(h1);
        h2 = MurmurHash3FFM21.finalMix64(h2);
        h1 += h2;
        hashOut[0] = h1;
        hashOut[1] = h2 += h1;
        return hashOut;
    }

    private MurmurHash3FFM21() {
    }
}

