/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ToFromByteArrayTest {
    static final int[] nArr = new int[]{1, 3, 10, 30, 100, 300, 1000, 3000, 10000, 30000};

    @Test
    public void checkToFromSketch1() {
        for (int i = 0; i < 10; ++i) {
            int n = nArr[i];
            for (int lgK = 4; lgK <= 13; ++lgK) {
                ToFromByteArrayTest.toFrom1(lgK, TgtHllType.HLL_4, n);
                ToFromByteArrayTest.toFrom1(lgK, TgtHllType.HLL_6, n);
                ToFromByteArrayTest.toFrom1(lgK, TgtHllType.HLL_8, n);
            }
            ToFromByteArrayTest.println("=======");
        }
    }

    private static void toFrom1(int lgConfigK, TgtHllType tgtHllType, int n) {
        HllSketch src = new HllSketch(lgConfigK, tgtHllType);
        for (int i = 0; i < n; ++i) {
            src.update((long)i);
        }
        byte[] byteArr1 = src.toCompactByteArray();
        HllSketch dst = HllSketch.heapify((byte[])byteArr1);
        Assert.assertEquals((double)dst.getEstimate(), (double)src.getEstimate(), (double)0.0);
        byte[] byteArr2 = src.toUpdatableByteArray();
        MemorySegment seg2 = MemorySegment.ofArray(byteArr2);
        HllSketch dst2 = HllSketch.heapify((MemorySegment)seg2);
        Assert.assertEquals((double)dst2.getEstimate(), (double)src.getEstimate(), (double)0.0);
        MemorySegment seg3 = MemorySegment.ofArray(byteArr2);
        HllSketch dst3 = HllSketch.heapify((MemorySegment)seg3);
        Assert.assertEquals((double)dst3.getEstimate(), (double)src.getEstimate(), (double)0.0);
    }

    @Test
    public void checkToFromSketch2() {
        for (int i = 0; i < 10; ++i) {
            int n = nArr[i];
            for (int lgK = 4; lgK <= 13; ++lgK) {
                ToFromByteArrayTest.toFrom2(lgK, TgtHllType.HLL_4, n);
                ToFromByteArrayTest.toFrom2(lgK, TgtHllType.HLL_6, n);
                ToFromByteArrayTest.toFrom2(lgK, TgtHllType.HLL_8, n);
            }
            ToFromByteArrayTest.println("=======");
        }
    }

    private static void toFrom2(int lgConfigK, TgtHllType tgtHllType, int n) {
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgConfigK, (TgtHllType)tgtHllType);
        byte[] byteArray = new byte[bytes];
        MemorySegment wseg = MemorySegment.ofArray(byteArray);
        HllSketch src = new HllSketch(lgConfigK, tgtHllType, wseg);
        for (int i = 0; i < n; ++i) {
            src.update((long)i);
        }
        byte[] compactByteArr = src.toCompactByteArray();
        HllSketch dst = HllSketch.heapify((byte[])compactByteArr);
        Assert.assertEquals((double)dst.getEstimate(), (double)src.getEstimate(), (double)0.0);
        byte[] updatableByteArr = src.toUpdatableByteArray();
        MemorySegment wseg2 = MemorySegment.ofArray(updatableByteArr);
        HllSketch dst2 = HllSketch.heapify((MemorySegment)wseg2);
        Assert.assertEquals((double)dst2.getEstimate(), (double)src.getEstimate(), (double)0.0);
        MemorySegment wseg3 = MemorySegment.ofArray(new byte[bytes]);
        MemorySegment.copy(wseg2, 0L, wseg3, 0L, wseg2.byteSize());
        HllSketch dst3 = HllSketch.writableWrap((MemorySegment)wseg3);
        Assert.assertEquals((double)dst3.getEstimate(), (double)src.getEstimate(), (double)0.0);
        HllSketch dst4 = HllSketch.wrap((MemorySegment)wseg3);
        Assert.assertEquals((double)dst4.getEstimate(), (double)src.getEstimate(), (double)0.0);
    }

    @Test
    public void printlnTest() {
        ToFromByteArrayTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
    }
}

