/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */
 
package org.apache.jdo.tck.pc.fieldtypes;

import java.io.Serializable;

public class FieldsOfPrimitiveint { 
  public int identifier;
  private int int0;
  private int int1;
  private int int2;
  private int int3;
  private int int4;
  private int int5;
  private int int6;
  private int int7;
  private static int int8;
  private transient int int9;
  private transient int int10;
  private transient int int11;
  private transient int int12;
  private transient int int13;
  private transient int int14;
  private final int int15 = 5;
  private volatile int int16;
  private volatile int int17;
  private volatile int int18;
  private volatile int int19;
  private volatile int int20;
  private volatile int int21;
  private volatile int int22;
  private volatile int int23;
  private static transient int int24;
  private static final int int25 = 5;
  private static volatile int int26;
  private transient final int int27 = 5;
  private transient volatile int int28;
  private transient volatile int int29;
  private transient volatile int int30;
  private transient volatile int int31;
  private transient volatile int int32;
  private transient volatile int int33;
  private static transient final int int34 = 5;
  private static transient volatile int int35;
  public int int36;
  public int int37;
  public int int38;
  public int int39;
  public int int40;
  public int int41;
  public int int42;
  public int int43;
  public static int int44;
  public transient int int45;
  public transient int int46;
  public transient int int47;
  public transient int int48;
  public transient int int49;
  public transient int int50;
  public final int int51 = 5;
  public volatile int int52;
  public volatile int int53;
  public volatile int int54;
  public volatile int int55;
  public volatile int int56;
  public volatile int int57;
  public volatile int int58;
  public volatile int int59;
  public static transient int int60;
  public static final int int61 = 5;
  public static volatile int int62;
  public transient final int int63 = 5;
  public transient volatile int int64;
  public transient volatile int int65;
  public transient volatile int int66;
  public transient volatile int int67;
  public transient volatile int int68;
  public transient volatile int int69;
  public static transient final int int70 = 5;
  public static transient volatile int int71;
  protected int int72;
  protected int int73;
  protected int int74;
  protected int int75;
  protected int int76;
  protected int int77;
  protected int int78;
  protected int int79;
  protected static int int80;
  protected transient int int81;
  protected transient int int82;
  protected transient int int83;
  protected transient int int84;
  protected transient int int85;
  protected transient int int86;
  protected final int int87 = 5;
  protected volatile int int88;
  protected volatile int int89;
  protected volatile int int90;
  protected volatile int int91;
  protected volatile int int92;
  protected volatile int int93;
  protected volatile int int94;
  protected volatile int int95;
  protected static transient int int96;
  protected static final int int97 = 5;
  protected static volatile int int98;
  protected transient final int int99 = 5;
  protected transient volatile int int100;
  protected transient volatile int int101;
  protected transient volatile int int102;
  protected transient volatile int int103;
  protected transient volatile int int104;
  protected transient volatile int int105;
  protected static transient final int int106 = 5;
  protected static transient volatile int int107;
  int int108;
  int int109;
  int int110;
  int int111;
  int int112;
  int int113;
  int int114;
  int int115;
  static int int116;
  transient int int117;
  transient int int118;
  transient int int119;
  transient int int120;
  transient int int121;
  transient int int122;
  final int int123 = 5;
  volatile int int124;
  volatile int int125;
  volatile int int126;
  volatile int int127;
  volatile int int128;
  volatile int int129;
  volatile int int130;
  volatile int int131;
  static transient int int132;
  static final int int133 = 5;
  static volatile int int134;
  transient final int int135 = 5;
  transient volatile int int136;
  transient volatile int int137;
  transient volatile int int138;
  transient volatile int int139;
  transient volatile int int140;
  transient volatile int int141;
  static transient final int int142 = 5;
  static transient volatile int int143;

public static final boolean [] isPersistent = { 
true,true,true,false,true,true,true,false,false,false,
false,true,true,true,false,false,true,true,true,false,
true,true,true,false,false,false,false,false,false,false,
true,true,true,false,false,false,true,true,true,false,
true,true,true,false,false,false,false,true,true,true,
false,false,true,true,true,false,true,true,true,false,
false,false,false,false,false,false,true,true,true,false,
false,false,true,true,true,false,true,true,true,false,
false,false,false,true,true,true,false,false,true,true,
true,false,true,true,true,false,false,false,false,false,
false,false,true,true,true,false,false,false,true,true,
true,false,true,true,true,false,false,false,false,true,
true,true,false,false,true,true,true,false,true,true,
true,false,false,false,false,false,false,false,true,true,
true,false,false,false
 };

public static final boolean [] isStatic = { 
false,false,false,false,false,false,false,false,true,false,
false,false,false,false,false,false,false,false,false,false,
false,false,false,false,true,true,true,false,false,false,
false,false,false,false,true,true,false,false,false,false,
false,false,false,false,true,false,false,false,false,false,
false,false,false,false,false,false,false,false,false,false,
true,true,true,false,false,false,false,false,false,false,
true,true,false,false,false,false,false,false,false,false,
true,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,false,true,true,true,false,
false,false,false,false,false,false,true,true,false,false,
false,false,false,false,false,false,true,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,false,true,true,true,false,false,false,false,false,
false,false,true,true
 };

public static final boolean [] isFinal = { 
false,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,true,false,false,false,false,
false,false,false,false,false,true,false,true,false,false,
false,false,false,false,true,false,false,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,true,false,false,false,false,false,false,false,false,
false,true,false,true,false,false,false,false,false,false,
true,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,false,false,true,false,false,
false,false,false,false,false,false,false,true,false,true,
false,false,false,false,false,false,true,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,false,false,true,false,false,false,false,false,false,
false,false,false,true,false,true,false,false,false,false,
false,false,true,false
 };

  public static final String [] fieldSpecs = { 
  "private int int0",
  "embedded= true   private int int1",
  "embedded= false   private int int2",
  "persistence-modifier= none    private int int3",
  "persistence-modifier= persistent    private int int4",
  "persistence-modifier= persistent  embedded= true   private int int5",
  "persistence-modifier= persistent  embedded= false   private int int6",
  "persistence-modifier= transactional    private int int7",
  "private static int int8",
  "private transient int int9",
  "persistence-modifier= none    private transient int int10",
  "persistence-modifier= persistent    private transient int int11",
  "persistence-modifier= persistent  embedded= true   private transient int int12",
  "persistence-modifier= persistent  embedded= false   private transient int int13",
  "persistence-modifier= transactional    private transient int int14",
  "private final int int15",
  "private volatile int int16",
  "embedded= true   private volatile int int17",
  "embedded= false   private volatile int int18",
  "persistence-modifier= none    private volatile int int19",
  "persistence-modifier= persistent    private volatile int int20",
  "persistence-modifier= persistent  embedded= true   private volatile int int21",
  "persistence-modifier= persistent  embedded= false   private volatile int int22",
  "persistence-modifier= transactional    private volatile int int23",
  "private static transient int int24",
  "private static final int int25",
  "private static volatile int int26",
  "private transient final int int27",
  "private transient volatile int int28",
  "persistence-modifier= none    private transient volatile int int29",
  "persistence-modifier= persistent    private transient volatile int int30",
  "persistence-modifier= persistent  embedded= true   private transient volatile int int31",
  "persistence-modifier= persistent  embedded= false   private transient volatile int int32",
  "persistence-modifier= transactional    private transient volatile int int33",
  "private static transient final int int34",
  "private static transient volatile int int35",
  "public int int36",
  "embedded= true   public int int37",
  "embedded= false   public int int38",
  "persistence-modifier= none    public int int39",
  "persistence-modifier= persistent    public int int40",
  "persistence-modifier= persistent  embedded= true   public int int41",
  "persistence-modifier= persistent  embedded= false   public int int42",
  "persistence-modifier= transactional    public int int43",
  "public static int int44",
  "public transient int int45",
  "persistence-modifier= none    public transient int int46",
  "persistence-modifier= persistent    public transient int int47",
  "persistence-modifier= persistent  embedded= true   public transient int int48",
  "persistence-modifier= persistent  embedded= false   public transient int int49",
  "persistence-modifier= transactional    public transient int int50",
  "public final int int51",
  "public volatile int int52",
  "embedded= true   public volatile int int53",
  "embedded= false   public volatile int int54",
  "persistence-modifier= none    public volatile int int55",
  "persistence-modifier= persistent    public volatile int int56",
  "persistence-modifier= persistent  embedded= true   public volatile int int57",
  "persistence-modifier= persistent  embedded= false   public volatile int int58",
  "persistence-modifier= transactional    public volatile int int59",
  "public static transient int int60",
  "public static final int int61",
  "public static volatile int int62",
  "public transient final int int63",
  "public transient volatile int int64",
  "persistence-modifier= none    public transient volatile int int65",
  "persistence-modifier= persistent    public transient volatile int int66",
  "persistence-modifier= persistent  embedded= true   public transient volatile int int67",
  "persistence-modifier= persistent  embedded= false   public transient volatile int int68",
  "persistence-modifier= transactional    public transient volatile int int69",
  "public static transient final int int70",
  "public static transient volatile int int71",
  "protected int int72",
  "embedded= true   protected int int73",
  "embedded= false   protected int int74",
  "persistence-modifier= none    protected int int75",
  "persistence-modifier= persistent    protected int int76",
  "persistence-modifier= persistent  embedded= true   protected int int77",
  "persistence-modifier= persistent  embedded= false   protected int int78",
  "persistence-modifier= transactional    protected int int79",
  "protected static int int80",
  "protected transient int int81",
  "persistence-modifier= none    protected transient int int82",
  "persistence-modifier= persistent    protected transient int int83",
  "persistence-modifier= persistent  embedded= true   protected transient int int84",
  "persistence-modifier= persistent  embedded= false   protected transient int int85",
  "persistence-modifier= transactional    protected transient int int86",
  "protected final int int87",
  "protected volatile int int88",
  "embedded= true   protected volatile int int89",
  "embedded= false   protected volatile int int90",
  "persistence-modifier= none    protected volatile int int91",
  "persistence-modifier= persistent    protected volatile int int92",
  "persistence-modifier= persistent  embedded= true   protected volatile int int93",
  "persistence-modifier= persistent  embedded= false   protected volatile int int94",
  "persistence-modifier= transactional    protected volatile int int95",
  "protected static transient int int96",
  "protected static final int int97",
  "protected static volatile int int98",
  "protected transient final int int99",
  "protected transient volatile int int100",
  "persistence-modifier= none    protected transient volatile int int101",
  "persistence-modifier= persistent    protected transient volatile int int102",
  "persistence-modifier= persistent  embedded= true   protected transient volatile int int103",
  "persistence-modifier= persistent  embedded= false   protected transient volatile int int104",
  "persistence-modifier= transactional    protected transient volatile int int105",
  "protected static transient final int int106",
  "protected static transient volatile int int107",
  "int int108",
  "embedded= true   int int109",
  "embedded= false   int int110",
  "persistence-modifier= none    int int111",
  "persistence-modifier= persistent    int int112",
  "persistence-modifier= persistent  embedded= true   int int113",
  "persistence-modifier= persistent  embedded= false   int int114",
  "persistence-modifier= transactional    int int115",
  "static int int116",
  "transient int int117",
  "persistence-modifier= none    transient int int118",
  "persistence-modifier= persistent    transient int int119",
  "persistence-modifier= persistent  embedded= true   transient int int120",
  "persistence-modifier= persistent  embedded= false   transient int int121",
  "persistence-modifier= transactional    transient int int122",
  "final int int123",
  "volatile int int124",
  "embedded= true   volatile int int125",
  "embedded= false   volatile int int126",
  "persistence-modifier= none    volatile int int127",
  "persistence-modifier= persistent    volatile int int128",
  "persistence-modifier= persistent  embedded= true   volatile int int129",
  "persistence-modifier= persistent  embedded= false   volatile int int130",
  "persistence-modifier= transactional    volatile int int131",
  "static transient int int132",
  "static final int int133",
  "static volatile int int134",
  "transient final int int135",
  "transient volatile int int136",
  "persistence-modifier= none    transient volatile int int137",
  "persistence-modifier= persistent    transient volatile int int138",
  "persistence-modifier= persistent  embedded= true   transient volatile int int139",
  "persistence-modifier= persistent  embedded= false   transient volatile int int140",
  "persistence-modifier= transactional    transient volatile int int141",
  "static transient final int int142",
  "static transient volatile int int143"
  };
  public int getLength()
  {
    return fieldSpecs.length;
  }
  public int get(int index)
  {
    switch (index)
    {
      case(0):
        return int0;
      case(1):
        return int1;
      case(2):
        return int2;
      case(3):
        return int3;
      case(4):
        return int4;
      case(5):
        return int5;
      case(6):
        return int6;
      case(7):
        return int7;
      case(8):
        return int8;
      case(9):
        return int9;
      case(10):
        return int10;
      case(11):
        return int11;
      case(12):
        return int12;
      case(13):
        return int13;
      case(14):
        return int14;
      case(15):
        return int15;
      case(16):
        return int16;
      case(17):
        return int17;
      case(18):
        return int18;
      case(19):
        return int19;
      case(20):
        return int20;
      case(21):
        return int21;
      case(22):
        return int22;
      case(23):
        return int23;
      case(24):
        return int24;
      case(25):
        return int25;
      case(26):
        return int26;
      case(27):
        return int27;
      case(28):
        return int28;
      case(29):
        return int29;
      case(30):
        return int30;
      case(31):
        return int31;
      case(32):
        return int32;
      case(33):
        return int33;
      case(34):
        return int34;
      case(35):
        return int35;
      case(36):
        return int36;
      case(37):
        return int37;
      case(38):
        return int38;
      case(39):
        return int39;
      case(40):
        return int40;
      case(41):
        return int41;
      case(42):
        return int42;
      case(43):
        return int43;
      case(44):
        return int44;
      case(45):
        return int45;
      case(46):
        return int46;
      case(47):
        return int47;
      case(48):
        return int48;
      case(49):
        return int49;
      case(50):
        return int50;
      case(51):
        return int51;
      case(52):
        return int52;
      case(53):
        return int53;
      case(54):
        return int54;
      case(55):
        return int55;
      case(56):
        return int56;
      case(57):
        return int57;
      case(58):
        return int58;
      case(59):
        return int59;
      case(60):
        return int60;
      case(61):
        return int61;
      case(62):
        return int62;
      case(63):
        return int63;
      case(64):
        return int64;
      case(65):
        return int65;
      case(66):
        return int66;
      case(67):
        return int67;
      case(68):
        return int68;
      case(69):
        return int69;
      case(70):
        return int70;
      case(71):
        return int71;
      case(72):
        return int72;
      case(73):
        return int73;
      case(74):
        return int74;
      case(75):
        return int75;
      case(76):
        return int76;
      case(77):
        return int77;
      case(78):
        return int78;
      case(79):
        return int79;
      case(80):
        return int80;
      case(81):
        return int81;
      case(82):
        return int82;
      case(83):
        return int83;
      case(84):
        return int84;
      case(85):
        return int85;
      case(86):
        return int86;
      case(87):
        return int87;
      case(88):
        return int88;
      case(89):
        return int89;
      case(90):
        return int90;
      case(91):
        return int91;
      case(92):
        return int92;
      case(93):
        return int93;
      case(94):
        return int94;
      case(95):
        return int95;
      case(96):
        return int96;
      case(97):
        return int97;
      case(98):
        return int98;
      case(99):
        return int99;
      case(100):
        return int100;
      case(101):
        return int101;
      case(102):
        return int102;
      case(103):
        return int103;
      case(104):
        return int104;
      case(105):
        return int105;
      case(106):
        return int106;
      case(107):
        return int107;
      case(108):
        return int108;
      case(109):
        return int109;
      case(110):
        return int110;
      case(111):
        return int111;
      case(112):
        return int112;
      case(113):
        return int113;
      case(114):
        return int114;
      case(115):
        return int115;
      case(116):
        return int116;
      case(117):
        return int117;
      case(118):
        return int118;
      case(119):
        return int119;
      case(120):
        return int120;
      case(121):
        return int121;
      case(122):
        return int122;
      case(123):
        return int123;
      case(124):
        return int124;
      case(125):
        return int125;
      case(126):
        return int126;
      case(127):
        return int127;
      case(128):
        return int128;
      case(129):
        return int129;
      case(130):
        return int130;
      case(131):
        return int131;
      case(132):
        return int132;
      case(133):
        return int133;
      case(134):
        return int134;
      case(135):
        return int135;
      case(136):
        return int136;
      case(137):
        return int137;
      case(138):
        return int138;
      case(139):
        return int139;
      case(140):
        return int140;
      case(141):
        return int141;
      case(142):
        return int142;
      case(143):
        return int143;
      default:
        throw new IndexOutOfBoundsException();
    }
  }
  public boolean set(int index,int value)
  {
    if(fieldSpecs[index].indexOf("final") != -1)
      return false;
    switch (index)
    {
      case(0):
        int0= value;
         break;
      case(1):
        int1= value;
         break;
      case(2):
        int2= value;
         break;
      case(3):
        int3= value;
         break;
      case(4):
        int4= value;
         break;
      case(5):
        int5= value;
         break;
      case(6):
        int6= value;
         break;
      case(7):
        int7= value;
         break;
      case(8):
        int8= value;
         break;
      case(9):
        int9= value;
         break;
      case(10):
        int10= value;
         break;
      case(11):
        int11= value;
         break;
      case(12):
        int12= value;
         break;
      case(13):
        int13= value;
         break;
      case(14):
        int14= value;
         break;
      case(16):
        int16= value;
         break;
      case(17):
        int17= value;
         break;
      case(18):
        int18= value;
         break;
      case(19):
        int19= value;
         break;
      case(20):
        int20= value;
         break;
      case(21):
        int21= value;
         break;
      case(22):
        int22= value;
         break;
      case(23):
        int23= value;
         break;
      case(24):
        int24= value;
         break;
      case(26):
        int26= value;
         break;
      case(28):
        int28= value;
         break;
      case(29):
        int29= value;
         break;
      case(30):
        int30= value;
         break;
      case(31):
        int31= value;
         break;
      case(32):
        int32= value;
         break;
      case(33):
        int33= value;
         break;
      case(35):
        int35= value;
         break;
      case(36):
        int36= value;
         break;
      case(37):
        int37= value;
         break;
      case(38):
        int38= value;
         break;
      case(39):
        int39= value;
         break;
      case(40):
        int40= value;
         break;
      case(41):
        int41= value;
         break;
      case(42):
        int42= value;
         break;
      case(43):
        int43= value;
         break;
      case(44):
        int44= value;
         break;
      case(45):
        int45= value;
         break;
      case(46):
        int46= value;
         break;
      case(47):
        int47= value;
         break;
      case(48):
        int48= value;
         break;
      case(49):
        int49= value;
         break;
      case(50):
        int50= value;
         break;
      case(52):
        int52= value;
         break;
      case(53):
        int53= value;
         break;
      case(54):
        int54= value;
         break;
      case(55):
        int55= value;
         break;
      case(56):
        int56= value;
         break;
      case(57):
        int57= value;
         break;
      case(58):
        int58= value;
         break;
      case(59):
        int59= value;
         break;
      case(60):
        int60= value;
         break;
      case(62):
        int62= value;
         break;
      case(64):
        int64= value;
         break;
      case(65):
        int65= value;
         break;
      case(66):
        int66= value;
         break;
      case(67):
        int67= value;
         break;
      case(68):
        int68= value;
         break;
      case(69):
        int69= value;
         break;
      case(71):
        int71= value;
         break;
      case(72):
        int72= value;
         break;
      case(73):
        int73= value;
         break;
      case(74):
        int74= value;
         break;
      case(75):
        int75= value;
         break;
      case(76):
        int76= value;
         break;
      case(77):
        int77= value;
         break;
      case(78):
        int78= value;
         break;
      case(79):
        int79= value;
         break;
      case(80):
        int80= value;
         break;
      case(81):
        int81= value;
         break;
      case(82):
        int82= value;
         break;
      case(83):
        int83= value;
         break;
      case(84):
        int84= value;
         break;
      case(85):
        int85= value;
         break;
      case(86):
        int86= value;
         break;
      case(88):
        int88= value;
         break;
      case(89):
        int89= value;
         break;
      case(90):
        int90= value;
         break;
      case(91):
        int91= value;
         break;
      case(92):
        int92= value;
         break;
      case(93):
        int93= value;
         break;
      case(94):
        int94= value;
         break;
      case(95):
        int95= value;
         break;
      case(96):
        int96= value;
         break;
      case(98):
        int98= value;
         break;
      case(100):
        int100= value;
         break;
      case(101):
        int101= value;
         break;
      case(102):
        int102= value;
         break;
      case(103):
        int103= value;
         break;
      case(104):
        int104= value;
         break;
      case(105):
        int105= value;
         break;
      case(107):
        int107= value;
         break;
      case(108):
        int108= value;
         break;
      case(109):
        int109= value;
         break;
      case(110):
        int110= value;
         break;
      case(111):
        int111= value;
         break;
      case(112):
        int112= value;
         break;
      case(113):
        int113= value;
         break;
      case(114):
        int114= value;
         break;
      case(115):
        int115= value;
         break;
      case(116):
        int116= value;
         break;
      case(117):
        int117= value;
         break;
      case(118):
        int118= value;
         break;
      case(119):
        int119= value;
         break;
      case(120):
        int120= value;
         break;
      case(121):
        int121= value;
         break;
      case(122):
        int122= value;
         break;
      case(124):
        int124= value;
         break;
      case(125):
        int125= value;
         break;
      case(126):
        int126= value;
         break;
      case(127):
        int127= value;
         break;
      case(128):
        int128= value;
         break;
      case(129):
        int129= value;
         break;
      case(130):
        int130= value;
         break;
      case(131):
        int131= value;
         break;
      case(132):
        int132= value;
         break;
      case(134):
        int134= value;
         break;
      case(136):
        int136= value;
         break;
      case(137):
        int137= value;
         break;
      case(138):
        int138= value;
         break;
      case(139):
        int139= value;
         break;
      case(140):
        int140= value;
         break;
      case(141):
        int141= value;
         break;
      case(143):
        int143= value;
         break;
      default:
        throw new IndexOutOfBoundsException();
    }
    return true;
  }

    public static class Oid implements Serializable {
        public int identifier;

        public Oid() {
        }

        public Oid(String s) { identifier = Integer.parseInt(justTheId(s)); }

        public String toString() { return this.getClass().getName() + ": "  + identifier;}

        public int hashCode() { return (int)identifier ; }

        public boolean equals(Object other) {
            if (other != null && (other instanceof Oid)) {
                Oid k = (Oid)other;
                return k.identifier == this.identifier;
            }
            return false;
        }
        
        protected static String justTheId(String str) {
            return str.substring(str.indexOf(':') + 1);
        }

    }   
}
