/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Chars;
import org.apache.directory.api.util.Strings;

public final class OidSyntaxChecker
extends SyntaxChecker {
    public static final OidSyntaxChecker INSTANCE = new OidSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.38");

    private OidSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
            }
            return false;
        }
        if (Chars.isDigit(strValue.charAt(0))) {
            boolean result = Oid.isOid(strValue);
            if (LOG.isDebugEnabled()) {
                if (result) {
                    LOG.debug(I18n.msg(I18n.MSG_04489_SYNTAX_VALID, value));
                } else {
                    LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
                }
            }
            return result;
        }
        if (Chars.isAlphaASCII(strValue, 0)) {
            for (int index = 0; index < strValue.length(); ++index) {
                char c = strValue.charAt(index);
                if (Chars.isAlphaDigitMinus(c)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04489_SYNTAX_VALID, value));
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
        }
        return false;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<OidSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.38");
        }

        @Override
        public OidSyntaxChecker build() {
            return new OidSyntaxChecker(this.oid);
        }
    }
}

