/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.search.persistentSearch;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.AbstractControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.controls.search.persistentSearch.PersistentSearchContainer;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.controls.PersistentSearch;
import org.apache.directory.api.ldap.model.message.controls.PersistentSearchImpl;

public class PersistentSearchFactory
extends AbstractControlFactory<PersistentSearch> {
    public PersistentSearchFactory(LdapApiService codec) {
        super(codec, "2.16.840.1.113730.3.4.3");
    }

    @Override
    public PersistentSearch newControl() {
        return new PersistentSearchImpl();
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, Control control) {
        PersistentSearch persistentSearch = (PersistentSearch)control;
        int start = buffer.getPos();
        BerValue.encodeBoolean(buffer, persistentSearch.isReturnECs());
        BerValue.encodeBoolean(buffer, persistentSearch.isChangesOnly());
        BerValue.encodeInteger(buffer, persistentSearch.getChangeTypes());
        BerValue.encodeSequence(buffer, start);
    }

    @Override
    public void decodeValue(Control control, byte[] controlBytes) throws DecoderException {
        this.decodeValue(new PersistentSearchContainer(control), control, controlBytes);
    }
}

