/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.model.literal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.manipulator.metadata.annotation.model.AnnotationDiscovery;
import org.apache.felix.ipojo.manipulator.metadata.annotation.model.Playback;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class AnnotationPlayback
implements Playback {
    public static final List<? extends Class<? extends Serializable>> BOXED_TYPES = Arrays.asList(Byte.class, Long.class, Character.class, Boolean.class, Double.class, Float.class, Integer.class, Short.class);
    private final Annotation m_annotation;
    private final Type m_annotationType;

    public AnnotationPlayback(Annotation annotation) {
        this.m_annotation = annotation;
        this.m_annotationType = Type.getType(annotation.annotationType());
    }

    private Map<String, Object> getValues() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Method method : this.m_annotation.annotationType().getDeclaredMethods()) {
            try {
                values.put(method.getName(), method.invoke((Object)this.m_annotation, new Object[0]));
            }
            catch (Throwable t) {
                throw new IllegalStateException(String.format("Cannot get value of the %s.%s attribute", this.m_annotation.annotationType().getSimpleName(), method.getName()), t);
            }
        }
        return values;
    }

    @Override
    public void accept(FieldVisitor visitor) {
        AnnotationVisitor av = visitor.visitAnnotation(this.m_annotationType.getDescriptor(), true);
        if (av != null) {
            this.accept(av);
        }
    }

    @Override
    public void accept(ClassVisitor visitor) {
        AnnotationVisitor av = visitor.visitAnnotation(this.m_annotationType.getDescriptor(), true);
        if (av != null) {
            this.accept(av);
        }
    }

    @Override
    public void accept(MethodVisitor visitor) {
        AnnotationVisitor av = visitor.visitAnnotation(this.m_annotationType.getDescriptor(), true);
        if (av != null) {
            this.accept(av);
        }
    }

    @Override
    public void accept(MethodVisitor visitor, int index) {
        AnnotationVisitor av = visitor.visitParameterAnnotation(index, this.m_annotationType.getDescriptor(), true);
        if (av != null) {
            this.accept(av);
        }
    }

    @Override
    public void accept(AnnotationDiscovery visitor) {
        AnnotationVisitor av = visitor.visitAnnotation(this.m_annotationType.getDescriptor());
        if (av != null) {
            this.accept(av);
        }
    }

    private void accept(AnnotationVisitor visitor) {
        Map<String, Object> values = this.getValues();
        this.accept(values, visitor);
        this.acceptEnum(values, visitor);
        this.acceptAnnotation(values, visitor);
        this.acceptArray(values, visitor);
        visitor.visitEnd();
        if (!values.isEmpty()) {
            throw new IllegalStateException(String.format("Attributes of @%s could not be serialized: %s", this.m_annotation.annotationType().getSimpleName(), values.keySet()));
        }
    }

    private void acceptAnnotation(Map<String, Object> values, AnnotationVisitor visitor) {
        HashMap<String, Object> copy = new HashMap<String, Object>(values);
        for (Map.Entry entry : copy.entrySet()) {
            Class<?> type = entry.getValue().getClass();
            if (!Annotation.class.isAssignableFrom(type)) continue;
            Annotation annotation = (Annotation)entry.getValue();
            AnnotationVisitor annotationVisitor = visitor.visitAnnotation((String)entry.getKey(), Type.getType(annotation.annotationType()).getDescriptor());
            if (annotationVisitor != null) {
                AnnotationPlayback playback = new AnnotationPlayback(annotation);
                playback.accept(annotationVisitor);
            }
            values.remove(entry.getKey());
        }
    }

    private void acceptEnum(Map<String, Object> values, AnnotationVisitor visitor) {
        HashMap<String, Object> copy = new HashMap<String, Object>(values);
        for (Map.Entry entry : copy.entrySet()) {
            Class<?> type = entry.getValue().getClass();
            if (!type.isEnum()) continue;
            Enum enumValue = (Enum)entry.getValue();
            visitor.visitEnum((String)entry.getKey(), Type.getType(type).getDescriptor(), enumValue.name());
            values.remove(entry.getKey());
        }
    }

    private void accept(Map<String, Object> values, AnnotationVisitor visitor) {
        HashMap<String, Object> copy = new HashMap<String, Object>(values);
        for (Map.Entry entry : copy.entrySet()) {
            Class<?> type = entry.getValue().getClass();
            if (!this.isSimpleType(type)) continue;
            visitor.visit((String)entry.getKey(), this.transform(entry.getValue()));
            values.remove(entry.getKey());
        }
    }

    private boolean isSimpleType(Class<?> type) {
        return this.isPrimitive(type) || String.class.equals(type) || Class.class.equals(type) || type.isArray() && this.isPrimitive(type.getComponentType());
    }

    private boolean isPrimitive(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        return BOXED_TYPES.contains(type);
    }

    private void acceptArray(Map<String, Object> values, AnnotationVisitor visitor) {
        HashMap<String, Object> copy = new HashMap<String, Object>(values);
        for (Map.Entry entry : copy.entrySet()) {
            Class<?> type = entry.getValue().getClass();
            if (!type.isArray()) continue;
            AnnotationVisitor arrayVisitor = visitor.visitArray((String)entry.getKey());
            if (arrayVisitor != null) {
                Object[] array = (Object[])entry.getValue();
                Class<?> componentType = array.getClass().getComponentType();
                Type asmType = Type.getType(componentType);
                if (componentType.isEnum()) {
                    for (Object o : array) {
                        Enum eValue = (Enum)o;
                        arrayVisitor.visitEnum(null, asmType.getDescriptor(), eValue.name());
                    }
                } else if (componentType.isAnnotation()) {
                    for (Object o : array) {
                        Annotation annotation = (Annotation)o;
                        AnnotationVisitor annotationVisitor = arrayVisitor.visitAnnotation(null, asmType.getDescriptor());
                        if (annotationVisitor == null) continue;
                        AnnotationPlayback playback = new AnnotationPlayback(annotation);
                        playback.accept(annotationVisitor);
                    }
                } else {
                    for (Object o : array) {
                        arrayVisitor.visit(null, this.transform(o));
                    }
                }
                arrayVisitor.visitEnd();
            }
            values.remove(entry.getKey());
        }
    }

    private Object transform(Object value) {
        if (value instanceof Class) {
            return Type.getType((Class)value);
        }
        return value;
    }
}

