/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.registry;

import java.util.List;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.metadata.annotation.ComponentWorkbench;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.Binding;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.BindingRegistry;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.Selection;
import org.objectweb.asm.Type;

public abstract class CompletableBindingRegistry
implements BindingRegistry {
    private final BindingRegistry m_delegate;
    private final Reporter m_reporter;

    public CompletableBindingRegistry(BindingRegistry delegate, Reporter reporter) {
        this.m_delegate = delegate;
        this.m_reporter = reporter;
    }

    @Override
    public List<Binding> getBindings(String descriptor) {
        List<Binding> bindings = this.m_delegate.getBindings(descriptor);
        if (bindings.isEmpty()) {
            List<Binding> ignored = this.createBindings(Type.getType(descriptor));
            this.m_delegate.addBindings(ignored);
            return ignored;
        }
        return bindings;
    }

    protected abstract List<Binding> createBindings(Type var1);

    @Override
    public void addBindings(Iterable<Binding> bindings) {
        this.m_delegate.addBindings(bindings);
    }

    @Override
    public Selection selection(ComponentWorkbench workbench) {
        return new Selection(this, workbench, this.m_reporter);
    }
}

