/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.types.files;

import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.server.types.CustomizableResponseTypeException;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;

public class StreamedFile
implements FileCustomizableResponseType {
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private final MediaType mediaType;
    private final String name;
    private final long lastModified;
    private final InputStream inputStream;
    private final long length;
    private String attachmentName;

    public StreamedFile(InputStream inputStream, MediaType mediaType) {
        this(inputStream, mediaType, Instant.now().toEpochMilli());
    }

    public StreamedFile(InputStream inputStream, MediaType mediaType, long lastModified) {
        this(inputStream, mediaType, lastModified, -1L);
    }

    public StreamedFile(InputStream inputStream, MediaType mediaType, long lastModified, long contentLength) {
        this.mediaType = mediaType;
        this.name = null;
        this.lastModified = lastModified;
        this.inputStream = inputStream;
        this.length = contentLength;
    }

    public StreamedFile(URL url) {
        String path = url.getPath();
        int idx = path.lastIndexOf(File.separatorChar);
        this.name = idx > -1 ? path.substring(idx + 1) : path;
        this.mediaType = MediaType.forFilename((String)this.name);
        try {
            URLConnection con = url.openConnection();
            this.lastModified = con.getLastModified();
            this.inputStream = con.getInputStream();
            this.length = con.getContentLengthLong();
        }
        catch (IOException e) {
            throw new CustomizableResponseTypeException("Could not open a connection to the URL: " + path, e);
        }
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public StreamedFile attach(String attachmentName) {
        this.attachmentName = attachmentName;
        return this;
    }

    @Override
    public void process(MutableHttpResponse<?> response) {
        if (this.attachmentName != null) {
            response.header((CharSequence)"Content-Disposition", (CharSequence)StreamedFile.buildAttachmentHeader(this.attachmentName));
        }
    }

    static String buildAttachmentHeader(String attachmentName) {
        return "attachment; filename=\"" + StreamedFile.sanitizeAscii(attachmentName) + "\"; filename*=utf-8''" + StreamedFile.encodeRfc6987(attachmentName);
    }

    private static String sanitizeAscii(String s) {
        StringBuilder builder = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < ' ' || c >= '\u007f' || c == '\"') continue;
            builder.append(c);
        }
        return builder.toString();
    }

    static String encodeRfc6987(String s) {
        StringBuilder uriBuilder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                if (StreamedFile.dontNeedEncoding(c)) {
                    uriBuilder.append(c);
                    continue;
                }
                StreamedFile.appendEncoded(uriBuilder, c);
                continue;
            }
            if (c < '\u0800') {
                StreamedFile.appendEncoded(uriBuilder, 0xC0 | c >> 6);
                StreamedFile.appendEncoded(uriBuilder, 0x80 | c & 0x3F);
                continue;
            }
            if (Character.isSurrogate(c)) {
                if (!Character.isHighSurrogate(c)) {
                    StreamedFile.appendEncoded(uriBuilder, 63);
                    continue;
                }
                if (++i == s.length()) {
                    StreamedFile.appendEncoded(uriBuilder, 63);
                    break;
                }
                StreamedFile.writeUtf8Surrogate(uriBuilder, c, s.charAt(i));
                continue;
            }
            StreamedFile.appendEncoded(uriBuilder, 0xE0 | c >> 12);
            StreamedFile.appendEncoded(uriBuilder, 0x80 | c >> 6 & 0x3F);
            StreamedFile.appendEncoded(uriBuilder, 0x80 | c & 0x3F);
        }
        return uriBuilder.toString();
    }

    private static boolean dontNeedEncoding(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '_' || ch == '.' || ch == '*' || ch == '~';
    }

    private static void appendEncoded(StringBuilder uriBuilder, int b) {
        uriBuilder.append('%').append(HEX_DIGITS[b >> 4 & 0xF]).append(HEX_DIGITS[b & 0xF]);
    }

    private static void writeUtf8Surrogate(StringBuilder uriBuilder, char c, char c2) {
        if (!Character.isLowSurrogate(c2)) {
            StreamedFile.appendEncoded(uriBuilder, 63);
            StreamedFile.appendEncoded(uriBuilder, Character.isHighSurrogate(c2) ? 63 : (int)c2);
            return;
        }
        int codePoint = Character.toCodePoint(c, c2);
        StreamedFile.appendEncoded(uriBuilder, 0xF0 | codePoint >> 18);
        StreamedFile.appendEncoded(uriBuilder, 0x80 | codePoint >> 12 & 0x3F);
        StreamedFile.appendEncoded(uriBuilder, 0x80 | codePoint >> 6 & 0x3F);
        StreamedFile.appendEncoded(uriBuilder, 0x80 | codePoint & 0x3F);
    }
}

