/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import java.util.List;
import java.util.Objects;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.catalog.descriptors.CatalogColumnContainer;
import org.apache.ignite3.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tostring.S;

public class CatalogSystemViewDescriptor
extends CatalogObjectDescriptor
implements MarshallableEntry,
CatalogColumnContainer {
    private final int schemaId;
    private final List<CatalogTableColumnDescriptor> columns;
    private final SystemViewType systemViewType;

    public CatalogSystemViewDescriptor(int id, int schemaId, String name, List<CatalogTableColumnDescriptor> columns, SystemViewType systemViewType) {
        this(id, schemaId, name, columns, systemViewType, CatalogManager.INITIAL_TIMESTAMP);
    }

    public CatalogSystemViewDescriptor(int id, int schemaId, String name, List<CatalogTableColumnDescriptor> columns, SystemViewType systemViewType, HybridTimestamp timestamp) {
        super(id, CatalogObjectDescriptor.Type.SYSTEM_VIEW, name, timestamp);
        this.schemaId = schemaId;
        this.columns = Objects.requireNonNull(columns, "columns");
        this.systemViewType = Objects.requireNonNull(systemViewType, "viewType");
    }

    public int schemaId() {
        return this.schemaId;
    }

    @Override
    public List<CatalogTableColumnDescriptor> columns() {
        return this.columns;
    }

    public SystemViewType systemViewType() {
        return this.systemViewType;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DESCRIPTOR_SYSTEM_VIEW.id();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogSystemViewDescriptor that = (CatalogSystemViewDescriptor)o;
        return this.schemaId == that.schemaId && Objects.equals(this.columns, that.columns) && this.systemViewType == that.systemViewType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schemaId, this.columns, this.systemViewType});
    }

    @Override
    public String toString() {
        return S.toString(CatalogSystemViewDescriptor.class, this, "id", (Object)this.id(), "schemaId", (Object)this.schemaId, "name", (Object)this.name(), "columns", this.columns, "systemViewType", (Object)this.systemViewType());
    }

    public static enum SystemViewType {
        NODE(0),
        CLUSTER(1);

        private final int id;

        private SystemViewType(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        static SystemViewType forId(int id) {
            switch (id) {
                case 0: {
                    return NODE;
                }
                case 1: {
                    return CLUSTER;
                }
            }
            throw new IllegalArgumentException("Unknown system view type id: " + id);
        }
    }
}

