/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client.compute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite3.compute.JobState;
import org.apache.ignite3.compute.TaskState;
import org.apache.ignite3.compute.task.TaskExecution;
import org.apache.ignite3.internal.client.PayloadInputChannel;
import org.apache.ignite3.internal.client.ReliableChannel;
import org.apache.ignite3.internal.client.compute.ClientJobExecution;
import org.apache.ignite3.internal.client.compute.SubmitResult;
import org.apache.ignite3.internal.client.compute.SubmitTaskResult;
import org.apache.ignite3.internal.client.proto.ClientComputeJobUnpacker;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.marshalling.Marshaller;
import org.jetbrains.annotations.Nullable;

class ClientTaskExecution<R>
implements TaskExecution<R> {
    private final ReliableChannel ch;
    private final CompletableFuture<UUID> jobIdFuture;
    private final CompletableFuture<List<@Nullable UUID>> jobIdsFuture;
    private final CompletableFuture<R> resultAsync;
    private final CompletableFuture<@Nullable TaskState> stateFuture = new CompletableFuture();
    private final CompletableFuture<List<@Nullable JobState>> statesFutures = new CompletableFuture();

    ClientTaskExecution(ReliableChannel ch, CompletableFuture<SubmitTaskResult> reqFuture, Marshaller<R, byte[]> resultMarshaller, Class<?> resultClass) {
        this.ch = ch;
        this.jobIdFuture = reqFuture.thenApply(SubmitResult::jobId);
        this.jobIdsFuture = reqFuture.thenApply(SubmitTaskResult::jobIds);
        this.resultAsync = ((CompletableFuture)reqFuture.thenCompose(SubmitResult::notificationFuture)).thenApply(payloadInputChannel -> {
            try (PayloadInputChannel payloadInputChannel2 = payloadInputChannel;){
                Object result = ClientComputeJobUnpacker.unpackJobResult(payloadInputChannel.in(), resultMarshaller, resultClass);
                this.stateFuture.complete(ClientJobExecution.unpackTaskState(payloadInputChannel));
                this.statesFutures.complete(ClientTaskExecution.unpackJobStates(payloadInputChannel));
                Object object = result;
                return object;
            }
        });
    }

    @Override
    public CompletableFuture<R> resultAsync() {
        return this.resultAsync;
    }

    @Override
    public CompletableFuture<@Nullable TaskState> stateAsync() {
        if (this.stateFuture.isDone()) {
            return this.stateFuture;
        }
        return this.jobIdFuture.thenCompose(jobId -> ClientJobExecution.getTaskState(this.ch, jobId));
    }

    public CompletableFuture<@Nullable Boolean> cancelAsync() {
        if (this.stateFuture.isDone()) {
            return CompletableFutures.falseCompletedFuture();
        }
        return this.jobIdFuture.thenCompose(jobId -> ClientJobExecution.cancelJob(this.ch, jobId));
    }

    @Override
    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        if (this.stateFuture.isDone()) {
            return CompletableFutures.falseCompletedFuture();
        }
        return this.jobIdFuture.thenCompose(jobId -> ClientJobExecution.changePriority(this.ch, jobId, newPriority));
    }

    @Override
    public CompletableFuture<List<@Nullable JobState>> statesAsync() {
        if (this.statesFutures.isDone()) {
            return this.statesFutures;
        }
        return this.jobIdsFuture.thenCompose(ids -> {
            @Nullable CompletableFuture[] futures = (CompletableFuture[])ids.stream().map(jobId -> ClientJobExecution.getJobState(this.ch, jobId)).toArray(CompletableFuture[]::new);
            return CompletableFutures.allOfToList(futures).thenApply(Function.identity());
        });
    }

    private static List<@Nullable JobState> unpackJobStates(PayloadInputChannel payloadInputChannel) {
        ClientMessageUnpacker unpacker = payloadInputChannel.in();
        int size = unpacker.unpackInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<JobState> states = new ArrayList<JobState>(size);
        for (int i = 0; i < size; ++i) {
            states.add(ClientJobExecution.unpackJobState(payloadInputChannel));
        }
        return Collections.unmodifiableList(states);
    }
}

