/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite3.compute.JobExecution;
import org.apache.ignite3.compute.JobState;
import org.apache.ignite3.internal.thread.PublicApiThreading;
import org.apache.ignite3.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class AntiHijackJobExecution<R>
implements JobExecution<R> {
    private final JobExecution<R> execution;
    private final Executor asyncContinuationExecutor;

    public AntiHijackJobExecution(JobExecution<R> execution, Executor asyncContinuationExecutor) {
        this.execution = execution;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    @Override
    public CompletableFuture<R> resultAsync() {
        return this.preventThreadHijack(this.execution.resultAsync());
    }

    @Override
    public CompletableFuture<@Nullable JobState> stateAsync() {
        return this.preventThreadHijack(this.execution.stateAsync());
    }

    @Override
    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return this.preventThreadHijack(this.execution.changePriorityAsync(newPriority));
    }

    @Override
    public ClusterNode node() {
        return this.execution.node();
    }

    private <T> CompletableFuture<T> preventThreadHijack(CompletableFuture<T> originalFuture) {
        return PublicApiThreading.preventThreadHijack(originalFuture, this.asyncContinuationExecutor);
    }
}

