/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite3.configuration.ConfigurationModule;
import org.apache.ignite3.configuration.annotation.ConfigurationType;
import org.apache.ignite3.internal.configuration.CompoundModule;

public class ConfigurationModules {
    private final CompoundModule localCompound;
    private final CompoundModule distributedCompound;

    public ConfigurationModules(List<ConfigurationModule> modules) {
        this.localCompound = ConfigurationModules.compoundOfType(ConfigurationType.LOCAL, modules);
        this.distributedCompound = ConfigurationModules.compoundOfType(ConfigurationType.DISTRIBUTED, modules);
    }

    public ConfigurationModule local() {
        return this.localCompound;
    }

    public ConfigurationModule distributed() {
        return this.distributedCompound;
    }

    private static CompoundModule compoundOfType(ConfigurationType type, Collection<ConfigurationModule> modules) {
        List<ConfigurationModule> modulesOfGivenType = modules.stream().filter(module -> module.type() == type).collect(Collectors.toUnmodifiableList());
        return new CompoundModule(type, modulesOfGivenType);
    }
}

