/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.prepare;

import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.ignite3.internal.sql.engine.externalize.RelJsonWriter;
import org.apache.ignite3.internal.sql.engine.rel.IgniteReceiver;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite3.internal.sql.engine.schema.IgniteSystemView;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite3.internal.tostring.IgniteToStringExclude;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class Fragment {
    private final long id;
    private final IgniteRel root;
    @IgniteToStringExclude
    private final String rootSer;
    private final List<IgniteReceiver> remotes;
    private final Long2ObjectMap<IgniteTable> tables;
    private final List<IgniteSystemView> systemViews;
    private final boolean correlated;

    public Fragment(long id, boolean correlated, IgniteRel root, List<IgniteReceiver> remotes, Long2ObjectMap<IgniteTable> tables, List<IgniteSystemView> systemViews) {
        this.id = id;
        this.root = root;
        this.remotes = List.copyOf(remotes);
        this.tables = new Long2ObjectArrayMap(tables);
        this.systemViews = List.copyOf(systemViews);
        this.rootSer = RelJsonWriter.toJson((RelNode)root);
        this.correlated = correlated;
    }

    public long fragmentId() {
        return this.id;
    }

    public IgniteRel root() {
        return this.root;
    }

    public String serialized() {
        return this.rootSer;
    }

    public boolean correlated() {
        return this.correlated;
    }

    public List<IgniteReceiver> remotes() {
        return this.remotes;
    }

    public Long2ObjectMap<IgniteTable> tables() {
        return this.tables;
    }

    public List<IgniteSystemView> systemViews() {
        return this.systemViews;
    }

    public boolean rootFragment() {
        return !(this.root instanceof IgniteSender);
    }

    @Nullable
    public Long targetFragmentId() {
        if (this.root instanceof IgniteSender) {
            return ((IgniteSender)this.root).targetFragmentId();
        }
        return null;
    }

    public boolean single() {
        return this.rootFragment() || this.root instanceof IgniteSender && ((IgniteSender)this.root).sourceDistribution().satisfies((RelTrait)IgniteDistributions.single());
    }

    public String toString() {
        return S.toString(Fragment.class, this, "root", (Object)RelOptUtil.toString((RelNode)this.root));
    }
}

