/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.ignite3.configuration.NamedListView;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.hlc.HybridClock;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite3.internal.storage.configurations.StorageProfileView;
import org.apache.ignite3.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite3.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite3.internal.storage.pagememory.AbstractPageMemoryStorageEngine;
import org.apache.ignite3.internal.storage.pagememory.VolatilePageMemoryDataRegion;
import org.apache.ignite3.internal.storage.pagememory.VolatilePageMemoryTableStorage;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.VolatilePageMemoryProfileConfiguration;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.VolatilePageMemoryProfileView;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.VolatilePageMemoryStorageEngineConfiguration;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.VolatilePageMemoryStorageEngineExtensionConfiguration;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.util.IgniteUtils;

public class VolatilePageMemoryStorageEngine
extends AbstractPageMemoryStorageEngine {
    public static final String ENGINE_NAME = "aimem";
    public static final int MAX_DESTRUCTION_WORK_UNITS = 1000;
    private static final IgniteLogger LOG = Loggers.forClass(VolatilePageMemoryStorageEngine.class);
    private final String igniteInstanceName;
    private final StorageConfiguration storageConfig;
    private final VolatilePageMemoryStorageEngineConfiguration engineConfig;
    private final PageIoRegistry ioRegistry;
    private final FailureProcessor failureProcessor;
    private final Map<String, VolatilePageMemoryDataRegion> regions = new ConcurrentHashMap<String, VolatilePageMemoryDataRegion>();
    private volatile ExecutorService destructionExecutor;

    public VolatilePageMemoryStorageEngine(String igniteInstanceName, StorageConfiguration storageConfig, PageIoRegistry ioRegistry, FailureProcessor failureProcessor, HybridClock clock) {
        super(clock);
        this.igniteInstanceName = igniteInstanceName;
        this.storageConfig = storageConfig;
        this.engineConfig = ((VolatilePageMemoryStorageEngineExtensionConfiguration)storageConfig.engines()).aimem();
        this.ioRegistry = ioRegistry;
        this.failureProcessor = failureProcessor;
    }

    public VolatilePageMemoryStorageEngineConfiguration configuration() {
        return this.engineConfig;
    }

    @Override
    public String name() {
        return ENGINE_NAME;
    }

    @Override
    public void start() throws StorageException {
        for (StorageProfileView storageProfileView : (NamedListView)this.storageConfig.profiles().value()) {
            if (!(storageProfileView instanceof VolatilePageMemoryProfileView)) continue;
            String profileName = storageProfileView.name();
            VolatilePageMemoryProfileConfiguration storageProfileConfiguration = (VolatilePageMemoryProfileConfiguration)this.storageConfig.profiles().get(profileName);
            assert (storageProfileConfiguration != null) : profileName;
            this.addDataRegion(storageProfileConfiguration);
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), IgniteThreadFactory.create(this.igniteInstanceName, "volatile-mv-partition-destruction", LOG, new ThreadOperation[0]));
        executor.allowCoreThreadTimeOut(true);
        this.destructionExecutor = executor;
    }

    @Override
    public void stop() throws StorageException {
        try {
            Stream<AutoCloseable> closeRegions = this.regions.values().stream().map(region -> region::stop);
            ExecutorService destructionExecutor = this.destructionExecutor;
            Stream<AutoCloseable> shutdownExecutor = Stream.of(destructionExecutor == null ? null : () -> IgniteUtils.shutdownAndAwaitTermination(destructionExecutor, 30L, TimeUnit.SECONDS));
            IgniteUtils.closeAll(Stream.concat(shutdownExecutor, closeRegions));
        }
        catch (Exception e) {
            throw new StorageException("Error when stopping components", (Throwable)e);
        }
    }

    @Override
    public boolean isVolatile() {
        return true;
    }

    @Override
    public VolatilePageMemoryTableStorage createMvTable(StorageTableDescriptor tableDescriptor, StorageIndexDescriptorSupplier indexDescriptorSupplier) throws StorageException {
        VolatilePageMemoryDataRegion dataRegion = this.regions.get(tableDescriptor.getStorageProfile());
        assert (dataRegion != null) : "tableId=" + tableDescriptor.getId() + ", dataRegion=" + tableDescriptor.getStorageProfile();
        return new VolatilePageMemoryTableStorage(tableDescriptor, indexDescriptorSupplier, this, dataRegion, this.destructionExecutor, this.failureProcessor);
    }

    @Override
    public void destroyMvTable(int tableId) {
    }

    @Override
    public Set<Integer> tableIdsOnDisk() {
        return Collections.emptySet();
    }

    private void addDataRegion(VolatilePageMemoryProfileConfiguration storageProfileConfiguration) {
        int pageSize = (Integer)this.engineConfig.pageSizeBytes().value();
        VolatilePageMemoryDataRegion dataRegion = new VolatilePageMemoryDataRegion(storageProfileConfiguration, this.ioRegistry, pageSize);
        dataRegion.start();
        this.regions.put((String)storageProfileConfiguration.name().value(), dataRegion);
    }
}

