/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table;

import java.util.Collection;
import java.util.List;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.schema.registry.SchemaRegistryException;
import org.apache.ignite3.internal.schema.row.Row;
import org.apache.ignite3.lang.MarshallerException;

final class TableViewRowConverter {
    private final SchemaRegistry schemaReg;

    TableViewRowConverter(SchemaRegistry schemaReg) {
        this.schemaReg = schemaReg;
    }

    SchemaRegistry registry() {
        return this.schemaReg;
    }

    Row resolveRow(BinaryRow binaryRow, int targetSchemaVersion) throws MarshallerException {
        try {
            return this.schemaReg.resolve(binaryRow, targetSchemaVersion);
        }
        catch (SchemaRegistryException e) {
            throw new MarshallerException("Failed find a serialization schema for the binary row.", (Throwable)e);
        }
    }

    List<Row> resolveKeys(Collection<BinaryRow> rows, int targetSchemaVersion) throws MarshallerException {
        try {
            return this.schemaReg.resolveKeys(rows, targetSchemaVersion);
        }
        catch (SchemaRegistryException e) {
            throw new MarshallerException("Failed find a serialization schema for the binary row.", (Throwable)e);
        }
    }

    List<Row> resolveRows(Collection<BinaryRow> rows, int targetSchemaVersion) throws MarshallerException {
        try {
            return this.schemaReg.resolve(rows, targetSchemaVersion);
        }
        catch (SchemaRegistryException e) {
            throw new MarshallerException("Failed find a serialization schema for the binary row.", (Throwable)e);
        }
    }
}

