/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tx.message.TxStateCoordinatorRequest;
import org.apache.ignite3.internal.tx.message.TxStateCoordinatorRequestBuilder;
import org.apache.ignite3.internal.tx.message.TxStateCoordinatorRequestSerializer;

public class TxStateCoordinatorRequestImpl
implements TxStateCoordinatorRequest,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 4;
    @IgniteToStringInclude
    private final HybridTimestamp readTimestamp;
    @IgniteToStringInclude
    private final UUID txId;

    private TxStateCoordinatorRequestImpl(HybridTimestamp readTimestamp, UUID txId) {
        this.readTimestamp = readTimestamp;
        this.txId = txId;
    }

    @Override
    public HybridTimestamp readTimestamp() {
        return this.readTimestamp;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return TxStateCoordinatorRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(TxStateCoordinatorRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 4;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TxStateCoordinatorRequestImpl otherMessage = (TxStateCoordinatorRequestImpl)other;
        return Objects.equals(this.readTimestamp, otherMessage.readTimestamp) && Objects.equals(this.txId, otherMessage.txId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.readTimestamp, this.txId);
        return result;
    }

    @Override
    public TxStateCoordinatorRequestImpl clone() {
        try {
            return (TxStateCoordinatorRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TxStateCoordinatorRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements TxStateCoordinatorRequestBuilder {
        private HybridTimestamp readTimestamp;
        private UUID txId;

        private Builder() {
        }

        @Override
        public TxStateCoordinatorRequestBuilder readTimestamp(HybridTimestamp readTimestamp) {
            Objects.requireNonNull(readTimestamp, "readTimestamp is not marked @Nullable");
            this.readTimestamp = readTimestamp;
            return this;
        }

        @Override
        public TxStateCoordinatorRequestBuilder txId(UUID txId) {
            Objects.requireNonNull(txId, "txId is not marked @Nullable");
            this.txId = txId;
            return this;
        }

        @Override
        public HybridTimestamp readTimestamp() {
            return this.readTimestamp;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public TxStateCoordinatorRequest build() {
            return new TxStateCoordinatorRequestImpl(Objects.requireNonNull(this.readTimestamp, "readTimestamp is not marked @Nullable"), Objects.requireNonNull(this.txId, "txId is not marked @Nullable"));
        }
    }
}

