/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.tracing;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.tracing.TracingConfigurationGetCommandArg;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.tracing.Scope;

public class TracingConfigurationSetCommandArg
extends TracingConfigurationGetCommandArg {
    private static final long serialVersionUID = 0L;
    @Argument(optional=true, example="Decimal value between 0 and 1, where 0 means never and 1 means always. More or less reflects the probability of sampling specific trace.")
    private double samplingRate;
    @Argument(optional=true, example="Set of scopes with comma as separator  DISCOVERY|EXCHANGE|COMMUNICATION|TX|SQL")
    private Scope[] includedScopes;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        super.writeExternalData(out);
        out.writeDouble(this.samplingRate);
        U.writeArray(out, this.includedScopes);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalData(protoVer, in);
        this.samplingRate = in.readDouble();
        this.includedScopes = U.readArray(in, Scope.class);
    }

    public double samplingRate() {
        return this.samplingRate;
    }

    public void samplingRate(double samplingRate) {
        if (samplingRate < 0.0 || samplingRate > 1.0) {
            throw new IllegalArgumentException("Invalid sampling-rate '" + samplingRate + "'. Decimal value between 0 and 1 should be used.");
        }
        this.samplingRate = samplingRate;
    }

    public Scope[] includedScopes() {
        return this.includedScopes;
    }

    public void includedScopes(Scope[] includedScopes) {
        this.includedScopes = includedScopes;
    }
}

