/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller.optimized;

import org.apache.ignite.internal.marshaller.optimized.OptimizedObjectInputStream;
import org.apache.ignite.internal.marshaller.optimized.OptimizedObjectOutputStream;
import org.apache.ignite.internal.marshaller.optimized.OptimizedObjectStreamRegistry;
import org.apache.ignite.internal.util.typedef.internal.U;

public class OptimizedObjectSharedStreamRegistry
extends OptimizedObjectStreamRegistry {
    private static final ThreadLocal<StreamHolder> holders = new ThreadLocal();

    @Override
    OptimizedObjectOutputStream out() {
        return OptimizedObjectSharedStreamRegistry.holder().acquireOut();
    }

    @Override
    OptimizedObjectInputStream in() {
        return OptimizedObjectSharedStreamRegistry.holder().acquireIn();
    }

    @Override
    void closeOut(OptimizedObjectOutputStream out) {
        U.close(out, null);
        StreamHolder holder = holders.get();
        if (holder != null) {
            holder.releaseOut();
        }
    }

    @Override
    void closeIn(OptimizedObjectInputStream in) {
        U.close(in, null);
        StreamHolder holder = holders.get();
        if (holder != null) {
            holder.releaseIn();
        }
    }

    void closeNotCachedIn(OptimizedObjectInputStream in) {
        U.close(in, null);
        StreamHolder holder = holders.get();
        if (holder != null) {
            holder.releaseIn();
            holders.set(null);
        }
    }

    private static StreamHolder holder() {
        StreamHolder holder = holders.get();
        if (holder == null) {
            holder = new StreamHolder();
            holders.set(holder);
        }
        return holder;
    }

    private static class StreamHolder {
        private final OptimizedObjectOutputStream out = OptimizedObjectStreamRegistry.createOut();
        private final OptimizedObjectInputStream in = OptimizedObjectStreamRegistry.createIn();
        private int outAcquireCnt;
        private int inAcquireCnt;

        private StreamHolder() {
        }

        OptimizedObjectOutputStream acquireOut() {
            return this.outAcquireCnt++ > 0 ? OptimizedObjectStreamRegistry.createOut() : this.out;
        }

        OptimizedObjectInputStream acquireIn() {
            return this.inAcquireCnt++ > 0 ? OptimizedObjectStreamRegistry.createIn() : this.in;
        }

        void releaseOut() {
            --this.outAcquireCnt;
        }

        void releaseIn() {
            --this.inAcquireCnt;
        }
    }
}

