/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.schedule;

import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

class GridScheduleStatistics {
    private final long createTime = U.currentTimeMillis();
    private long lastIdleTime;
    private long totalIdleTime;
    private long lastExecTime;
    private long totalExecTime;
    private long lastStartTime;
    private long lastEndTime;
    private int execCnt;
    private boolean running;

    GridScheduleStatistics() {
    }

    long getCreateTime() {
        return this.createTime;
    }

    long getLastIdleTime() {
        return this.lastIdleTime == 0L ? U.currentTimeMillis() - this.createTime : this.lastIdleTime;
    }

    long getTotalIdleTime() {
        long now = U.currentTimeMillis();
        if (this.totalIdleTime == 0L) {
            return now - this.createTime;
        }
        if (this.running) {
            return this.totalIdleTime;
        }
        return this.totalIdleTime + (now - this.lastEndTime);
    }

    double getAverageIdleTime() {
        long now = U.currentTimeMillis();
        if (this.totalIdleTime == 0L) {
            return now - this.createTime;
        }
        return this.execCnt == 0 ? (double)this.totalIdleTime : (double)this.totalIdleTime / (double)this.execCnt;
    }

    long getLastExecutionTime() {
        return this.lastExecTime;
    }

    long getTotalExecutionTime() {
        return this.totalExecTime;
    }

    double getAverageExecutionTime() {
        return this.execCnt == 0 ? 0.0 : (double)this.totalExecTime / (double)this.execCnt;
    }

    long getLastStartTime() {
        return this.lastStartTime;
    }

    long getLastEndTime() {
        return this.lastEndTime;
    }

    int getExecutionCount() {
        return this.execCnt;
    }

    boolean isRunning() {
        return this.running;
    }

    void onStart() {
        long now;
        this.lastStartTime = now = U.currentTimeMillis();
        long lastEndTime = this.lastEndTime == 0L ? this.createTime : this.lastEndTime;
        this.lastIdleTime = now - lastEndTime;
        this.totalIdleTime += this.lastIdleTime;
        this.running = true;
    }

    void onEnd() {
        long now;
        this.lastEndTime = now = U.currentTimeMillis();
        this.lastExecTime = now - this.lastStartTime;
        this.totalExecTime += this.lastExecTime;
        ++this.execCnt;
        this.running = false;
    }

    public String toString() {
        return S.toString(GridScheduleStatistics.class, this);
    }
}

