/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.concurrent.atomic.AtomicInteger;

public class GridCountDownCallback {
    private final AtomicInteger cntr;
    private final int executionThreshold;
    private final AtomicInteger executionCntr = new AtomicInteger(0);
    private final Runnable cb;

    public GridCountDownCallback(int initCnt, Runnable cb, int executionThreshold) {
        this.cntr = new AtomicInteger(initCnt);
        this.executionThreshold = executionThreshold;
        this.cb = cb;
    }

    public GridCountDownCallback(int initCnt, Runnable cb) {
        this(initCnt, cb, 0);
    }

    public void countDown(boolean doIncreaseExecutionCounter) {
        if (doIncreaseExecutionCounter) {
            this.executionCntr.incrementAndGet();
        }
        if (this.cntr.decrementAndGet() == 0 && this.executionCntr.get() >= this.executionThreshold) {
            this.cb.run();
        }
    }

    public void countDown() {
        this.countDown(true);
    }
}

