/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.forwarder;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.utils.StatusUtils;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardPlanHandler
implements AsyncMethodCallback<TSStatus> {
    private static final Logger logger = LoggerFactory.getLogger(ForwardPlanHandler.class);
    private PhysicalPlan plan;
    private AtomicReference<TSStatus> result;
    private Node node;

    public ForwardPlanHandler(AtomicReference<TSStatus> result, PhysicalPlan plan, Node node) {
        this.result = result;
        this.plan = plan;
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(TSStatus response) {
        AtomicReference<TSStatus> atomicReference = this.result;
        synchronized (atomicReference) {
            this.result.set(response);
            this.result.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Exception exception) {
        if (exception instanceof IOException) {
            logger.warn("Cannot send plan {} to node {}: {}", new Object[]{this.plan, this.node, exception.getMessage()});
        } else {
            logger.error("Cannot send plan {} to node {}", new Object[]{this.plan, this.node, exception});
        }
        AtomicReference<TSStatus> atomicReference = this.result;
        synchronized (atomicReference) {
            TSStatus status = StatusUtils.getStatus(StatusUtils.INTERNAL_ERROR, exception.getMessage());
            this.result.set(status);
            this.result.notifyAll();
        }
    }
}

