/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.predefined;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class ProcessMetrics
implements IMetricSet {
    private OperatingSystemMXBean sunOsMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private Runtime runtime = Runtime.getRuntime();

    public void bindTo(AbstractMetricService metricService) {
        this.collectProcessCPUInfo(metricService);
        this.collectProcessMemInfo(metricService);
        this.collectProcessStatusInfo(metricService);
        this.collectThreadInfo(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.removeProcessCPUInfo(metricService);
        this.removeProcessMemInfo(metricService);
        this.removeProcessStatusInfo(metricService);
        this.removeThreadInfo(metricService);
    }

    private void collectProcessCPUInfo(AbstractMetricService metricService) {
        metricService.getOrCreateAutoGauge(Metric.PROCESS_CPU_LOAD.toString(), MetricLevel.CORE, (Object)this.sunOsMXBean, a -> (long)(this.sunOsMXBean.getProcessCpuLoad() * 100.0), new String[]{Tag.NAME.toString(), "process"});
        metricService.getOrCreateAutoGauge(Metric.PROCESS_CPU_TIME.toString(), MetricLevel.CORE, (Object)this.sunOsMXBean, OperatingSystemMXBean::getProcessCpuTime, new String[]{Tag.NAME.toString(), "process"});
    }

    private void removeProcessCPUInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.GAUGE, Metric.PROCESS_CPU_LOAD.toString(), new String[]{Tag.NAME.toString(), "process"});
        metricService.remove(MetricType.GAUGE, Metric.PROCESS_CPU_TIME.toString(), new String[]{Tag.NAME.toString(), "process"});
    }

    private void collectProcessMemInfo(AbstractMetricService metricService) {
        Runtime runtime = Runtime.getRuntime();
        metricService.getOrCreateAutoGauge(Metric.PROCESS_MAX_MEM.toString(), MetricLevel.CORE, (Object)runtime, a -> runtime.maxMemory(), new String[]{Tag.NAME.toString(), "process"});
        metricService.getOrCreateAutoGauge(Metric.PROCESS_TOTAL_MEM.toString(), MetricLevel.CORE, (Object)runtime, a -> runtime.totalMemory(), new String[]{Tag.NAME.toString(), "process"});
        metricService.getOrCreateAutoGauge(Metric.PROCESS_FREE_MEM.toString(), MetricLevel.CORE, (Object)runtime, a -> runtime.freeMemory(), new String[]{Tag.NAME.toString(), "process"});
        metricService.getOrCreateAutoGauge(Metric.PROCESS_USED_MEM.toString(), MetricLevel.CORE, (Object)this, a -> this.getProcessUsedMemory(), new String[]{Tag.NAME.toString(), "process"});
        metricService.getOrCreateAutoGauge(Metric.PROCESS_MEM_RATIO.toString(), MetricLevel.CORE, (Object)this, a -> Math.round(this.getProcessMemoryRatio()), new String[]{Tag.NAME.toString(), "process"});
    }

    private void removeProcessMemInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.GAUGE, Metric.PROCESS_MAX_MEM.toString(), new String[]{Tag.NAME.toString(), "process"});
        metricService.remove(MetricType.GAUGE, Metric.PROCESS_TOTAL_MEM.toString(), new String[]{Tag.NAME.toString(), "process"});
        metricService.remove(MetricType.GAUGE, Metric.PROCESS_FREE_MEM.toString(), new String[]{Tag.NAME.toString(), "process"});
        metricService.remove(MetricType.GAUGE, Metric.PROCESS_USED_MEM.toString(), new String[]{Tag.NAME.toString(), "process"});
        metricService.remove(MetricType.GAUGE, Metric.PROCESS_MEM_RATIO.toString(), new String[]{Tag.NAME.toString(), "process"});
    }

    private void collectThreadInfo(AbstractMetricService metricService) {
        metricService.getOrCreateAutoGauge(Metric.PROCESS_THREADS_COUNT.toString(), MetricLevel.CORE, (Object)this, a -> this.getThreadsCount(), new String[]{Tag.NAME.toString(), "process"});
    }

    private void removeThreadInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.GAUGE, Metric.PROCESS_THREADS_COUNT.toString(), new String[]{Tag.NAME.toString(), "process"});
    }

    private void collectProcessStatusInfo(AbstractMetricService metricService) {
        metricService.getOrCreateAutoGauge(Metric.PROCESS_STATUS.toString(), MetricLevel.CORE, (Object)this, a -> this.getProcessStatus(), new String[]{Tag.NAME.toString(), "process"});
    }

    private void removeProcessStatusInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.GAUGE, Metric.PROCESS_STATUS.toString(), new String[]{Tag.NAME.toString(), "process"});
    }

    private long getProcessUsedMemory() {
        return this.runtime.totalMemory() - this.runtime.freeMemory();
    }

    private long getProcessStatus() {
        return Thread.currentThread().isAlive() ? 1L : 0L;
    }

    private int getThreadsCount() {
        ThreadGroup parentThread = Thread.currentThread().getThreadGroup();
        while (parentThread.getParent() != null) {
            parentThread = parentThread.getParent();
        }
        return parentThread.activeCount();
    }

    private double getProcessMemoryRatio() {
        long processUsedMemory = this.getProcessUsedMemory();
        long totalPhysicalMemorySize = this.sunOsMXBean.getTotalPhysicalMemorySize();
        return (double)processUsedMemory / (double)totalPhysicalMemorySize * 100.0;
    }
}

