/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.db.query.expression.ResultColumn;
import org.apache.iotdb.db.query.expression.unary.FunctionExpression;

public class GroupByLevelController {
    public static String ALIAS_ERROR_MESSAGE1 = "alias '%s' can only be matched with one result column";
    public static String ALIAS_ERROR_MESSAGE2 = "Result column %s with more than one alias[%s, %s]";
    private final int seriesLimit;
    private int seriesOffset;
    Set<String> limitPaths;
    Set<String> offsetPaths;
    private final int[] levels;
    int prevSize = 0;
    private Map<String, String> groupedPathMap;
    private Map<String, String> columnToAliasMap;
    private Map<String, String> aliasToColumnMap;

    public GroupByLevelController(QueryOperator operator) {
        this.seriesLimit = operator.getSpecialClauseComponent().getSeriesLimit();
        this.seriesOffset = operator.getSpecialClauseComponent().getSeriesOffset();
        this.limitPaths = this.seriesLimit > 0 ? new HashSet() : null;
        this.offsetPaths = this.seriesOffset > 0 ? new HashSet() : null;
        this.groupedPathMap = new LinkedHashMap<String, String>();
        this.levels = operator.getLevels();
    }

    public String getGroupedPath(String rawPath) {
        return this.groupedPathMap.get(rawPath);
    }

    public String getAlias(String originName) {
        return this.columnToAliasMap != null && this.columnToAliasMap.get(originName) != null ? this.columnToAliasMap.get(originName) : null;
    }

    public void control(ResultColumn rawColumn, List<ResultColumn> resultColumns) throws LogicalOptimizeException {
        Set<Integer> countWildcardIterIndices = this.getCountStarIndices(rawColumn);
        Iterator<ResultColumn> iterator = resultColumns.iterator();
        for (int i = 0; i < this.prevSize; ++i) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            ResultColumn resultColumn = iterator.next();
            Expression rootExpression = resultColumn.getExpression();
            boolean hasAggregation = false;
            int idx = 0;
            Iterator<Expression> it = rootExpression.iterator();
            while (it.hasNext()) {
                Expression expression = it.next();
                if (!(expression instanceof FunctionExpression) || !expression.isPlainAggregationFunctionExpression()) continue;
                hasAggregation = true;
                List<PartialPath> paths = ((FunctionExpression)expression).getPaths();
                String functionName = ((FunctionExpression)expression).getFunctionName();
                boolean isCountStar = countWildcardIterIndices.contains(idx++);
                String groupedPath = this.generatePartialPathByLevel(isCountStar, paths.get(0).getNodes(), this.levels);
                String rawPath = String.format("%s(%s)", functionName, paths.get(0).getFullPath());
                String pathWithFunction = String.format("%s(%s)", functionName, groupedPath);
                if (this.seriesLimit == 0 && this.seriesOffset == 0) {
                    this.groupedPathMap.put(rawPath, pathWithFunction);
                    this.checkAliasAndUpdateAliasMap(rawColumn, pathWithFunction);
                    continue;
                }
                if (this.seriesOffset > 0 && this.offsetPaths != null) {
                    this.offsetPaths.add(pathWithFunction);
                    if (this.offsetPaths.size() > this.seriesOffset) continue;
                    iterator.remove();
                    if (this.offsetPaths.size() != this.seriesOffset) continue;
                    this.seriesOffset = 0;
                    continue;
                }
                if (this.offsetPaths == null || !this.offsetPaths.contains(pathWithFunction)) {
                    this.limitPaths.add(pathWithFunction);
                    if (this.seriesLimit > 0 && this.limitPaths.size() > this.seriesLimit) {
                        iterator.remove();
                        this.limitPaths.remove(pathWithFunction);
                        continue;
                    }
                    this.groupedPathMap.put(rawPath, pathWithFunction);
                    this.checkAliasAndUpdateAliasMap(rawColumn, pathWithFunction);
                    continue;
                }
                iterator.remove();
            }
            if (hasAggregation) continue;
            throw new LogicalOptimizeException(rootExpression + " can't be used in group by level.");
        }
        this.prevSize = resultColumns.size();
    }

    private Set<Integer> getCountStarIndices(ResultColumn rawColumn) {
        HashSet<Integer> countWildcardIterIndices = new HashSet<Integer>();
        int idx = 0;
        Iterator<Expression> it = rawColumn.getExpression().iterator();
        while (it.hasNext()) {
            Expression expression = it.next();
            if (expression instanceof FunctionExpression && expression.isPlainAggregationFunctionExpression() && ((FunctionExpression)expression).isCountStar()) {
                countWildcardIterIndices.add(idx);
            }
            ++idx;
        }
        return countWildcardIterIndices;
    }

    private void checkAliasAndUpdateAliasMap(ResultColumn rawColumn, String originName) throws LogicalOptimizeException {
        if (!rawColumn.hasAlias()) {
            return;
        }
        if (this.columnToAliasMap == null) {
            this.columnToAliasMap = new HashMap<String, String>();
            this.aliasToColumnMap = new HashMap<String, String>();
        }
        if (this.columnToAliasMap.get(originName) == null) {
            if (this.aliasToColumnMap.get(rawColumn.getAlias()) != null) {
                throw new LogicalOptimizeException(String.format(ALIAS_ERROR_MESSAGE1, rawColumn.getAlias()));
            }
            this.columnToAliasMap.put(originName, rawColumn.getAlias());
            this.aliasToColumnMap.put(rawColumn.getAlias(), originName);
        } else if (!this.columnToAliasMap.get(originName).equals(rawColumn.getAlias())) {
            throw new LogicalOptimizeException(String.format(ALIAS_ERROR_MESSAGE2, originName, this.columnToAliasMap.get(originName), rawColumn.getAlias()));
        }
    }

    public String generatePartialPathByLevel(boolean isCountStar, String[] nodes, int[] pathLevels) {
        HashSet<Integer> levelSet = new HashSet<Integer>();
        for (int level : pathLevels) {
            levelSet.add(level);
        }
        StringBuilder transformedPath = new StringBuilder();
        transformedPath.append(nodes[0]).append(".");
        for (int k = 1; k < nodes.length - 1; ++k) {
            if (levelSet.contains(k)) {
                transformedPath.append(nodes[k]);
            } else {
                transformedPath.append("*");
            }
            transformedPath.append(".");
        }
        if (isCountStar) {
            transformedPath.append("*");
        } else {
            transformedPath.append(nodes[nodes.length - 1]);
        }
        return transformedPath.toString();
    }
}

