/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.utils;

import java.util.Map;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricInfo;

public class IoTDBMetricsUtils {
    private static final MetricConfig metricConfig = MetricConfigDescriptor.getInstance().getMetricConfig();
    public static final String DATABASE = "root.__system";

    public static String generatePath(MetricInfo metricInfo) {
        return IoTDBMetricsUtils.generatePath(metricInfo.getName(), metricInfo.getTags());
    }

    public static String generatePath(String name, String ... tags) {
        StringBuilder stringBuilder = IoTDBMetricsUtils.generateMetric(name);
        for (int i = 0; i < tags.length; i += 2) {
            stringBuilder.append(".").append("\"").append(tags[i]).append("=").append(tags[i + 1]).append("\"");
        }
        return stringBuilder.toString();
    }

    public static String generatePath(String name, Map<String, String> tags) {
        StringBuilder stringBuilder = IoTDBMetricsUtils.generateMetric(name);
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            stringBuilder.append(".").append("\"").append(entry.getKey()).append("=").append(entry.getValue()).append("\"");
        }
        return stringBuilder.toString();
    }

    private static StringBuilder generateMetric(String name) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DATABASE).append(".").append(metricConfig.getIoTDBReporterConfig().getDatabase()).append(".\"").append(metricConfig.getRpcAddress()).append(":").append(metricConfig.getRpcPort()).append("\"").append(".").append("\"").append(name).append("\"");
        return stringBuilder;
    }
}

