/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.handler;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.client.async.AsyncPipeConsensusServiceClient;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusBatchTransferReq;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusBatchTransferResp;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferResp;
import org.apache.iotdb.db.pipe.consensus.PipeConsensusSinkMetrics;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.PipeConsensusAsyncSink;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.builder.PipeConsensusAsyncBatchReqBuilder;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConsensusTabletBatchEventHandler
implements AsyncMethodCallback<TPipeConsensusBatchTransferResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusTabletBatchEventHandler.class);
    private final List<Long> requestCommitIds;
    private final List<Event> events;
    private final TPipeConsensusBatchTransferReq req;
    private final PipeConsensusAsyncSink connector;
    private final PipeConsensusSinkMetrics pipeConsensusSinkMetrics;

    public PipeConsensusTabletBatchEventHandler(PipeConsensusAsyncBatchReqBuilder batchBuilder, PipeConsensusAsyncSink connector, PipeConsensusSinkMetrics pipeConsensusSinkMetrics) throws IOException {
        this.requestCommitIds = batchBuilder.deepCopyRequestCommitIds();
        this.events = batchBuilder.deepCopyEvents();
        this.req = batchBuilder.toTPipeConsensusBatchTransferReq();
        this.pipeConsensusSinkMetrics = pipeConsensusSinkMetrics;
        this.connector = connector;
    }

    public void transfer(AsyncPipeConsensusServiceClient client) throws TException {
        client.pipeConsensusBatchTransfer(this.req, (AsyncMethodCallback)this);
    }

    public void onComplete(TPipeConsensusBatchTransferResp response) {
        if (response == null) {
            this.onError((Exception)((Object)new PipeException("TPipeConsensusBatchTransferResp is null")));
            return;
        }
        try {
            List status = response.getBatchResps().stream().map(TPipeConsensusTransferResp::getStatus).collect(Collectors.toList());
            if (status.stream().anyMatch(tsStatus -> tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode())) {
                status.stream().filter(tsStatus -> tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()).forEach(tsStatus -> {
                    this.pipeConsensusSinkMetrics.recordRetryCounter();
                    this.connector.statusHandler().handle(tsStatus, tsStatus.getMessage(), this.events.toString());
                });
                this.connector.addFailureEventsToRetryQueue(this.events);
            } else {
                this.events.forEach(event -> this.connector.removeEventFromBuffer((EnrichedEvent)event));
            }
            for (Event event2 : this.events) {
                if (!(event2 instanceof EnrichedEvent)) continue;
                ((EnrichedEvent)event2).decreaseReferenceCount(PipeConsensusTabletBatchEventHandler.class.getName(), true);
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    public void onError(Exception exception) {
        LOGGER.warn("PipeConsensus: Failed to transfer TabletInsertionEvent batch. Total failed events: {}, related pipe names: {}", new Object[]{this.events.size(), this.events.stream().map(event -> event instanceof EnrichedEvent ? ((EnrichedEvent)event).getPipeName() : "UNKNOWN").collect(Collectors.toSet()), exception});
        this.connector.addFailureEventsToRetryQueue(this.events);
    }
}

