/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemAlignedChunkReader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemChunkLoader;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.IChunkReader;

public class MemAlignedChunkLoader
extends MemChunkLoader {
    public MemAlignedChunkLoader(QueryContext context, AlignedReadOnlyMemChunk chunk) {
        super(context, chunk);
    }

    public MemAlignedChunkLoader(QueryContext context, AlignedReadOnlyMemChunk chunk, boolean streamingQueryMemChunk) {
        super(context, chunk, streamingQueryMemChunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IChunkReader getChunkReader(IChunkMetadata chunkMetaData, Filter globalTimeFilter) {
        long startTime = System.nanoTime();
        try {
            MemAlignedChunkReader memAlignedChunkReader = new MemAlignedChunkReader((AlignedReadOnlyMemChunk)this.chunk, globalTimeFilter);
            return memAlignedChunkReader;
        }
        finally {
            long duration = System.nanoTime() - startTime;
            this.context.getQueryStatistics().getConstructAlignedChunkReadersMemCount().getAndAdd(1L);
            this.context.getQueryStatistics().getConstructAlignedChunkReadersMemTime().getAndAdd(duration);
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("init_chunk_reader_aligned_mem", duration);
        }
    }
}

