/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Stack;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.auth.entity.PrivilegeModelType;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.IOUtils;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.commons.utils.ThriftConfigNodeSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorRelationalPlan;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorTreePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeCreateTableOrViewPlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CommitSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.persistence.schema.CNSnapshotFileType;
import org.apache.iotdb.confignode.persistence.schema.ConfigMTree;
import org.apache.iotdb.confignode.persistence.schema.mnode.IConfigMNode;
import org.apache.iotdb.confignode.persistence.schema.mnode.factory.ConfigMNodeFactory;
import org.apache.iotdb.confignode.persistence.schema.mnode.impl.ConfigTableNode;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CNPhysicalPlanGenerator
implements Iterator<ConfigPhysicalPlan>,
Iterable<ConfigPhysicalPlan> {
    private final Logger logger = LoggerFactory.getLogger(CNPhysicalPlanGenerator.class);
    private final IMNodeFactory<IConfigMNode> nodeFactory = ConfigMNodeFactory.getInstance();
    private InputStream inputStream = null;
    private InputStream templateInputStream = null;
    private static final String STRING_ENCODING = "utf-8";
    private final ThreadLocal<byte[]> strBufferLocal = new ThreadLocal();
    private final HashMap<Integer, String> templateTable = new HashMap();
    private final List<IConfigMNode> templateNodeList = new ArrayList<IConfigMNode>();
    private final Deque<ConfigPhysicalPlan> planDeque = new ArrayDeque<ConfigPhysicalPlan>();
    private CNSnapshotFileType snapshotFileType = CNSnapshotFileType.INVALID;
    private Exception latestException = null;
    private String userName;

    public CNPhysicalPlanGenerator(Path snapshotFilePath, CNSnapshotFileType fileType) throws IOException {
        if (fileType == CNSnapshotFileType.SCHEMA) {
            this.logger.warn("schema_template need two files");
            return;
        }
        if (fileType == CNSnapshotFileType.USER_ROLE) {
            this.userName = snapshotFilePath.getFileName().toString().split("_role.profile")[0];
        }
        this.snapshotFileType = fileType;
        this.inputStream = Files.newInputStream(snapshotFilePath, new OpenOption[0]);
    }

    public CNPhysicalPlanGenerator(Path schemaInfoFile, Path templateFile) throws IOException {
        this.inputStream = Files.newInputStream(schemaInfoFile, new OpenOption[0]);
        if (Objects.nonNull(templateFile)) {
            this.templateInputStream = Files.newInputStream(templateFile, new OpenOption[0]);
        }
        this.snapshotFileType = CNSnapshotFileType.SCHEMA;
    }

    @Override
    @Nonnull
    public Iterator<ConfigPhysicalPlan> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (!this.planDeque.isEmpty()) {
            return true;
        }
        if (this.snapshotFileType == CNSnapshotFileType.USER) {
            this.generateUserRolePhysicalPlan(true);
        } else if (this.snapshotFileType == CNSnapshotFileType.ROLE) {
            this.generateUserRolePhysicalPlan(false);
        } else if (this.snapshotFileType == CNSnapshotFileType.USER_ROLE) {
            this.generateGrantRolePhysicalPlan();
        } else if (this.snapshotFileType == CNSnapshotFileType.TTL) {
            this.generateSetTTLPlan();
        } else if (this.snapshotFileType == CNSnapshotFileType.SCHEMA) {
            if (Objects.nonNull(this.templateInputStream)) {
                this.generateTemplatePlan();
            }
            if (this.latestException != null) {
                return false;
            }
            this.generateDatabasePhysicalPlan();
            if (this.latestException != null) {
                return false;
            }
            this.generateSetTemplatePlan();
        }
        this.snapshotFileType = CNSnapshotFileType.INVALID;
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
            if (this.templateInputStream != null) {
                this.templateInputStream.close();
                this.templateInputStream = null;
            }
        }
        catch (IOException ioException) {
            this.latestException = ioException;
        }
        if (this.latestException != null) {
            return false;
        }
        return !this.planDeque.isEmpty();
    }

    @Override
    public ConfigPhysicalPlan next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.planDeque.pop();
    }

    public void checkException() throws Exception {
        if (this.latestException != null) {
            throw new Exception(this.latestException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateUserRolePhysicalPlan(boolean isUser) {
        block25: {
            try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(this.inputStream));){
                int tag = dataInputStream.readInt();
                boolean fromOldVersion = tag < 0;
                String user = fromOldVersion ? IOUtils.readString((DataInputStream)dataInputStream, (String)STRING_ENCODING, this.strBufferLocal, (int)(-1 * tag)) : IOUtils.readString((DataInputStream)dataInputStream, (String)STRING_ENCODING, this.strBufferLocal);
                if (isUser) {
                    String rawPassword = IOUtils.readString((DataInputStream)dataInputStream, (String)STRING_ENCODING, this.strBufferLocal);
                    AuthorTreePlan createUser = new AuthorTreePlan(ConfigPhysicalPlanType.CreateUserWithRawPassword);
                    createUser.setUserName(user);
                    createUser.setPassword(rawPassword);
                    createUser.setPermissions(new HashSet<Integer>());
                    createUser.setNodeNameList(new ArrayList<PartialPath>());
                    this.planDeque.add(createUser);
                } else {
                    AuthorTreePlan createRole = new AuthorTreePlan(ConfigPhysicalPlanType.CreateRole);
                    createRole.setRoleName(user);
                    createRole.setPermissions(new HashSet<Integer>());
                    createRole.setNodeNameList(new ArrayList<PartialPath>());
                    this.planDeque.add(createRole);
                }
                int privilegeMask = dataInputStream.readInt();
                this.generateGrantSysPlan(user, isUser, privilegeMask);
                if (fromOldVersion) {
                    while (dataInputStream.available() != 0) {
                        PartialPath priPath;
                        String path = IOUtils.readString((DataInputStream)dataInputStream, (String)STRING_ENCODING, this.strBufferLocal);
                        try {
                            priPath = new PartialPath(path);
                        }
                        catch (IllegalPathException exception) {
                            this.latestException = exception;
                            dataInputStream.close();
                            this.strBufferLocal.remove();
                            return;
                        }
                        int privileges = dataInputStream.readInt();
                        this.generateGrantAuthorTreePlan(user, isUser, priPath, privileges);
                    }
                    break block25;
                }
                int num = dataInputStream.readInt();
                for (int i = 0; i < num; ++i) {
                    PartialPath priPath;
                    String path = IOUtils.readString((DataInputStream)dataInputStream, (String)STRING_ENCODING, this.strBufferLocal);
                    try {
                        priPath = new PartialPath(path);
                    }
                    catch (IllegalPathException exception) {
                        this.latestException = exception;
                        dataInputStream.close();
                        this.strBufferLocal.remove();
                        return;
                    }
                    int privileges = dataInputStream.readInt();
                    this.generateGrantAuthorTreePlan(user, isUser, priPath, privileges);
                }
                int anyScopePriv = dataInputStream.readInt();
                this.generateGrantAuthorRelationalPlan(user, isUser, null, null, anyScopePriv);
                num = dataInputStream.readInt();
                for (int i = 0; i < num; ++i) {
                    String databaseName = IOUtils.readString((DataInputStream)dataInputStream, (String)STRING_ENCODING, this.strBufferLocal);
                    int databasePrivilege = dataInputStream.readInt();
                    this.generateGrantAuthorRelationalPlan(user, isUser, databaseName, null, databasePrivilege);
                    int tableNum = dataInputStream.readInt();
                    for (int tableid = 0; tableid < tableNum; ++tableid) {
                        String tableName = IOUtils.readString((DataInputStream)dataInputStream, (String)STRING_ENCODING, this.strBufferLocal);
                        int tablePrivilege = dataInputStream.readInt();
                        this.generateGrantAuthorRelationalPlan(user, isUser, databaseName, tableName, tablePrivilege);
                    }
                }
            }
            catch (IOException ioException) {
                this.logger.error("Got IOException when deserialize use&role file, type:{}", (Object)this.snapshotFileType, (Object)ioException);
                this.latestException = ioException;
            }
            finally {
                this.strBufferLocal.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateGrantRolePhysicalPlan() {
        try (DataInputStream roleInputStream = new DataInputStream(new BufferedInputStream(this.inputStream));){
            int i = 0;
            while (roleInputStream.available() != 0) {
                String roleName = IOUtils.readString((DataInputStream)roleInputStream, (String)STRING_ENCODING, this.strBufferLocal);
                AuthorTreePlan plan = new AuthorTreePlan(ConfigPhysicalPlanType.GrantRoleToUser);
                plan.setUserName(this.userName);
                plan.setRoleName(roleName);
                plan.setNodeNameList(new ArrayList<PartialPath>());
                plan.setPermissions(new HashSet<Integer>());
                this.planDeque.add(plan);
                ++i;
            }
        }
        catch (IOException ioException) {
            this.logger.error("Got IOException when deserialize roleList", (Throwable)ioException);
            this.latestException = ioException;
        }
        finally {
            this.strBufferLocal.remove();
        }
    }

    private void generateGrantSysPlan(String userName, boolean isUser, int sysMask) {
        for (int i = 0; i < PrivilegeType.getPrivilegeCount((PrivilegeModelType)PrivilegeModelType.SYSTEM); ++i) {
            if ((sysMask & 1 << i) == 0) continue;
            AuthorTreePlan plan = new AuthorTreePlan(isUser ? ConfigPhysicalPlanType.GrantUser : ConfigPhysicalPlanType.GrantRole);
            if (isUser) {
                plan.setUserName(userName);
                plan.setRoleName("");
            } else {
                plan.setRoleName(userName);
                plan.setUserName("");
            }
            plan.setPermissions(Collections.singleton(AuthUtils.posToSysPri((int)i).ordinal()));
            if ((sysMask & 1 << i + 16) != 0) {
                plan.setGrantOpt(true);
            }
            plan.setNodeNameList(new ArrayList<PartialPath>());
            this.planDeque.add(plan);
        }
    }

    private void generateSetTTLPlan() {
        try (DataInputStream ttlInputStream = new DataInputStream(new BufferedInputStream(this.inputStream));){
            for (int size = ReadWriteIOUtils.readInt((InputStream)ttlInputStream); size > 0; --size) {
                String path = ReadWriteIOUtils.readString((InputStream)ttlInputStream);
                long ttl = ReadWriteIOUtils.readLong((InputStream)ttlInputStream);
                this.planDeque.add(new SetTTLPlan(PathUtils.splitPathToDetachedNodes((String)path), ttl));
            }
        }
        catch (IOException | IllegalPathException e) {
            this.logger.error("Got exception when deserializing ttl file", e);
            this.latestException = e;
        }
    }

    private void generateGrantAuthorTreePlan(String name, boolean isUser, PartialPath path, int priMask) {
        for (int pos = 0; pos < PrivilegeType.getPrivilegeCount((PrivilegeModelType)PrivilegeModelType.TREE); ++pos) {
            if ((1 << pos & priMask) == 0) continue;
            AuthorTreePlan plan = new AuthorTreePlan(isUser ? ConfigPhysicalPlanType.GrantUser : ConfigPhysicalPlanType.GrantRole);
            if (isUser) {
                plan.setUserName(name);
                plan.setRoleName("");
            } else {
                plan.setRoleName(name);
                plan.setUserName("");
            }
            plan.setPermissions(Collections.singleton(AuthUtils.pathPosToPri((int)pos)));
            plan.setNodeNameList(Collections.singletonList(path));
            if ((1 << pos + 16 & priMask) != 0) {
                plan.setGrantOpt(true);
            }
            this.planDeque.add(plan);
        }
    }

    private void generateGrantAuthorRelationalPlan(String name, boolean isUser, String database, String table, int priMask) {
        for (int pos = 0; pos < PrivilegeType.getPrivilegeCount((PrivilegeModelType)PrivilegeModelType.RELATIONAL); ++pos) {
            if ((1 << pos & priMask) == 0) continue;
            AuthorRelationalPlan plan = database == null && table == null ? new AuthorRelationalPlan(isUser ? ConfigPhysicalPlanType.RGrantUserAny : ConfigPhysicalPlanType.RGrantRoleAny) : (database != null && table == null ? new AuthorRelationalPlan(isUser ? ConfigPhysicalPlanType.RGrantUserDBPriv : ConfigPhysicalPlanType.RGrantRoleDBPriv) : new AuthorRelationalPlan(isUser ? ConfigPhysicalPlanType.RGrantUserTBPriv : ConfigPhysicalPlanType.RGrantRoleTBPriv));
            if (isUser) {
                plan.setUserName(name);
                plan.setRoleName("");
            } else {
                plan.setRoleName(name);
                plan.setUserName("");
            }
            plan.setPermissions(Collections.singleton(AuthUtils.posToObjPri((int)pos).ordinal()));
            if ((1 << pos + 16 & priMask) != 0) {
                plan.setGrantOpt(true);
            }
            plan.setDatabaseName(database == null ? "" : database);
            plan.setTableName(table == null ? "" : table);
            this.planDeque.add(plan);
        }
    }

    private void generateDatabasePhysicalPlan() {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(this.inputStream);){
            IConfigMNode internalMNode;
            ConfigTableNode tableNode;
            String name;
            IConfigMNode databaseMNode;
            byte type = ReadWriteIOUtils.readByte((InputStream)bufferedInputStream);
            Stack<Pair> stack = new Stack<Pair>();
            HashSet<TsTable> tableSet = new HashSet<TsTable>();
            if (type == 1) {
                databaseMNode = this.deserializeDatabaseMNode(bufferedInputStream);
                name = databaseMNode.getName();
                stack.push(new Pair((Object)databaseMNode, (Object)true));
            } else if (type == 6) {
                tableNode = ConfigMTree.deserializeTableMNode(bufferedInputStream);
                name = tableNode.getName();
                stack.push(new Pair((Object)tableNode, (Object)false));
                tableSet.add(tableNode.getTable());
            } else {
                internalMNode = this.deserializeInternalMNode(bufferedInputStream);
                ReadWriteIOUtils.readInt((InputStream)bufferedInputStream);
                name = internalMNode.getName();
                stack.push(new Pair((Object)internalMNode, (Object)false));
            }
            block12: while (!"root".equals(name)) {
                type = ReadWriteIOUtils.readByte((InputStream)bufferedInputStream);
                switch (type) {
                    case 0: {
                        internalMNode = this.deserializeInternalMNode(bufferedInputStream);
                        boolean hasDB = false;
                        for (int childNum = ReadWriteIOUtils.readInt((InputStream)bufferedInputStream); childNum > 0; --childNum) {
                            hasDB = (Boolean)((Pair)stack.peek()).right;
                            internalMNode.addChild((IConfigMNode)((Pair)stack.pop()).left);
                        }
                        stack.push(new Pair((Object)internalMNode, (Object)hasDB));
                        name = internalMNode.getName();
                        continue block12;
                    }
                    case 1: {
                        databaseMNode = (IConfigMNode)this.deserializeDatabaseMNode(bufferedInputStream).getAsMNode();
                        while (!stack.isEmpty() && !((Boolean)((Pair)stack.peek()).right).booleanValue()) {
                            databaseMNode.addChild((IConfigMNode)((Pair)stack.pop()).left);
                        }
                        stack.push(new Pair((Object)databaseMNode, (Object)true));
                        name = databaseMNode.getName();
                        for (TsTable table : tableSet) {
                            this.planDeque.add(new PipeCreateTableOrViewPlan(name, table));
                        }
                        tableSet.clear();
                        continue block12;
                    }
                    case 6: {
                        tableNode = ConfigMTree.deserializeTableMNode(bufferedInputStream);
                        name = tableNode.getName();
                        stack.push(new Pair((Object)tableNode, (Object)false));
                        tableSet.add(tableNode.getTable());
                        continue block12;
                    }
                }
                this.logger.error("Unrecognized node type. Cannot deserialize MTree from given buffer");
                return;
            }
        }
        catch (IOException ioException) {
            this.logger.error("Got IOException when construct database Tree", (Throwable)ioException);
            this.latestException = ioException;
        }
    }

    private void generateTemplatePlan() {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(this.templateInputStream);){
            ByteBuffer byteBuffer = ByteBuffer.wrap(org.apache.commons.io.IOUtils.toByteArray((InputStream)bufferedInputStream));
            ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            for (int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); size > 0; --size) {
                Template template = new Template();
                template.deserialize(byteBuffer);
                this.templateTable.put(template.getId(), template.getName());
                template.setId(0);
                CreateSchemaTemplatePlan plan = new CreateSchemaTemplatePlan(template.serialize().array());
                this.planDeque.add(plan);
            }
        }
        catch (IOException ioException) {
            this.logger.error("Got IOException when deserialize template info", (Throwable)ioException);
            this.latestException = ioException;
        }
    }

    private void generateSetTemplatePlan() {
        if (this.templateNodeList.isEmpty()) {
            return;
        }
        for (IConfigMNode templateNode : this.templateNodeList) {
            String templateName = this.templateTable.get(templateNode.getSchemaTemplateId());
            CommitSetSchemaTemplatePlan plan = new CommitSetSchemaTemplatePlan(templateName, templateNode.getFullPath());
            this.planDeque.add(plan);
        }
    }

    private IConfigMNode deserializeDatabaseMNode(InputStream inputStream) throws IOException {
        IDatabaseMNode databaseMNode = this.nodeFactory.createDatabaseMNode(null, ReadWriteIOUtils.readString((InputStream)inputStream));
        ((IConfigMNode)databaseMNode.getAsMNode()).setSchemaTemplateId(ReadWriteIOUtils.readInt((InputStream)inputStream));
        ((IConfigMNode)databaseMNode.getAsMNode()).setDatabaseSchema(ThriftConfigNodeSerDeUtils.deserializeTDatabaseSchema((InputStream)inputStream));
        if (((IConfigMNode)databaseMNode.getAsMNode()).getSchemaTemplateId() >= 0 && !this.templateTable.isEmpty()) {
            this.templateNodeList.add((IConfigMNode)databaseMNode);
        }
        DatabaseSchemaPlan createDBPlan = new DatabaseSchemaPlan(ConfigPhysicalPlanType.CreateDatabase, ((IConfigMNode)databaseMNode.getAsMNode()).getDatabaseSchema());
        this.planDeque.add(createDBPlan);
        return (IConfigMNode)databaseMNode.getAsMNode();
    }

    private IConfigMNode deserializeInternalMNode(InputStream inputStream) throws IOException {
        IConfigMNode basicMNode = (IConfigMNode)this.nodeFactory.createInternalMNode(null, ReadWriteIOUtils.readString((InputStream)inputStream));
        basicMNode.setSchemaTemplateId(ReadWriteIOUtils.readInt((InputStream)inputStream));
        if (basicMNode.getSchemaTemplateId() >= 0 && !this.templateTable.isEmpty()) {
            this.templateNodeList.add(basicMNode);
        }
        return basicMNode;
    }
}

